/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] _table;
    private int _size;
    private int _threshold;
    private final float _loadFactor;
    private volatile int _modCount;
    private Entry _entryCache;

    public IntMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this._loadFactor = loadFactor;
        this._threshold = (int)((float)capacity * loadFactor);
        this._table = new Entry[capacity];
    }

    public IntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntMap() {
        this._loadFactor = 0.75f;
        this._threshold = 16;
        this._table = new Entry[16];
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Object get(int key) {
        int i = IntMap.indexFor(key, this._table.length);
        Entry e = this._table[i];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return e;
    }

    public boolean containsKey(int key) {
        int i = IntMap.indexFor(key, this._table.length);
        Entry e = this._table[i];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object put(int key, Object value) {
        int i = IntMap.indexFor(key, this._table.length);
        Entry e = this._table[i];
        while (e != null) {
            if (key == e.key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this._modCount;
        this.addEntry(key, value, i);
        return null;
    }

    public Object remove(int key) {
        Entry prev;
        int i = IntMap.indexFor(key, this._table.length);
        Entry e = prev = this._table[i];
        while (e != null) {
            Entry next = e.next;
            if (key == e.key) {
                ++this._modCount;
                --this._size;
                if (prev == e) {
                    this._table[i] = next;
                } else {
                    prev.next = next;
                }
                e.next = this._entryCache;
                this._entryCache = e;
                return e.value;
            }
            prev = e;
            e = next;
        }
        return e == null ? e : e.value;
    }

    public void clear() {
        ++this._modCount;
        Entry[] tab = this._table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this._size = 0;
    }

    public Iterator entryIterator() {
        return new EntryIterator();
    }

    private static int indexFor(int key, int length) {
        return key & length - 1;
    }

    private void addEntry(int key, Object value, int bucketIndex) {
        Entry e;
        if (this._entryCache != null) {
            e = this._entryCache;
            this._entryCache = this._entryCache.next;
            e.key = key;
            e.value = value;
            e.next = this._table[bucketIndex];
        } else {
            e = new Entry(key, value, this._table[bucketIndex]);
        }
        this._table[bucketIndex] = e;
        if (this._size++ >= this._threshold) {
            this.resize(2 * this._table.length);
        }
    }

    private void resize(int newCapacity) {
        Entry[] oldTable = this._table;
        int oldCapacity = oldTable.length;
        if (this._size < this._threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this._table = newTable;
        this._threshold = (int)((float)newCapacity * this._loadFactor);
    }

    private void transfer(Entry[] newTable) {
        Entry[] src = this._table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = IntMap.indexFor(e.key, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    private class EntryIterator
    implements Iterator {
        private Entry _next;
        private int _expectedModCount;
        private int _index;
        private Entry _current;

        EntryIterator() {
            this._expectedModCount = IntMap.this._modCount;
            Entry[] t = IntMap.this._table;
            int i = t.length;
            Entry n = null;
            if (IntMap.this._size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this._next = n;
            this._index = i;
        }

        public boolean hasNext() {
            return this._next != null;
        }

        public Object next() {
            if (IntMap.this._modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this._next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = IntMap.this._table;
            int i = this._index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this._index = i;
            this._next = n;
            this._current = e;
            return this._current;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            if (IntMap.this._modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this._current.key;
            this._current = null;
            IntMap.this.remove(k);
            this._expectedModCount = IntMap.this._modCount;
        }
    }

    public static final class Entry {
        int key;
        Object value;
        Entry next;

        Entry(int k, Object v, Entry n) {
            this.key = k;
            this.value = v;
            this.next = n;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }
    }
}

