/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.LocalException;
import Ice.Logger;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RequestFailedException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.Reference;
import IceInternal.TraceLevels;

public final class ProxyFactory {
    private Instance _instance;
    private int[] _retryIntervals;

    public ObjectPrx stringToProxy(String str) {
        Reference ref = this._instance.referenceFactory().create(str);
        return this.referenceToProxy(ref);
    }

    public String proxyToString(ObjectPrx proxy) {
        if (proxy != null) {
            ObjectPrxHelperBase h = (ObjectPrxHelperBase)proxy;
            return h.__reference().toString();
        }
        return "";
    }

    public ObjectPrx streamToProxy(BasicStream s) {
        Identity ident = new Identity();
        ident.__read(s);
        Reference ref = this._instance.referenceFactory().create(ident, s);
        return this.referenceToProxy(ref);
    }

    public ObjectPrx referenceToProxy(Reference ref) {
        if (ref != null) {
            ObjectPrxHelperBase proxy = new ObjectPrxHelperBase();
            proxy.setup(ref);
            return proxy;
        }
        return null;
    }

    public void proxyToStream(ObjectPrx proxy, BasicStream s) {
        if (proxy != null) {
            ObjectPrxHelperBase h = (ObjectPrxHelperBase)proxy;
            Reference ref = h.__reference();
            ref.identity.__write(s);
            ref.streamWrite(s);
        } else {
            Identity ident = new Identity();
            ident.name = "";
            ident.category = "";
            ident.__write(s);
        }
    }

    public int checkRetryAfterException(LocalException ex, int cnt) {
        if (ex instanceof RequestFailedException) {
            throw ex;
        }
        ++cnt;
        TraceLevels traceLevels = this._instance.traceLevels();
        Logger logger = this._instance.logger();
        if (traceLevels != null && logger != null) {
            if (cnt > this._retryIntervals.length) {
                if (traceLevels.retry >= 1) {
                    String s = "cannot retry operation call because retry limit has been exceeded\n" + ex.toString();
                    logger.trace(traceLevels.retryCat, s);
                }
                throw ex;
            }
            if (traceLevels.retry >= 1) {
                String s = "re-trying operation call";
                if (cnt > 0 && this._retryIntervals[cnt - 1] > 0) {
                    s = s + " in " + this._retryIntervals[cnt - 1] + "ms";
                }
                s = s + " because of exception\n" + ex;
                logger.trace(traceLevels.retryCat, s);
            }
            if (cnt > 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(this._retryIntervals[cnt - 1]);
                }
                catch (InterruptedException ex1) {
                    // empty catch block
                }
            }
            return cnt;
        }
        throw ex;
    }

    ProxyFactory(Instance instance) {
        this._instance = instance;
        String str = this._instance.properties().getPropertyWithDefault("Ice.RetryIntervals", "0");
        String[] arr = str.trim().split("[ \t\n\r]+");
        if (arr.length > 0) {
            this._retryIntervals = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                int v;
                try {
                    v = Integer.parseInt(arr[i]);
                }
                catch (NumberFormatException ex) {
                    v = 0;
                }
                if (i == 0 && v == -1) {
                    this._retryIntervals = new int[0];
                    break;
                }
                this._retryIntervals[i] = v > 0 ? v : 0;
            }
        } else {
            this._retryIntervals = new int[1];
            this._retryIntervals[0] = 0;
        }
    }
}

