/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DNSException;
import Ice.EndpointParseException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.Endpoint;
import IceInternal.EndpointHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpAcceptor;
import IceInternal.TcpConnector;
import IceInternal.Transceiver;
import java.net.InetSocketAddress;

final class TcpEndpoint
implements Endpoint {
    static final short TYPE = 1;
    private Instance _instance;
    private String _host;
    private int _port;
    private int _timeout;
    private boolean _compress;
    private int _hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TcpEndpoint(Instance instance, String ho, int po, int ti, boolean co) {
        this._instance = instance;
        this._host = ho;
        this._port = po;
        this._timeout = ti;
        this._compress = co;
        this.calcHashValue();
    }

    public TcpEndpoint(Instance instance, String str) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._timeout = -1;
        this._compress = false;
        String[] arr = str.split("[ \t\n\r]+");
        int i = 0;
        block10: while (i < arr.length) {
            String option;
            if (arr[i].length() == 0) {
                ++i;
                continue;
            }
            if ((option = arr[i++]).length() != 2 || option.charAt(0) != '-') {
                EndpointParseException e = new EndpointParseException();
                e.str = "tcp " + str;
                throw e;
            }
            String argument = null;
            if (i < arr.length && arr[i].charAt(0) != '-') {
                argument = arr[i++];
            }
            switch (option.charAt(1)) {
                case 'h': {
                    if (argument == null) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "tcp " + str;
                        throw e;
                    }
                    this._host = argument;
                    continue block10;
                }
                case 'p': {
                    if (argument == null) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "tcp " + str;
                        throw e;
                    }
                    try {
                        this._port = Integer.parseInt(argument);
                        continue block10;
                    }
                    catch (NumberFormatException ex) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "tcp " + str;
                        throw e;
                    }
                }
                case 't': {
                    if (argument == null) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "tcp " + str;
                        throw e;
                    }
                    try {
                        this._timeout = Integer.parseInt(argument);
                        continue block10;
                    }
                    catch (NumberFormatException ex) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "tcp " + str;
                        throw e;
                    }
                }
                case 'z': {
                    if (argument != null) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "tcp " + str;
                        throw e;
                    }
                    this._compress = true;
                    continue block10;
                }
            }
            EndpointParseException e = new EndpointParseException();
            e.str = "tcp " + str;
            throw e;
        }
        if (this._host == null) {
            this._host = this._instance.defaultsAndOverrides().defaultHost;
        }
        this.calcHashValue();
    }

    public TcpEndpoint(BasicStream s) {
        this._instance = s.instance();
        s.startReadEncaps();
        this._host = s.readString();
        this._port = s.readInt();
        this._timeout = s.readInt();
        this._compress = s.readBool();
        s.endReadEncaps();
        this.calcHashValue();
    }

    public void streamWrite(BasicStream s) {
        s.writeShort((short)1);
        s.startWriteEncaps();
        s.writeString(this._host);
        s.writeInt(this._port);
        s.writeInt(this._timeout);
        s.writeBool(this._compress);
        s.endWriteEncaps();
    }

    public String toString() {
        String s = "tcp -h " + this._host + " -p " + this._port;
        if (this._timeout != -1) {
            s = s + " -t " + this._timeout;
        }
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    public short type() {
        return 1;
    }

    public int timeout() {
        return this._timeout;
    }

    public Endpoint timeout(int timeout) {
        if (timeout == this._timeout) {
            return this;
        }
        return new TcpEndpoint(this._instance, this._host, this._port, timeout, this._compress);
    }

    public boolean compress() {
        return this._compress;
    }

    public Endpoint compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new TcpEndpoint(this._instance, this._host, this._port, this._timeout, compress);
    }

    public boolean datagram() {
        return false;
    }

    public boolean secure() {
        return false;
    }

    public boolean unknown() {
        return false;
    }

    public Transceiver clientTransceiver() {
        return null;
    }

    public Transceiver serverTransceiver(EndpointHolder endpoint) {
        endpoint.value = this;
        return null;
    }

    public Connector connector() {
        return new TcpConnector(this._instance, this._host, this._port);
    }

    public Acceptor acceptor(EndpointHolder endpoint) {
        TcpAcceptor p = new TcpAcceptor(this._instance, this._host, this._port);
        endpoint.value = new TcpEndpoint(this._instance, this._host, p.effectivePort(), this._timeout, this._compress);
        return p;
    }

    public boolean equivalent(Transceiver transceiver) {
        return false;
    }

    public boolean equivalent(Acceptor acceptor) {
        TcpAcceptor tcpAcceptor = null;
        try {
            tcpAcceptor = (TcpAcceptor)acceptor;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return tcpAcceptor.equivalent(this._host, this._port);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        TcpEndpoint p = null;
        try {
            p = (TcpEndpoint)obj;
        }
        catch (ClassCastException ex) {
            return 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._port < p._port) {
            return -1;
        }
        if (p._port < this._port) {
            return 1;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        if (!this._host.equals(p._host)) {
            InetSocketAddress laddr = null;
            try {
                laddr = Network.getAddress(this._host, this._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            InetSocketAddress raddr = null;
            try {
                raddr = Network.getAddress(p._host, p._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            if (laddr == null && raddr != null) {
                return -1;
            }
            if (raddr == null && laddr != null) {
                return 1;
            }
            if (laddr != null && raddr != null) {
                byte[] larr = laddr.getAddress().getAddress();
                byte[] rarr = raddr.getAddress().getAddress();
                if (!$assertionsDisabled && larr.length != rarr.length) {
                    throw new AssertionError();
                }
                for (int i = 0; i < larr.length; ++i) {
                    if (larr[i] < rarr[i]) {
                        return -1;
                    }
                    if (rarr[i] >= larr[i]) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    private void calcHashValue() {
        this._hashCode = this._host.hashCode();
        this._hashCode = 5 * this._hashCode + this._port;
        this._hashCode = 5 * this._hashCode + this._timeout;
        this._hashCode = 5 * this._hashCode + (this._compress ? 1 : 0);
    }

    static {
        $assertionsDisabled = !TcpEndpoint.class.desiredAssertionStatus();
    }
}

