/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.DNA;
import bilab.Notify;
import bilab.RNA;
import bilab.ViewerBase;
import bilab.molecule;
import bilab.protein;
import bilab.seq;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import scigol.Debug;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.FeatureList;
import uk.ac.sanger.artemis.io.BioJavaEntry;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class ArtemisViewer
extends ViewerBase {
    protected ArtemisPanel artemisPanel;
    public static final String inlinePrefix = "sequence://";
    Composite embed;
    Composite fixed;
    Frame compositeFrame;
    seq sequence;

    public ArtemisViewer(Composite parent) {
        this.fixed = new Composite(parent, 2048);
        this.fixed.setLayout((Layout)new FillLayout());
        this.fixed.setSize(300, 300);
        this.embed = new Composite(this.fixed, 0x1000000);
        this.compositeFrame = SWT_AWT.new_Frame((Composite)this.embed);
        this.artemisPanel = new ArtemisPanel();
        this.compositeFrame.add(this.artemisPanel);
        this.sequence = null;
    }

    public Point preferedSize() {
        return new Point(-1, 182);
    }

    public Point maximumSize() {
        return new Point(1024, 1024);
    }

    public String get_title() {
        if (this.sequence == null) {
            return "molecule [JMol]";
        }
        return String.valueOf(this.sequence.get_name()) + " [JMol]";
    }

    public String get_description() {
        if (this.sequence == null) {
            return "sequence: none";
        }
        return "molecule: " + this.sequence.get_DetailText();
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.fixed;
    }

    public Object getInput() {
        return this.sequence;
    }

    public void refresh() {
        this.fixed.redraw();
    }

    public void setInput(Object input) {
        if (input == null) {
            this.sequence = null;
        } else {
            Debug.Assert(input instanceof molecule);
            this.sequence = (seq)input;
        }
        BioJavaEntry bjentry = null;
        if (this.sequence instanceof DNA) {
            bjentry = new BioJavaEntry(((DNA)this.sequence).seq);
        } else if (this.sequence instanceof RNA) {
            bjentry = new BioJavaEntry(((RNA)this.sequence).seq);
        } else if (this.sequence instanceof protein) {
            bjentry = new BioJavaEntry(((protein)this.sequence).seq);
        } else {
            this.sequence = null;
        }
        if (this.sequence != null) {
            try {
                Entry entry = new Entry(bjentry);
                Bases bases = entry.getBases();
                SimpleEntryGroup entry_group = new SimpleEntryGroup(bases);
                entry_group.add(entry);
                SimpleGotoEventSource goto_event_source = new SimpleGotoEventSource(entry_group);
                Selection selection = new Selection(null);
                entry_group.addFeatureChangeListener(selection);
                entry_group.addEntryChangeListener(selection);
                String name = entry_group.getDefaultEntry().getName();
                Box vbox_panel = Box.createVerticalBox();
                Box hbox_panel = Box.createHorizontalBox();
                hbox_panel.add(vbox_panel);
                Box topvbox_panel = Box.createVerticalBox();
                topvbox_panel.add(new JLabel(String.valueOf(name) + ":"));
                topvbox_panel.add(hbox_panel);
                this.artemisPanel.setLayout(new BorderLayout());
                this.artemisPanel.add((Component)topvbox_panel, "North");
                BasePlotGroup base_plot_group = new BasePlotGroup(entry_group, this.artemisPanel, selection, goto_event_source);
                vbox_panel.add(base_plot_group);
                base_plot_group.setVisible(true);
                FeatureDisplay base_display = new FeatureDisplay(entry_group, selection, goto_event_source, base_plot_group);
                base_display.setShowLabels(false);
                base_display.setScaleFactor(0);
                vbox_panel.add(base_display);
                base_display.setVisible(true);
                int feature_count = entry_group.getAllFeaturesCount();
                if (feature_count > 0) {
                    FeatureList feature_list = new FeatureList(entry_group, selection, goto_event_source, base_plot_group);
                    hbox_panel.add(feature_list);
                    feature_list.setVisible(true);
                }
            }
            catch (OutOfRangeException outOfRangeException) {
                this.sequence = null;
            }
            catch (NoSequenceException noSequenceException) {
                this.sequence = null;
            }
        }
        if (this.sequence == null) {
            Notify.devWarning((Object)this, "ArtemisViewer.setInput() - seq is null");
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public static class ArtemisPanel
    extends JPanel {
    }
}

