/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.ViewerBase;
import bilab.alignment;
import jalview.AlignmentPanel;
import jalview.ClustalxColourScheme;
import jalview.DrawableSequence;
import jalview.ResidueProperties;
import jalview.ScorePanel;
import jalview.ScoreSequence;
import jalview.SequenceGroup;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public class JalViewAlignmentViewer
extends ViewerBase {
    Composite fixed;
    Composite top;
    Container child;
    Frame compositeFrame;
    Label label;
    AlignmentPanel ap;
    ScorePanel sp;
    alignment input;

    public JalViewAlignmentViewer(Composite parent) {
        this.fixed = new Composite(parent, 0);
        this.fixed.setLayout((Layout)new FillLayout());
        this.fixed.setSize(300, 300);
        this.top = new Composite(this.fixed, 0x1000000);
        this.compositeFrame = SWT_AWT.new_Frame((Composite)this.top);
        this.child = new Panel();
        this.compositeFrame.add(this.child);
        this.label = new Label("<no alignment>");
        this.child.add(this.label);
        this.ap = null;
        this.input = null;
        this.refresh();
    }

    public void dispose() {
    }

    public Point preferedSize() {
        return new Point(700, 200);
    }

    public Point maximumSize() {
        return new Point(1024, 200);
    }

    public String get_title() {
        return "alignment";
    }

    public String get_description() {
        return this.get_title();
    }

    public Control getControl() {
        return this.top;
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        this.compositeFrame.invalidate();
        this.child.invalidate();
        this.compositeFrame.setVisible(true);
        this.compositeFrame.repaint();
    }

    public void setInput(Object input) {
        if (this.input == input) {
            return;
        }
        if (input != null && input instanceof alignment) {
            this.input = (alignment)input;
        }
        this.child.removeAll();
        if (this.input != null) {
            DrawableSequence[] ds = new DrawableSequence[this.input.alignedSeqs.length];
            int i = 0;
            while (i < this.input.alignedSeqs.length) {
                ds[i] = new DrawableSequence(this.input.alignedSeqs[i]);
                ++i;
            }
            this.ap = new AlignmentPanel(this.child, ds);
            this.ap.seqPanel.align.percentIdentity2();
            this.ap.seqPanel.align.findQuality();
            this.input.seqScores = new ScoreSequence[1];
            this.input.seqScores[0] = this.ap.seqPanel.align.qualityScore;
            this.ap.setSequenceColor(new ClustalxColourScheme(this.ap.seqPanel.align.cons2, this.ap.seqPanel.align.size()));
            this.ap.color = ResidueProperties.color;
            this.ap.groupEdit = false;
            i = 0;
            while (i < this.ap.seqPanel.align.groups.size()) {
                SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(i);
                sg.displayBoxes = true;
                this.ap.seqPanel.align.displayBoxes(sg);
                ++i;
            }
            ScorePanel sp = new ScorePanel(this.child, this.input.seqScores);
            this.ap.seqPanel.seqCanvas.showScores = true;
            this.ap.idPanel.idCanvas.showScores = true;
            this.ap.seqPanel.seqCanvas.setFont(new Font("Courier", 0, 12));
            sp.seqPanel.seqCanvas.setFont(new Font("Courier", 0, 12));
            this.child.setLayout(new BorderLayout());
            this.child.add("Center", this.ap);
            this.child.add("South", sp);
            this.compositeFrame.layout();
            this.refresh();
        } else {
            this.label = new Label("<no alignment>");
            this.child.add(this.label);
            this.ap = null;
            this.sp = null;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }
}

