/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.MoleculeImpl;
import bilab.Notify;
import bilab.Sophistication;
import bilab.Summary;
import bilab.protein;
import bilab.seq;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import scigol.Any;
import scigol.Debug;
import scigol.List;
import scigol.Map;
import scigol.Range;
import scigol.accessor;

@Summary(value="A RNA sequence molecule")
public class RNA
extends seq
implements Cloneable {
    @Summary(value="The underlying biojava Sequence representing this RNA")
    @Sophistication(value=2)
    public Sequence seq;

    public RNA() {
        try {
            this.seq = RNATools.createRNASequence((String)"", (String)"rna");
        }
        catch (BioException bioException) {
            Debug.Assert(false, "biojava error");
        }
    }

    public RNA(Sequence s) {
        this.seq = s;
    }

    public RNA(String seq2) {
        try {
            this.seq = RNATools.createRNASequence((String)seq2, (String)"rna");
        }
        catch (BioException e) {
            throw new BilabException("biojava error", e);
        }
    }

    public Object clone() {
        Notify.devWarning(this, "clone(): features not cloned");
        RNA copy = null;
        try {
            copy = (RNA)super.clone();
            copy.seq = RNATools.createRNASequence((String)this.seq.seqString(), (String)this.seq.getName());
            RNA.addAnnotationsToSequence(copy.seq, this.get_annotations());
        }
        catch (IllegalSymbolException illegalSymbolException) {
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return copy;
    }

    @accessor
    public RNA get_Item(Range r) {
        r = r.normalize(this.seq.length());
        return new RNA(this.seq.subStr(r.start + 1, r.end + 1));
    }

    @accessor
    public Any get_Item(int i) {
        try {
            Symbol sym = this.seq.symbolAt(i + 1);
            Alphabet alpha = sym.getMatches();
            List mols = new List();
            if (alpha.contains((Symbol)RNATools.a())) {
                mols.add(MoleculeImpl.A);
            }
            if (alpha.contains((Symbol)RNATools.c())) {
                mols.add(MoleculeImpl.C);
            }
            if (alpha.contains((Symbol)RNATools.g())) {
                mols.add(MoleculeImpl.G);
            }
            if (alpha.contains((Symbol)RNATools.u())) {
                mols.add(MoleculeImpl.U);
            }
            if (mols.get_size() == 1) {
                return mols.get_head();
            }
            return new Any(mols);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new BilabException("index must be in range 0.." + (this.seq.length() - 1) + ", not " + i);
        }
    }

    @accessor
    public void set_Item(int i, Any value) {
        Debug.Unimplemented();
    }

    public static RNA op_UnaryNegation(RNA rna) {
        return rna.get_Compliment();
    }

    @accessor
    public RNA get_Compliment() {
        try {
            return new RNA((Sequence)new SimpleSequence(RNATools.reverseComplement((SymbolList)this.seq), String.valueOf(this.seq.getURN()) + "|compliment", String.valueOf(this.seq.getName()) + " compliment", this.seq.getAnnotation()));
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BilabException("Cannot reverse compliment RNA with alphabet '" + this.seq.getAlphabet().getName() + "'");
        }
    }

    public static protein translate(RNA rna) {
        return rna.get_translation();
    }

    @accessor
    public protein get_translation() {
        try {
            return new protein((Sequence)new SimpleSequence(RNATools.translate((SymbolList)this.seq), String.valueOf(this.seq.getURN()) + "|translation", String.valueOf(this.seq.getName()) + " translation", this.seq.getAnnotation()));
        }
        catch (BioException e) {
            throw new BilabException("biojava error", e);
        }
    }

    public static RNA op_Addition(RNA rna1, RNA rna2) {
        String seq1 = rna1.get_rawsequence();
        String seq2 = rna2.get_rawsequence();
        return new RNA(String.valueOf(seq1) + seq2);
    }

    public static int op_Card(RNA rna) {
        return rna.seq.length();
    }

    @accessor
    public String get_name() {
        return this.seq.getName();
    }

    @accessor
    public String get_ShortText() {
        return this.get_name();
    }

    @accessor
    public String get_DetailText() {
        return this.get_ShortText();
    }

    @Summary(value="get sequence as a string of letters formatted into columns")
    public String get_sequence() {
        return RNA.formatSeqString(this.seq.seqString().toUpperCase());
    }

    @Summary(value="get sequence as a string of continous letters")
    public String get_rawsequence() {
        return this.seq.seqString().toUpperCase();
    }

    public Map get_annotations() {
        Map m = new Map();
        for (Object key : this.seq.getAnnotation().keys()) {
            m.add(key, this.seq.getAnnotation().getProperty(key));
        }
        return m;
    }

    public String toString() {
        return super.toString().toUpperCase();
    }
}

