/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook;

import bilab.notebook.model.GraphicsDiagram;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NotebookPageCreationWizard
extends Wizard
implements INewWizard {
    private static int fileCount = 1;
    private CreationPage page1;

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page1 = new CreationPage(workbench, selection);
    }

    public boolean performFinish() {
        return this.page1.finish();
    }

    private class CreationPage
    extends WizardNewFileCreationPage {
        private static final String DEFAULT_EXTENSION = ".npg";
        private final IWorkbench workbench;

        CreationPage(IWorkbench workbench, IStructuredSelection selection) {
            super("shapeCreationPage1", selection);
            this.workbench = workbench;
            this.setTitle("Create a new .npg file");
            this.setDescription("Create a new .npg file");
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.setFileName("shapesExample" + fileCount + DEFAULT_EXTENSION);
            this.setPageComplete(this.validatePage());
        }

        private Object createDefaultContent() {
            return new GraphicsDiagram();
        }

        boolean finish() {
            IFile newFile = this.createNewFile();
            fileCount = fileCount + 1;
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            if (newFile != null && page != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        protected InputStream getInitialContents() {
            ByteArrayInputStream bais = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.createDefaultContent());
                oos.flush();
                oos.close();
                bais = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return bais;
        }

        private boolean validateFilename() {
            if (this.getFileName() != null && this.getFileName().endsWith(DEFAULT_EXTENSION)) {
                return true;
            }
            this.setErrorMessage("The 'file' name must end with .npg");
            return false;
        }

        protected boolean validatePage() {
            return super.validatePage() && this.validateFilename();
        }
    }
}

