/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook;

import bilab.BilabPlugin;
import bilab.notebook.model.Connection;
import bilab.notebook.model.EllipticalGraphic;
import bilab.notebook.model.RectangularGraphic;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

final class NotebookPageEditorPaletteFactory {
    private static final int DEFAULT_PALETTE_SIZE = 125;
    private static final String PALETTE_DOCK_LOCATION = "ShapesEditorPaletteFactory.Location";
    private static final String PALETTE_SIZE = "ShapesEditorPaletteFactory.Size";
    private static final String PALETTE_STATE = "ShapesEditorPaletteFactory.State";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static PaletteContainer createShapesDrawer() {
        PaletteDrawer componentsDrawer = new PaletteDrawer("Graphics");
        CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry("Ellipse", "Create an elliptical shape", EllipticalGraphic.class, (CreationFactory)new SimpleFactory(EllipticalGraphic.class), ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/ellipse16.gif"), ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/ellipse24.gif"));
        componentsDrawer.add((PaletteEntry)component);
        component = new CombinedTemplateCreationEntry("Rectangle", "Create a rectangular shape", RectangularGraphic.class, (CreationFactory)new SimpleFactory(RectangularGraphic.class), ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/rectangle16.gif"), ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/rectangle24.gif"));
        componentsDrawer.add((PaletteEntry)component);
        return componentsDrawer;
    }

    static PaletteRoot createPalette() {
        PaletteRoot palette = new PaletteRoot();
        palette.add((PaletteEntry)NotebookPageEditorPaletteFactory.createToolsGroup(palette));
        palette.add((PaletteEntry)NotebookPageEditorPaletteFactory.createShapesDrawer());
        return palette;
    }

    static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        NotebookPageEditorPaletteFactory.getPreferenceStore().setDefault(PALETTE_DOCK_LOCATION, -1);
        NotebookPageEditorPaletteFactory.getPreferenceStore().setDefault(PALETTE_STATE, -1);
        NotebookPageEditorPaletteFactory.getPreferenceStore().setDefault(PALETTE_SIZE, 125);
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return NotebookPageEditorPaletteFactory.getPreferenceStore().getInt(NotebookPageEditorPaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return NotebookPageEditorPaletteFactory.getPreferenceStore().getInt(NotebookPageEditorPaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return NotebookPageEditorPaletteFactory.getPreferenceStore().getInt(NotebookPageEditorPaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                NotebookPageEditorPaletteFactory.getPreferenceStore().setValue(NotebookPageEditorPaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                NotebookPageEditorPaletteFactory.getPreferenceStore().setValue(NotebookPageEditorPaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                NotebookPageEditorPaletteFactory.getPreferenceStore().setValue(NotebookPageEditorPaletteFactory.PALETTE_SIZE, width);
            }
        };
    }

    private static PaletteContainer createToolsGroup(PaletteRoot palette) {
        PaletteGroup toolGroup = new PaletteGroup("Tools");
        SelectionToolEntry tool = new SelectionToolEntry();
        toolGroup.add((PaletteEntry)tool);
        palette.setDefaultEntry((ToolEntry)tool);
        toolGroup.add((PaletteEntry)new MarqueeToolEntry());
        toolGroup.add((PaletteEntry)new PaletteSeparator());
        tool = new ConnectionCreationToolEntry("Solid connection", "Create a solid-line connection", new CreationFactory(){

            public Object getNewObject() {
                return null;
            }

            public Object getObjectType() {
                return Connection.SOLID_CONNECTION;
            }
        }, ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/connection_s16.gif"), ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/connection_s24.gif"));
        toolGroup.add((PaletteEntry)tool);
        tool = new ConnectionCreationToolEntry("Dashed connection", "Create a dashed-line connection", new CreationFactory(){

            public Object getNewObject() {
                return null;
            }

            public Object getObjectType() {
                return Connection.DASHED_CONNECTION;
            }
        }, ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/connection_d16.gif"), ImageDescriptor.createFromFile(BilabPlugin.class, (String)"notebook/icons/connection_d24.gif"));
        toolGroup.add((PaletteEntry)tool);
        return toolGroup;
    }

    private static IPreferenceStore getPreferenceStore() {
        return BilabPlugin.getDefault().getPreferenceStore();
    }

    private NotebookPageEditorPaletteFactory() {
    }
}

