/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.IAnnotated;
import bilab.IResourceIOProvider;
import bilab.IUserText;
import bilab.Notify;
import bilab.ResourceManager;
import bilab.Sophistication;
import bilab.Summary;
import bilab.Util;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import scigol.Map;
import scigol.TypeSpec;
import scigol.accessor;
import scigol.signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class tree
implements IAnnotated,
IUserText,
IResourceIOProvider {
    private static final List<String> supportedImportResourceTypes = new LinkedList<String>();
    private static final List<String> supportedExportResourceTypes;
    private String name;
    private scigol.List _children;
    private Map _annotations;
    static /* synthetic */ Class class$0;

    static {
        supportedImportResourceTypes.add("Newick");
        supportedExportResourceTypes = new LinkedList<String>();
        supportedExportResourceTypes.add("Newick");
        supportedExportResourceTypes.add("list(Newick)");
    }

    @Summary(value="create a tree with no children")
    public tree() {
        this._children = new scigol.List();
        this._annotations = new Map();
        this.name = "<tree>";
    }

    @Summary(value="create a new tree from a Newick formatted string")
    @signature(value="explicit func(newickString:string -> self)")
    public tree(String newickString) {
        tree t = tree.parseNewick(newickString);
        this._children = t._children;
        this._annotations = t._annotations;
    }

    @accessor
    public scigol.List get_children() {
        return this._children;
    }

    @accessor
    public void set_children(scigol.List children) {
        int c = 0;
        while (c < children.get_size()) {
            if (!(children.get_Item((int)c).value instanceof tree)) {
                throw new BilabException("children of a tree must also be trees");
            }
            ++c;
        }
        this._children = children;
    }

    public void addChild(Object child) {
        this._children.add(child);
    }

    @Override
    public Map get_annotations() {
        return this._annotations;
    }

    public static List<String> getSupportedImportResourceTypes() {
        return supportedImportResourceTypes;
    }

    public static List<String> getSupportedExportResourceTypes() {
        return supportedExportResourceTypes;
    }

    @Sophistication(value=2)
    public static Object importResource(ResourceManager rm, String resourceName, String resourceType) {
        try {
            InputStream inputStream = rm.findResourceStream(resourceName);
            if (inputStream == null) {
                throw new BilabException("unable to open resource:" + resourceName);
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            int b = 0;
            while ((b = inputStream.read()) != -1) {
                bytes.write(b);
            }
            String newickString = bytes.toString();
            inputStream.close();
            tree t = tree.parseNewick(newickString);
            t.name = Util.name(resourceName);
            return t;
        }
        catch (BilabException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BilabException("unable to locate/import resource as tree: " + resourceName + " - " + e);
        }
    }

    @Summary(value="create a resource containing data in a supported format from a seq")
    public static void exportResource(ResourceManager rm, Object o, String resourceName, String resourceType) {
        block8: {
            try {
                if (resourceType.equals("Newick")) {
                    if (!(o instanceof tree)) {
                        Notify.devError(tree.class, "object for export of resource type Newick must be a tree");
                    }
                    OutputStream outStream = rm.createResourceStream(resourceName);
                    tree t = (tree)o;
                    String newickString = t.get_Newick();
                    outStream.write(newickString.getBytes());
                    outStream.flush();
                    outStream.close();
                    break block8;
                }
                if (resourceType.equals("list(Newick)")) {
                    if (!(o instanceof List)) {
                        Notify.devError(tree.class, "object for export of resource type list(Newick) must be a list");
                    }
                    OutputStream outStream = rm.createResourceStream(resourceName);
                    List l = (List)o;
                    int ti = 0;
                    while (ti < l.size()) {
                        Object e = TypeSpec.unwrapAny(l.get(ti));
                        if (!(e instanceof tree)) {
                            throw new BilabException("list must only contain elements of type 'tree'");
                        }
                        tree t = (tree)e;
                        String newickString = String.valueOf(t.get_Newick()) + "\r\n";
                        outStream.write(newickString.getBytes());
                        ++ti;
                    }
                    outStream.flush();
                    outStream.close();
                    break block8;
                }
                throw new BilabException("unsupported resource type:" + resourceType);
            }
            catch (Exception e) {
                throw new BilabException("unable to export tree as resource type: " + resourceType + " - " + e.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static char nextChar(ParseState ps) {
        if (ps.p < ps.s.length()) ** GOTO lbl4
        return '\u0000';
lbl-1000:
        // 1 sources

        {
            ++ps.p;
lbl4:
            // 2 sources

            ** while (ps.s.charAt((int)ps.p) == ' ' || ps.s.charAt((int)ps.p) == '\n' || ps.s.charAt((int)ps.p) == '\r')
        }
lbl5:
        // 1 sources

        return ps.s.charAt(ps.p++);
    }

    /*
     * Unable to fully structure code
     */
    protected static char peekChar(ParseState ps) {
        if (ps.p < ps.s.length()) ** GOTO lbl4
        return '\u0000';
lbl-1000:
        // 1 sources

        {
            ++ps.p;
lbl4:
            // 2 sources

            ** while (ps.s.charAt((int)ps.p) == ' ' || ps.s.charAt((int)ps.p) == '\n' || ps.s.charAt((int)ps.p) == '\r')
        }
lbl5:
        // 1 sources

        return ps.s.charAt(ps.p);
    }

    protected static tree parseNewick(String s) {
        ParseState ps = new ParseState();
        ps.s = s;
        ps.p = 0;
        tree t = tree.peekChar(ps) == '(' ? tree.parseTree(ps) : tree.parseLeaf(ps);
        char nextChar = tree.nextChar(ps);
        if (nextChar != ';' && nextChar != '\u0000') {
            throw new BilabException("Newick format tree must end in a ';'");
        }
        return t;
    }

    protected static tree parseLeaf(ParseState ps) {
        String name = tree.parseName(ps);
        tree leaf = new tree();
        leaf._annotations.add("name", name.replace('_', ' '));
        if (tree.peekChar(ps) == ':') {
            tree.nextChar(ps);
            double len = tree.parseLength(ps);
            leaf._annotations.add("length", len);
        }
        return leaf;
    }

    protected static tree parseTree(ParseState ps) {
        char lastChar;
        tree t = new tree();
        if (tree.nextChar(ps) != '(') {
            throw new BilabException("expected '(' in Newick tree format");
        }
        do {
            tree node;
            if (tree.peekChar(ps) != '(') {
                node = tree.parseLeaf(ps);
            } else {
                node = tree.parseTree(ps);
                if (tree.peekChar(ps) != ',' && tree.peekChar(ps) != ':') {
                    String name = tree.parseName(ps);
                    node._annotations.add("name", name.replace('_', ' '));
                }
                if (tree.peekChar(ps) == ':') {
                    tree.nextChar(ps);
                    double len = tree.parseLength(ps);
                    node._annotations.add("length", len);
                }
            }
            t._children.add(node);
        } while ((lastChar = tree.nextChar(ps)) == ',');
        if (lastChar != ')') {
            throw new BilabException("expected ')' in Newick tree format");
        }
        return t;
    }

    protected static String parseName(ParseState ps) {
        String name = "";
        while (tree.peekChar(ps) != ':' && tree.peekChar(ps) != ',' && tree.peekChar(ps) != ')' && tree.peekChar(ps) != ';' && tree.peekChar(ps) != '\u0000') {
            name = String.valueOf(name) + tree.nextChar(ps);
        }
        return name;
    }

    protected static double parseLength(ParseState ps) {
        double len = 0.0;
        double m = 1.0;
        boolean fraction = false;
        while (Character.isDigit(tree.peekChar(ps)) || !fraction && tree.peekChar(ps) == '.') {
            char c = tree.nextChar(ps);
            if (c != '.') {
                if (!fraction) {
                    len = 10.0 * len + (double)Character.getNumericValue(c);
                    continue;
                }
                len += (m *= 0.1) * (double)Character.getNumericValue(c);
                continue;
            }
            fraction = true;
        }
        return len;
    }

    protected static void toNewickString(tree t, StringBuilder sb) {
        String name;
        if (t._children.get_size() > 0) {
            sb.append("(");
        }
        int c = 0;
        while (c < t._children.get_size()) {
            tree.toNewickString((tree)t._children.get_Item((int)c).value, sb);
            if (c != t._children.get_size() - 1) {
                sb.append(", ");
            }
            ++c;
        }
        if (t._children.get_size() > 0) {
            sb.append(")");
        }
        if ((name = (String)t._annotations.get_Item((Object)"name").value) == null) {
            name = "";
        }
        sb.append(name.replace(' ', '_'));
        Double len = (Double)t._annotations.get_Item((Object)"length").value;
        if (len != null) {
            double d = len;
            if (d > 1.0E-5) {
                d = (double)((int)(100000.0 * d)) / 100000.0;
            }
            sb.append(":" + d);
        }
    }

    @accessor
    public String get_Newick() {
        StringBuilder sb = new StringBuilder();
        tree.toNewickString(this, sb);
        return String.valueOf(sb.toString()) + ";";
    }

    public String toString() {
        return this.get_Newick();
    }

    @Override
    public String get_ShortText() {
        return this.name;
    }

    @Override
    public String get_DetailText() {
        return "";
    }

    protected static class ParseState {
        String s;
        int p;

        protected ParseState() {
        }
    }
}

