/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.PDBChain;
import MCview.PDBfile;
import MCview.rotFrame;
import jalview.AlignSeq;
import jalview.AlignmentPanel;
import jalview.AppletFilePopup;
import jalview.AppletPostscriptPopup;
import jalview.BigPanel;
import jalview.Blosum62ColourScheme;
import jalview.BuriedColourScheme;
import jalview.ClustalwCGI;
import jalview.ClustalwThread;
import jalview.ClustalxColourScheme;
import jalview.ColourChooserFrame;
import jalview.Conservation;
import jalview.ConservationColourScheme;
import jalview.DrawableSequence;
import jalview.FeatureFrame;
import jalview.FilePopup;
import jalview.FileProperties;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.GroupPopup;
import jalview.HelixColourScheme;
import jalview.HydrophobicColourScheme;
import jalview.IncrementPopup;
import jalview.InputPopup;
import jalview.JnetCGI;
import jalview.MailProperties;
import jalview.MailTextPopup;
import jalview.OutputFilePopup;
import jalview.OutputGenerator;
import jalview.OutputPopup;
import jalview.PCAThread;
import jalview.PDBPopup;
import jalview.PIDColourScheme;
import jalview.PairAlignThread;
import jalview.PercentIdentityPopup;
import jalview.PostalCGI;
import jalview.Postscript;
import jalview.PostscriptFilePopup;
import jalview.PostscriptPopup;
import jalview.PostscriptProperties;
import jalview.ProgressFrame;
import jalview.RedundancyPopup;
import jalview.ResidueProperties;
import jalview.ScorePanel;
import jalview.ScoreSequence;
import jalview.Sequence;
import jalview.SequenceFeatureThread;
import jalview.SequenceGroup;
import jalview.SequenceNode;
import jalview.SimpleBrowser;
import jalview.StrandColourScheme;
import jalview.TaylorColourScheme;
import jalview.TextAreaPrintStream;
import jalview.TreeFile;
import jalview.TreeThread;
import jalview.TurnColourScheme;
import jalview.URLPopup;
import jalview.ZappoColourScheme;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class AlignFrame
extends Frame
implements OutputGenerator {
    MenuBar mb;
    Menu file;
    Menu edit;
    Menu font;
    Menu view;
    Menu colour;
    Menu calc;
    Menu help;
    Menu align;
    MenuItem gapCharacter;
    CheckboxMenuItem groupEdit;
    CheckboxMenuItem fastDraw;
    CheckboxMenuItem helvetica;
    CheckboxMenuItem courier;
    CheckboxMenuItem times;
    CheckboxMenuItem zappo;
    CheckboxMenuItem clustalx;
    CheckboxMenuItem taylor;
    CheckboxMenuItem Hydrophobicity;
    CheckboxMenuItem helix;
    CheckboxMenuItem strand;
    CheckboxMenuItem turn;
    CheckboxMenuItem buried;
    CheckboxMenuItem conservation;
    CheckboxMenuItem autoconsensus;
    CheckboxMenuItem PID;
    CheckboxMenuItem BLOSUM62;
    MenuItem features;
    MenuItem structures;
    MenuItem PIDthreshold;
    MenuItem incitem;
    MenuItem userColours;
    CheckboxMenuItem colourText;
    CheckboxMenuItem blackText;
    CheckboxMenuItem boxes;
    CheckboxMenuItem text;
    CheckboxMenuItem scores;
    public BigPanel bp;
    public AlignmentPanel ap;
    Object parent;
    Label status;
    Label redraw;
    Panel labelPanel;
    public Hashtable[] cons;
    public PCAThread pca;
    public TreeThread tt;
    public SimpleBrowser browser;
    public FeatureFrame ff;
    SequenceFeatureThread sft;
    String srsServer = "srs.ebi.ac.uk/srs5bin/cgi-bin/";
    String database = "swall";
    String tempdir = "temp";
    public MailProperties mp;
    public FileProperties fp;
    public PostscriptProperties pp;
    int threshold = 0;
    int increment = 30;

    public AlignFrame(Object parent) {
        this.bp = null;
        this.ap = null;
        this.parent = parent;
        this.frameInit();
        this.propertiesInit();
    }

    public AlignFrame(Object parent, DrawableSequence[] s) {
        this.bp = new BigPanel(this, s);
        this.ap = this.bp;
        this.parent = parent;
        this.frameInit();
        this.propertiesInit();
    }

    public AlignFrame(DrawableSequence[] s) {
        this.bp = new BigPanel(this, s);
        this.ap = this.bp;
        this.frameInit();
        this.propertiesInit();
    }

    public AlignFrame(Object parent, String input, String type, String format) {
        this.parent = parent;
        DrawableSequence[] s = null;
        s = FormatAdapter.toDrawableSequence(FormatAdapter.read(input, type, format));
        this.bp = new BigPanel(this, s);
        System.out.println("Made BigPanel");
        this.ap = this.bp;
        this.frameInit();
        System.out.println("finished framInit");
        this.propertiesInit();
        System.out.println("finished propertiesInit");
    }

    private void setQuality() {
        this.ap.seqPanel.align.percentIdentity2();
        this.ap.seqPanel.align.findQuality();
        DrawableSequence[] sseq = new ScoreSequence[]{this.ap.seqPanel.align.qualityScore};
        this.bp.setScorePanel(new ScorePanel(this, sseq));
    }

    public void propertiesInit() {
        this.mp = new MailProperties();
        this.mp.server = "circinus.ebi.ac.uk";
        this.pp = new PostscriptProperties();
        this.fp = new FileProperties();
    }

    public void frameInit() {
        System.out.println("Java version = " + System.getProperty("java.version"));
        this.fileMenu();
        this.editMenu();
        this.fontMenu();
        this.viewMenu();
        this.colourMenu();
        this.calcMenu();
        this.helpMenu();
        this.alignMenu();
        this.mb = new MenuBar();
        this.mb.add(this.file);
        this.mb.add(this.edit);
        this.mb.add(this.font);
        this.mb.add(this.view);
        this.mb.add(this.colour);
        this.mb.add(this.calc);
        this.mb.add(this.align);
        this.mb.add(this.help);
        this.setMenuBar(this.mb);
        this.setLayout(new BorderLayout());
        this.setQuality();
        this.status = new Label("Status : ", 0);
        this.redraw = new Label(" ", 2);
        this.labelPanel = new Panel();
        this.labelPanel.setLayout(new GridLayout(1, 2));
        this.add("South", this.labelPanel);
        this.labelPanel.add(this.status);
        this.labelPanel.add(this.redraw);
        this.add("Center", this.ap);
        this.resize(700, 500);
        this.show();
        this.updateFont();
        System.out.println("three");
        this.updateFont();
        System.out.println("four");
    }

    public void setStates(CheckboxMenuItem c, String label, boolean PIDthresh, boolean userThresh) {
        c.setState(true);
        if (c.getState()) {
            if (c != this.zappo) {
                this.zappo.setState(false);
            }
            if (c != this.taylor) {
                this.taylor.setState(false);
            }
            if (c != this.PID) {
                this.PID.setState(false);
            }
            if (c != this.BLOSUM62) {
                this.BLOSUM62.setState(false);
            }
            if (c != this.Hydrophobicity) {
                this.Hydrophobicity.setState(false);
            }
            if (c != this.helix) {
                this.helix.setState(false);
            }
            if (c != this.strand) {
                this.strand.setState(false);
            }
            if (c != this.turn) {
                this.turn.setState(false);
            }
            if (c != this.buried) {
                this.buried.setState(false);
            }
            if (c != this.clustalx) {
                this.clustalx.setState(false);
            }
            this.updateFont();
            if (PIDthresh) {
                this.PIDthreshold.enable();
            } else {
                this.PIDthreshold.disable();
            }
            if (c == this.zappo && userThresh) {
                this.userColours.enable();
            } else {
                this.userColours.disable();
            }
        }
        this.status.setText(label);
        this.status.validate();
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof CheckboxMenuItem) {
            String label = ((CheckboxMenuItem)e.target).getLabel();
            if (label.equals("Boxes")) {
                this.ap.seqPanel.seqCanvas.boxFlag = !this.ap.seqPanel.seqCanvas.boxFlag;
                this.setBoxes(this.boxes.getState());
                this.updateFont();
                if (this.boxes.getState()) {
                    this.status.setText("Residue boxes on");
                } else {
                    this.status.setText("Residue boxes off");
                }
                this.status.validate();
            } else if (label.equals("Scores")) {
                this.ap.seqPanel.seqCanvas.showScores = this.scores.getState();
                this.ap.idPanel.idCanvas.showScores = this.scores.getState();
                this.updateFont();
                if (this.scores.getState()) {
                    this.status.setText("Showing scores");
                } else {
                    this.status.setText("Hiding scores");
                }
            } else if (label.equals("Group editing mode")) {
                this.ap.groupEdit = this.groupEdit.getState();
                if (this.ap.groupEdit) {
                    this.status.setText("Group editing mode on");
                } else {
                    this.status.setText("Group editing mode off");
                }
                this.status.validate();
            } else if (label.equals("Text")) {
                this.ap.seqPanel.seqCanvas.textFlag = !this.ap.seqPanel.seqCanvas.textFlag;
                this.setText(this.text.getState());
                this.updateFont();
                if (this.text.getState()) {
                    this.status.setText("Residue text on");
                } else {
                    this.status.setText("Residue text off");
                }
                this.status.validate();
            } else if (label.equals("Zappo Colourscheme")) {
                this.status.setText("Setting Zappo colours...");
                this.status.validate();
                this.ap.setSequenceColor(new ZappoColourScheme());
                this.ap.color = ResidueProperties.color;
                this.setStates(this.zappo, label, true, true);
            } else if (label.equals("Clustalx colours")) {
                this.status.setText("Setting clustalx colours...");
                this.status.validate();
                this.incitem.disable();
                this.conservation.disable();
                long start = System.currentTimeMillis();
                this.ap.seqPanel.align.percentIdentity2();
                long end = System.currentTimeMillis();
                System.out.println("Time for consensus " + (end - start));
                start = System.currentTimeMillis();
                this.ap.setSequenceColor(new ClustalxColourScheme(this.ap.seqPanel.align.cons2, this.ap.seqPanel.align.size()));
                end = System.currentTimeMillis();
                System.out.println("Time for colours " + (end - start));
                this.ap.color = ResidueProperties.color;
                this.setStates(this.clustalx, label, false, false);
            } else if (label.equals("Strand propensity")) {
                this.status.setText("Setting strand colours...");
                this.status.validate();
                this.ap.setSequenceColor(new StrandColourScheme());
                this.setStates(this.strand, "Strand propensity", true, true);
            } else if (label.equals("Helix propensity")) {
                this.status.setText("Setting helix colours...");
                this.status.validate();
                this.ap.setSequenceColor(new HelixColourScheme());
                this.setStates(this.helix, "Helix propensity", true, true);
            } else if (label.equals("Turn propensity")) {
                this.status.setText("Setting turn colours...");
                this.status.validate();
                this.ap.setSequenceColor(new TurnColourScheme());
                this.setStates(this.turn, "Turn propensity", true, true);
            } else if (label.equals("Buried index")) {
                this.status.setText("Setting buried colours...");
                this.status.validate();
                this.ap.setSequenceColor(new BuriedColourScheme());
                this.setStates(this.helix, "Buried index", true, true);
            } else if (label.equals("Taylor Colourscheme")) {
                this.status.setText("Setting Taylor colours...");
                this.status.validate();
                this.ap.setSequenceColor(new TaylorColourScheme());
                this.setStates(this.taylor, "Willie Taylor Colours", true, true);
            } else if (label.equals("By PID")) {
                this.status.setText("Setting PID colours...");
                this.status.validate();
                this.ap.seqPanel.align.percentIdentity();
                this.ap.setSequenceColor(new PIDColourScheme(this.ap.seqPanel.align.cons));
                this.setStates(this.PID, "Percentage identity colours", false, false);
            } else if (label.equals("By BLOSUM62 score")) {
                this.status.setText("Setting BLOSUM62 colours...");
                this.status.validate();
                this.ap.setSequenceColor(new Blosum62ColourScheme());
                this.setStates(this.BLOSUM62, "BLOSUM62 score colours", false, false);
            } else if (label.equals("By Hydrophobicity")) {
                this.status.setText("Setting hydrophobicity colours...");
                this.status.validate();
                this.ap.setSequenceColor(new HydrophobicColourScheme());
                this.setStates(this.Hydrophobicity, "colour by hydrophobicity", true, false);
            } else if (label.equals("By conservation")) {
                if (this.conservation.getState()) {
                    this.status.setText("Colouring by conservation");
                    this.status.validate();
                    this.incitem.enable();
                    this.ap.conservation = true;
                    int j = 0;
                    while (j < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(j);
                        if (sg.conserve != null) {
                            sg.colourScheme = new ConservationColourScheme(sg);
                            sg.colourScheme.setColours(sg);
                            this.updateFont();
                        }
                        ++j;
                    }
                } else {
                    this.status.setText("No conservation colouring");
                    this.status.validate();
                    this.incitem.disable();
                    this.ap.conservation = false;
                    if (!this.PID.getState() || !this.BLOSUM62.getState()) {
                        this.PIDthreshold.enable();
                    }
                    int j = 0;
                    while (j < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(j);
                        if (sg.colourScheme instanceof ConservationColourScheme) {
                            sg.colourScheme = ((ConservationColourScheme)sg.colourScheme).cs;
                            sg.colourScheme.setColours(sg);
                            this.updateFont();
                        }
                        ++j;
                    }
                }
            } else if (label.equals("Colour text")) {
                this.ap.seqPanel.seqCanvas.colourText = this.colourText.getState();
                this.blackText.setState(!this.colourText.getState());
                this.setColourText(this.colourText.getState());
                if (this.colourText.getState()) {
                    this.status.setText("Colouring text");
                    this.status.validate();
                } else {
                    this.status.setText("Text colour black");
                    this.status.validate();
                }
                this.updateFont();
            } else if (label.equals("Black text")) {
                this.ap.seqPanel.seqCanvas.colourText = !this.blackText.getState();
                this.colourText.setState(!this.blackText.getState());
                this.setColourText(this.colourText.getState());
                this.updateFont();
                if (this.colourText.getState()) {
                    this.status.setText("Colouring text");
                    this.status.validate();
                } else {
                    this.status.setText("Text colour black");
                    this.status.validate();
                }
            } else if (label.equals("Fast Draw")) {
                this.ap.seqPanel.setFastDraw(this.fastDraw.getState());
                if (this.bp.scorePanel != null) {
                    this.bp.scorePanel.seqPanel.setFastDraw(this.fastDraw.getState());
                }
                if (this.fastDraw.getState()) {
                    this.status.setText("Fast draw mode on");
                    this.status.validate();
                    this.courier.setState(false);
                    this.times.setState(false);
                    this.helvetica.setState(false);
                    this.times.disable();
                    this.helvetica.disable();
                    this.courier.disable();
                    this.setFont("Courier");
                    this.updateFont();
                } else {
                    this.status.setText("Fast draw mode off");
                    this.status.validate();
                    this.courier.setState(true);
                    this.times.setState(false);
                    this.helvetica.setState(false);
                    this.times.enable();
                    this.helvetica.enable();
                    this.courier.enable();
                    this.setFont("Courier");
                    this.updateFont();
                }
            } else if (label.equals("Helvetica")) {
                this.status.setText("Changing font...");
                this.status.validate();
                this.helvetica.setState(true);
                this.times.setState(false);
                this.courier.setState(false);
                if (!this.ap.seqPanel.seqCanvas.fontName.equals("Helvetica")) {
                    this.setFont("Helvetica");
                }
            } else if (label.equals("Courier")) {
                this.status.setText("Changing font...");
                this.status.validate();
                this.helvetica.setState(false);
                this.times.setState(false);
                this.courier.setState(true);
                if (!this.ap.seqPanel.seqCanvas.fontName.equals("Courier")) {
                    this.setFont("Courier");
                }
            } else if (label.equals("Times-Roman")) {
                this.status.setText("Changing font...");
                this.status.validate();
                this.helvetica.setState(false);
                this.times.setState(true);
                this.courier.setState(false);
                if (!this.ap.seqPanel.seqCanvas.fontName.equals("TimesRoman")) {
                    this.setFont("TimesRoman");
                }
            } else if (label.equals("Autocalculate consensus")) {
                if (this.ap.seqPanel.align.autoConsensus) {
                    this.status.setText("Automatic consensus calculation OFF");
                } else {
                    this.status.setText("Automatic consensus calculation ON");
                }
                this.ap.seqPanel.align.autoConsensus = !this.ap.seqPanel.align.autoConsensus;
                this.autoconsensus.setState(this.ap.seqPanel.align.autoConsensus);
            }
        } else {
            if (e.target instanceof MenuItem) {
                String label = (String)arg;
                if (label.equals("Quit")) {
                    this.status.setText("Closing frame...");
                    this.status.validate();
                    this.hide();
                    this.dispose();
                    System.out.println(this.parent);
                    if (!(this.parent instanceof Applet)) {
                        this.status.setText("Exiting...");
                        this.status.validate();
                        System.exit(0);
                    }
                } else if (label.equals("Close")) {
                    this.status.setText("Closing frame...");
                    this.status.validate();
                    this.hide();
                    this.dispose();
                } else if (label.equals("Set gap character to .")) {
                    this.status.setText("Changing gap character...");
                    this.status.validate();
                    this.ap.seqPanel.align.gapCharacter = ".";
                    this.edit.remove(this.gapCharacter);
                    this.gapCharacter = new MenuItem("Set gap character to -");
                    this.edit.add(this.gapCharacter);
                } else if (label.equals("Set gap character to -")) {
                    this.status.setText("Changing gap character...");
                    this.status.validate();
                    this.ap.seqPanel.align.gapCharacter = "-";
                    this.edit.remove(this.gapCharacter);
                    this.gapCharacter = new MenuItem("Set gap character to .");
                    this.edit.add(this.gapCharacter);
                } else if (label.equals("Mail alignment...")) {
                    this.status.setText("Creating mail window...");
                    this.status.validate();
                    new MailTextPopup((Frame)this, "Mail text alignment", this);
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Mail postscript...")) {
                    this.status.setText("Creating mail window...");
                    this.status.validate();
                    new PostscriptPopup((Frame)this, "Mail postscript", this);
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Groups...")) {
                    this.status.setText("Creating group edit window...");
                    this.status.validate();
                    new GroupPopup((Frame)this, "Group properties", this.ap.seqPanel.align);
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Remove gapped columns")) {
                    this.status.setText("Removing gaps...");
                    this.status.validate();
                    this.ap.seqPanel.align.removeGappedColumns();
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Delete selected sequences")) {
                    this.status.setText("Deleting selected sequences...");
                    this.status.validate();
                    int i = 0;
                    while (i < this.ap.sel.size()) {
                        this.ap.seqPanel.align.deleteSequence((DrawableSequence)this.ap.sel.elementAt(i));
                        ++i;
                    }
                    this.ap.sel.removeAllElements();
                    if (this.ap instanceof BigPanel) {
                        BigPanel bp = (BigPanel)this.ap;
                        int i2 = 0;
                        while (i2 < bp.scorePanel.sel.size()) {
                            bp.scorePanel.seqPanel.align.deleteSequence((DrawableSequence)bp.scorePanel.sel.elementAt(i2));
                            ++i2;
                        }
                        bp.scorePanel.sel.removeAllElements();
                    }
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Remote alignment at EBI")) {
                    Thread th;
                    this.status.setText("Aligning sequences remotely...");
                    this.status.validate();
                    Sequence[] newseq = new Sequence[this.ap.seqPanel.align.size()];
                    int i = 0;
                    while (i < newseq.length) {
                        String newstr = AlignSeq.extractGaps(" ", this.ap.seqPanel.align.ds[i].getSequence());
                        newstr = AlignSeq.extractGaps("-", newstr);
                        newstr = AlignSeq.extractGaps(".", newstr);
                        newseq[i] = new Sequence(this.ap.seqPanel.align.ds[i].name, newstr, this.ap.seqPanel.align.ds[i].start, this.ap.seqPanel.align.ds[i].end);
                        ++i;
                    }
                    this.status.setText("Creating progress frame");
                    this.status.validate();
                    ProgressFrame pf = new ProgressFrame("Clustalw progress...", this, null);
                    TextAreaPrintStream taps = new TextAreaPrintStream((OutputStream)System.out, pf.ta);
                    ClustalwCGI cwcgi = new ClustalwCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runclustal", newseq, (PrintStream)taps);
                    pf.pp.ct = th = new Thread(cwcgi);
                    pf.show();
                    Thread t = new Thread(pf.pp);
                    t.start();
                    th.start();
                    this.status.setText("Starting clustalw thread...");
                    this.status.validate();
                } else if (label.equals("Remote postal analysis at EBI")) {
                    Thread th;
                    this.status.setText("Remote postal analysis...");
                    this.status.validate();
                    Sequence[] cfr_ignored_0 = new Sequence[this.ap.seqPanel.align.size()];
                    this.status.setText("Creating progress frame");
                    this.status.validate();
                    ProgressFrame pf = new ProgressFrame("Postal progress...", this, null);
                    TextAreaPrintStream taps = new TextAreaPrintStream((OutputStream)System.out, pf.ta);
                    PostalCGI cwcgi = new PostalCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runpostal", this.ap.seqPanel.align.ds, (PrintStream)taps);
                    pf.pp.ct = th = new Thread(cwcgi);
                    pf.show();
                    Thread t = new Thread(pf.pp);
                    t.start();
                    th.start();
                    this.status.setText("Starting postal thread...");
                    this.status.validate();
                } else if (label.equals("Remote Jnet analysis at EBI")) {
                    JnetCGI cwcgi;
                    this.status.setText("Running Jnet remotely...");
                    this.status.validate();
                    int i = 0;
                    if (this.ap.sel.size() == 0) {
                        while (i < this.ap.seqPanel.align.ds.length && this.ap.seqPanel.align.ds[i] != null) {
                            this.ap.seqPanel.align.ds[i].sequence = this.ap.seqPanel.align.ds[i].sequence.toUpperCase();
                            ++i;
                        }
                        cwcgi = new JnetCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runjnet", this.ap.seqPanel.align.ds, System.out, this);
                    } else {
                        Sequence[] tmp = new DrawableSequence[this.ap.sel.size()];
                        int j = 0;
                        while (j < this.ap.sel.size()) {
                            tmp[j] = (DrawableSequence)this.ap.sel.elementAt(j);
                            ++j;
                        }
                        cwcgi = new JnetCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runjnet", tmp, System.out, this);
                    }
                    Thread th = new Thread(cwcgi);
                    th.start();
                    this.status.setText("Starting jnet thread...");
                    this.status.validate();
                } else if (label.equals("Local alignment")) {
                    if (!(this.parent instanceof Applet)) {
                        this.status.setText("Starting local alignment...");
                        this.status.validate();
                        Sequence[] newseq = new Sequence[this.ap.seqPanel.align.size()];
                        int i = 0;
                        while (i < newseq.length) {
                            String newstr = AlignSeq.extractGaps(" ", this.ap.seqPanel.align.ds[i].getSequence());
                            newstr = AlignSeq.extractGaps("-", newstr);
                            newstr = AlignSeq.extractGaps(".", newstr);
                            System.out.println(newstr);
                            newseq[i] = new Sequence(this.ap.seqPanel.align.ds[i].name, newstr, this.ap.seqPanel.align.ds[i].start, this.ap.seqPanel.align.ds[i].end);
                            ++i;
                        }
                        ClustalwThread ct = new ClustalwThread(newseq);
                        ct.start();
                    } else {
                        this.error("ERROR: Can't run local process from Applet", true);
                    }
                } else if (label.equals("Above PID threshold only...")) {
                    if (this.ap.seqPanel.align.cons != null) {
                        this.status.setText("Creating PID threshold chooser...");
                        this.status.validate();
                        this.PIDthreshold.disable();
                        new PercentIdentityPopup(this, "PID threshold selection", "Percent identity", 0, 100, this.threshold);
                        this.status.setText("Colouring above PID threshold...");
                        this.status.validate();
                        this.updateFont();
                        this.status.setText("done");
                        this.status.validate();
                        this.PIDthreshold.enable();
                    } else {
                        this.error("ERROR: No consensus to compare with", true);
                    }
                } else if (label.equals("Conservation colour increment...")) {
                    this.status.setText("Creating increment chooser...");
                    this.status.validate();
                    new IncrementPopup(this, "Conservation colour increment selection", "Colour increment", 0, 50);
                    this.status.setText("Changing colour increment...");
                    this.status.validate();
                    int j = 0;
                    while (j < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(j);
                        if (sg.colourScheme instanceof ConservationColourScheme) {
                            ((ConservationColourScheme)sg.colourScheme).inc = this.increment;
                            sg.colourScheme.setColours(sg);
                            this.status.setText("Changing group colour increment");
                            this.status.validate();
                        }
                        ++j;
                    }
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Move selected sequences to new alignment")) {
                    if (this.ap.sel.size() > 0) {
                        this.status.setText("Moving selected sequences...");
                        this.status.validate();
                        DrawableSequence[] s = new DrawableSequence[this.ap.sel.size()];
                        int i = 0;
                        while (i < this.ap.sel.size()) {
                            s[i] = new DrawableSequence((Sequence)this.ap.sel.elementAt(i));
                            this.ap.seqPanel.align.deleteSequence((Sequence)this.ap.sel.elementAt(i));
                            ++i;
                        }
                        this.ap.sel = new Vector();
                        this.status.setText("Creating new alignment window...");
                        this.status.validate();
                        AlignFrame af = new AlignFrame((Object)this, s);
                        Font f = this.getFont();
                        af.setAlignFont(f.getName(), f.getStyle(), f.getSize());
                        af.resize(700, 500);
                        af.show();
                        this.status.setText("done");
                        this.status.validate();
                        this.updateFont();
                    } else {
                        this.error("ERROR: No sequences selected...", true);
                    }
                } else if (label.equals("Copy selected sequences to new alignment")) {
                    if (this.ap.sel.size() > 0) {
                        this.status.setText("Copying selected sequences...");
                        this.status.validate();
                        DrawableSequence[] s = new DrawableSequence[this.ap.sel.size()];
                        int i = 0;
                        while (i < this.ap.sel.size()) {
                            s[i] = new DrawableSequence((Sequence)this.ap.sel.elementAt(i));
                            ++i;
                        }
                        this.ap.sel = new Vector();
                        this.status.setText("Creating new alignment window...");
                        this.status.validate();
                        AlignFrame af = new AlignFrame((Object)this, s);
                        Font f = this.getFont();
                        af.setAlignFont(f.getName(), f.getStyle(), f.getSize());
                        af.resize(700, 500);
                        af.show();
                        this.updateFont();
                        this.status.setText("done");
                        this.status.validate();
                    }
                } else if (label.equals("Sort by group")) {
                    this.status.setText("Sorting sequences by group...");
                    this.status.validate();
                    this.ap.seqPanel.align.sortGroups();
                    this.ap.seqPanel.align.sortByGroup();
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Sort by ID")) {
                    this.status.setText("Sorting sequences by ID...");
                    this.status.validate();
                    this.ap.seqPanel.align.sortByID();
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Sort by tree order")) {
                    if (this.tt != null) {
                        this.status.setText("Sorting by tree order...");
                        this.status.validate();
                        this.ap.seqPanel.align.sortByTree(this.tt.tf.p.njt.tf);
                        this.status.setText("Updating display");
                        this.status.validate();
                        this.updateFont();
                        this.status.setText("done");
                        this.status.validate();
                    } else {
                        this.error("ERROR: No tree defined", true);
                    }
                } else if (label.equals("Sort by pairwise identity")) {
                    if (this.ap.seqPanel.align.cons == null) {
                        this.status.setText("Calculating consensus...");
                        this.status.validate();
                        this.ap.seqPanel.align.percentIdentity();
                        this.status.setText("done");
                        this.status.validate();
                    }
                    String s = "";
                    int i = 0;
                    while (i < this.ap.seqPanel.align.maxLength()) {
                        s = String.valueOf(s) + this.ap.seqPanel.align.cons[i].get("max");
                        ++i;
                    }
                    this.status.setText("Sorting by pairwise identity...");
                    this.status.validate();
                    this.ap.seqPanel.align.sortByPID(new DrawableSequence("Consensus", s, 1, s.length()));
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Remove redundancy")) {
                    this.status.setText("Creating redundancy chooser...");
                    this.status.validate();
                    new RedundancyPopup(this, "Redundancy threshold selection", "Percent identity", 0, 100, 100);
                    this.updateFont();
                    this.status.setText("Redundant sequences removed");
                    this.status.validate();
                } else if (label.equals("Remove sequence <- left of selected columns")) {
                    if (this.ap.selectedColumns.size() > 0) {
                        this.status.setText("Trimming sequences left...");
                        this.status.validate();
                        Enumeration en = this.ap.selectedColumns.elements();
                        int min = this.ap.seqPanel.align.maxLength;
                        while (en.hasMoreElements()) {
                            Integer i = (Integer)en.nextElement();
                            if (i >= min) continue;
                            min = i;
                        }
                        if (min < this.ap.seqPanel.align.maxLength) {
                            this.ap.seqPanel.align.trimLeft(min);
                            if (this.bp.scorePanel != null) {
                                this.bp.scorePanel.seqPanel.align.trimLeft(min);
                            }
                            int i = 0;
                            while (i < this.ap.selectedColumns.size()) {
                                int temp = (Integer)this.ap.selectedColumns.elementAt(i);
                                this.ap.selectedColumns.setElementAt(new Integer(temp - min), i);
                                ++i;
                            }
                            this.status.setText("Trimmed left of " + min);
                            this.status.validate();
                        } else {
                            this.error("ERROR: No columns selected", true);
                        }
                    }
                    this.updateFont();
                } else if (label.equals("Remove sequence -> right of selected columns")) {
                    if (this.ap.selectedColumns.size() > 0) {
                        this.status.setText("Trimming sequences right...");
                        this.status.validate();
                        Enumeration en = this.ap.selectedColumns.elements();
                        int max = 0;
                        while (en.hasMoreElements()) {
                            Integer i = (Integer)en.nextElement();
                            if (i <= max) continue;
                            max = i;
                        }
                        if (max > 0) {
                            this.ap.seqPanel.align.trimRight(max);
                            if (this.bp.scorePanel != null) {
                                this.bp.scorePanel.seqPanel.align.trimRight(max);
                            }
                            int i = 0;
                            while (i < this.ap.selectedColumns.size()) {
                                int temp = (Integer)this.ap.selectedColumns.elementAt(i);
                                if (temp > max) {
                                    this.ap.selectedColumns.removeElementAt(i);
                                }
                                ++i;
                            }
                            this.status.setText("Trimmed right of " + max);
                            this.status.validate();
                        }
                        this.updateFont();
                    } else {
                        this.error("ERROR: No columns selected", true);
                    }
                } else if (label.equals("Fetch sequence features")) {
                    this.status.setText("Fetching sequence features...");
                    this.status.validate();
                    this.sft = new SequenceFeatureThread(this);
                    this.sft.start();
                } else if (label.equals("Fetch PDB structure")) {
                    this.status.setText("Creating PDB popup...");
                    this.status.validate();
                    new PDBPopup((Frame)this, "PDB selector", this.ap.seqPanel.align);
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Select all sequences")) {
                    this.status.setText("Selecting all sequences");
                    this.status.validate();
                    int i = 0;
                    while (i < this.ap.seqPanel.align.sequences.length && this.ap.seqPanel.align.sequences[i] != null) {
                        this.ap.sel.addElement(this.ap.seqPanel.align.sequences[i]);
                        ++i;
                    }
                    this.updateFont();
                    this.status.setText("Selected all sequences");
                    this.status.validate();
                } else if (label.equals("Deselect all sequences")) {
                    this.status.setText("Deselecting all sequences...");
                    this.status.validate();
                    this.ap.sel.removeAllElements();
                    this.updateFont();
                    this.status.setText("Deselected all sequences");
                    this.status.validate();
                } else if (label.equals("Invert sequence selection")) {
                    this.status.setText("Inverting sequence selection");
                    this.status.validate();
                    int i = 0;
                    while (i < this.ap.seqPanel.align.sequences.length && this.ap.seqPanel.align.sequences[i] != null) {
                        if (this.ap.sel.contains(this.ap.seqPanel.align.sequences[i])) {
                            this.ap.sel.removeElement(this.ap.seqPanel.align.sequences[i]);
                        } else {
                            this.ap.sel.addElement(this.ap.seqPanel.align.sequences[i]);
                        }
                        ++i;
                    }
                    this.updateFont();
                    this.status.setText("Inverted sequence selection");
                    this.status.validate();
                } else if (label.equals("Deselect all columns")) {
                    this.status.setText("Deselecting all columns...");
                    this.status.validate();
                    this.ap.selectedColumns.removeAllElements();
                    this.ap.scalePanel.scaleCanvas.paintFlag = true;
                    this.ap.scalePanel.scaleCanvas.repaint();
                    this.status.setText("Deselected all columns");
                    this.status.validate();
                } else if (label.equals("Bold")) {
                    this.status.setText("Setting bold font");
                    this.status.validate();
                    if (this.ap.seqPanel.seqCanvas.fontStyle != 1) {
                        this.setFont(1, this.ap.seqPanel.seqCanvas.fontSize);
                    }
                    this.status.setText("Changed to bold font");
                    this.status.validate();
                } else if (label.equals("Plain")) {
                    this.status.setText("Setting plain font");
                    this.status.validate();
                    if (this.ap.seqPanel.seqCanvas.fontStyle != 0) {
                        this.setFont(0, this.ap.seqPanel.seqCanvas.fontSize);
                    }
                    this.status.setText("Changed to plain font");
                    this.status.validate();
                } else if (label.indexOf("Size =") == 0) {
                    this.status.setText("Setting font size");
                    this.status.validate();
                    StringTokenizer str = new StringTokenizer(label);
                    String tmp = str.nextToken();
                    tmp = str.nextToken();
                    tmp = str.nextToken();
                    int size = Integer.valueOf(tmp);
                    this.setFont(this.ap.seqPanel.seqCanvas.fontStyle, size);
                } else if (label.equals("Average distance tree using PID")) {
                    if (this.ap.sel != null && this.ap.sel.size() > 3) {
                        this.status.setText("Calculating average distance tree...");
                        this.status.validate();
                        this.tt = new TreeThread("Average distance tree using PID", (Object)this, this.ap.sel, "AV", "PID");
                    } else {
                        this.status.setText("Calculating average distance tree...");
                        this.status.validate();
                        this.tt = new TreeThread("Average distance tree using PID", (Object)this, this.ap.seqPanel.align.ds, "AV", "PID");
                    }
                    this.tt.start();
                } else if (label.equals("Neighbour joining tree using PID")) {
                    if (this.ap.sel != null && this.ap.sel.size() > 3) {
                        this.tt = new TreeThread("Neighbour joining tree using PID", (Object)this, this.ap.sel, "NJ", "PID");
                        this.status.setText("Calculating NJ tree");
                        this.status.validate();
                    } else {
                        this.tt = new TreeThread("Neighbour joining tree using PID", (Object)this, this.ap.seqPanel.align.ds, "NJ", "PID");
                        this.status.setText("Calculating NJ tree");
                        this.status.validate();
                    }
                    this.tt.start();
                } else if (label.equals("Principal component analysis")) {
                    this.status.setText("Starting PCA calculation...");
                    this.status.validate();
                    this.pca = new PCAThread(this, this.ap.seqPanel.align.ds);
                    this.pca.start();
                } else if (label.equals("Consensus")) {
                    this.status.setText("Calculating consensus");
                    this.status.validate();
                    int count = this.ap.countSelected();
                    if (count == 0) {
                        this.ap.seqPanel.align.percentIdentity();
                        if (this.bp.scorePanel != null) {
                            this.bp.scorePanel.seqPanel.align.ds[0] = this.ap.seqPanel.align.qualityScore;
                            this.updateFont();
                        }
                        this.ap.seqPanel.align.percentIdentity();
                        this.status.setText("Using all sequences for consensus");
                        this.status.validate();
                    } else {
                        this.ap.seqPanel.align.percentIdentity(this.ap.sel);
                    }
                    this.cons = this.ap.seqPanel.align.cons;
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.indexOf("User") == 0) {
                    this.status.setText("Creating user colour chooser...");
                    this.status.validate();
                    ColourChooserFrame ccf = new ColourChooserFrame(this, this.ap.color);
                    ccf.show();
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Information")) {
                    if (this.parent != null) {
                        if (this.parent instanceof Applet) {
                            this.status.setText("Fetching URL help file");
                            this.status.validate();
                            try {
                                String urlStr = "http://circinus.ebi.ac.uk:6543/~michele/jalview/help.html";
                                URL u = new URL(urlStr);
                                ((Applet)this.parent).getAppletContext().showDocument(u, "right");
                            }
                            catch (MalformedURLException malformedURLException) {
                                this.status.setText("Couldn't fetch help URL");
                                this.status.validate();
                            }
                            this.status.setText("Help file displayed in browser");
                            this.status.validate();
                        }
                    } else {
                        this.status.setText("Fetching URL information file");
                        this.status.validate();
                    }
                } else if (label.equals("Conservation")) {
                    this.conservation.enable();
                    this.incitem.enable();
                    this.status.setText("Calculating conservation...");
                    this.status.validate();
                    int j = 0;
                    while (j < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(j);
                        Vector tmp = sg.sequences;
                        sg.conserve = new Conservation("All", this.ap.seqPanel.align.cons, ResidueProperties.propHash, 3, tmp, 0, this.ap.seqPanel.align.sequences[0].getSequence().length() - 1);
                        sg.conserve.calculate();
                        sg.conserve.verdict(false, 20.0f);
                        System.out.println("Conservation = " + sg.conserve.consSequence.sequence);
                        sg.colourScheme = new ConservationColourScheme(sg);
                        sg.colourScheme.setColours(sg);
                        this.updateFont();
                        ++j;
                    }
                    this.status.setText("Calculated conservation");
                    this.status.validate();
                    this.conservation.setState(true);
                    this.ap.conservation = true;
                    this.PIDthreshold.disable();
                } else if (label.equals("Contents")) {
                    if (this.parent != null) {
                        if (this.parent instanceof Applet) {
                            this.status.setText("Fetching URL help file");
                            this.status.validate();
                            try {
                                String urlStr = "http://circinus.ebi.ac.uk:6543/~michele/jalview/contents.html";
                                URL u = new URL(urlStr);
                                ((Applet)this.parent).getAppletContext().showDocument(u, "right");
                            }
                            catch (MalformedURLException malformedURLException) {
                                this.status.setText("Couldn't fetch help URL");
                                this.status.validate();
                            }
                            this.status.setText("Help file displayed in browser");
                            this.status.validate();
                        }
                    } else {
                        this.status.setText("Fetching URL help file");
                        this.status.validate();
                    }
                } else if (label.equals("Input alignment as URL")) {
                    this.status.setText("Creating URL chooser...");
                    this.status.validate();
                    new URLPopup((Frame)this, "Input alignment as URL");
                } else if (label.equals("Input alignment from local file")) {
                    this.status.setText("Creating file chooser...");
                    this.status.validate();
                    new FilePopup((Frame)this, "Input alignment from local file");
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Save alignment to local file")) {
                    this.status.setText("Creating file chooser...");
                    this.status.validate();
                    if (this.parent instanceof Applet) {
                        new AppletFilePopup((Frame)this, "Save alignment to local file");
                    } else {
                        new OutputFilePopup((Frame)this, "Save alignment to local file");
                    }
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Save postscript to local file")) {
                    this.status.setText("Creating file chooser...");
                    this.status.validate();
                    if (this.parent instanceof Applet) {
                        new AppletPostscriptPopup((Frame)this, "Save postscript to local file", this);
                    } else {
                        new PostscriptFilePopup((Frame)this, "Save postscript to local file", this);
                    }
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Input alignment via text box")) {
                    this.status.setText("Creating input textbox...");
                    this.status.validate();
                    new InputPopup((Frame)this, "Input alignment via text box");
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Output alignment via text box")) {
                    this.status.setText("Creating output textbox...");
                    this.status.validate();
                    new OutputPopup((Frame)this, "Alignment " + this.getTitle());
                    this.status.setText("done");
                    this.status.validate();
                } else if (label.equals("Pairwise alignments")) {
                    this.status.setText("Aligning selected sequences...");
                    this.status.validate();
                    PairAlignThread pat = new PairAlignThread(this);
                    pat.start();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 201) {
            if (this.parent instanceof Applet) {
                this.status.setText("Closing window...");
                this.status.validate();
                this.hide();
                this.dispose();
            } else if (this.parent == null) {
                this.status.setText("Quitting application");
                this.status.validate();
                System.exit(0);
            } else {
                this.status.setText("Closing window...");
                this.status.validate();
                this.hide();
                this.dispose();
            }
        } else {
            super.handleEvent(evt);
        }
        return false;
    }

    public int getScheme() {
        if (this.zappo.getState()) {
            return 0;
        }
        if (this.taylor.getState()) {
            return 1;
        }
        if (this.PID.getState()) {
            return 2;
        }
        if (this.BLOSUM62.getState()) {
            return 3;
        }
        if (this.Hydrophobicity.getState()) {
            return 4;
        }
        if (this.helix.getState()) {
            return 8;
        }
        if (this.strand.getState()) {
            return 9;
        }
        if (this.turn.getState()) {
            return 10;
        }
        if (this.buried.getState()) {
            return 11;
        }
        return -1;
    }

    public void setBoxes(boolean state) {
        int i = 0;
        while (i < this.ap.seqPanel.align.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(i);
            sg.displayBoxes = state;
            this.ap.seqPanel.align.displayBoxes(sg);
            ++i;
        }
    }

    public void setText(boolean state) {
        int i = 0;
        while (i < this.ap.seqPanel.align.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(i);
            sg.displayText = state;
            this.ap.seqPanel.align.displayText(sg);
            ++i;
        }
    }

    public void setColourText(boolean state) {
        int i = 0;
        while (i < this.ap.seqPanel.align.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(i);
            sg.colourText = state;
            this.ap.seqPanel.align.colourText(sg);
            ++i;
        }
    }

    public void fileMenu() {
        this.file = new Menu("File", true);
        if (!(this.parent instanceof Applet)) {
            this.file.add("Input alignment from local file");
            this.file.add("Input alignment as URL");
            this.file.addSeparator();
        }
        this.file.add("Save alignment to local file");
        this.file.add("Save postscript to local file");
        this.file.addSeparator();
        this.file.add("Input alignment via text box");
        this.file.add("Output alignment via text box");
        this.file.addSeparator();
        this.file.add("Mail alignment...");
        this.file.add("Mail postscript...");
        this.file.addSeparator();
        this.file.add("Close");
        this.file.add("Quit");
    }

    public void editMenu() {
        this.edit = new Menu("Edit", true);
        this.edit.add("Groups...");
        this.groupEdit = new CheckboxMenuItem("Group editing mode");
        this.edit.add(this.groupEdit);
        this.groupEdit.setState(false);
        this.edit.addSeparator();
        this.edit.add("Select all sequences");
        this.edit.add("Deselect all sequences");
        this.edit.add("Invert sequence selection");
        this.edit.addSeparator();
        this.edit.add("Delete selected sequences");
        this.edit.add("Move selected sequences to new alignment");
        this.edit.add("Copy selected sequences to new alignment");
        this.edit.addSeparator();
        this.edit.add("Deselect all columns");
        this.edit.add("Remove sequence <- left of selected columns");
        this.edit.add("Remove sequence -> right of selected columns");
        this.edit.addSeparator();
        this.edit.add("Remove gapped columns");
        if (this.ap.seqPanel.align.gapCharacter.equals("-")) {
            this.gapCharacter = new MenuItem("Set gap character to .");
            this.edit.add(this.gapCharacter);
        } else if (this.ap.seqPanel.align.gapCharacter.equals(".")) {
            this.gapCharacter = new MenuItem("Set gap character to -");
            this.edit.add(this.gapCharacter);
        }
    }

    public void fontMenu() {
        this.font = new Menu("Font", true);
        this.fastDraw = new CheckboxMenuItem("Fast Draw");
        this.helvetica = new CheckboxMenuItem("Helvetica");
        this.courier = new CheckboxMenuItem("Courier");
        this.times = new CheckboxMenuItem("Times-Roman");
        this.fastDraw.setState(true);
        this.helvetica.setState(false);
        this.times.setState(false);
        this.courier.setState(false);
        this.helvetica.disable();
        this.times.disable();
        this.courier.disable();
        this.font.add(this.fastDraw);
        this.font.addSeparator();
        this.font.add(this.helvetica);
        this.font.add(this.courier);
        this.font.add(this.times);
        this.font.addSeparator();
        this.font.add("Size = 1");
        this.font.add("Size = 2");
        this.font.add("Size = 4");
        this.font.add("Size = 6");
        this.font.add("Size = 8");
        this.font.add("Size = 10");
        this.font.add("Size = 12");
        this.font.add("Size = 14");
        this.font.add("Size = 16");
        this.font.add("Size = 20");
        this.font.add("Size = 24");
        this.font.addSeparator();
        this.font.add("Plain");
        this.font.add("Bold");
    }

    public void viewMenu() {
        this.view = new Menu("View", true);
        this.boxes = new CheckboxMenuItem("Boxes");
        this.boxes.setState(true);
        this.text = new CheckboxMenuItem("Text");
        this.text.setState(true);
        this.scores = new CheckboxMenuItem("Scores");
        this.scores.setState(false);
        this.ap.seqPanel.seqCanvas.showScores = false;
        this.ap.idPanel.idCanvas.showScores = false;
        this.view.add(this.boxes);
        this.view.add(this.text);
        this.view.add(this.scores);
        this.view.addSeparator();
        this.colourText = new CheckboxMenuItem("Colour text");
        this.colourText.setState(false);
        this.view.add(this.colourText);
        this.blackText = new CheckboxMenuItem("Black text");
        this.blackText.setState(true);
        this.view.add(this.blackText);
    }

    public void colourMenu() {
        this.colour = new Menu("Colour", true);
        this.clustalx = new CheckboxMenuItem("Clustalx colours");
        this.clustalx.setState(true);
        this.colour.add(this.clustalx);
        this.zappo = new CheckboxMenuItem("Zappo Colourscheme");
        this.zappo.setState(false);
        this.colour.add(this.zappo);
        this.taylor = new CheckboxMenuItem("Taylor Colourscheme");
        this.taylor.setState(false);
        this.colour.add(this.taylor);
        this.Hydrophobicity = new CheckboxMenuItem("By Hydrophobicity");
        this.Hydrophobicity.setState(false);
        this.colour.add(this.Hydrophobicity);
        this.helix = new CheckboxMenuItem("Helix propensity");
        this.helix.setState(false);
        this.colour.add(this.helix);
        this.strand = new CheckboxMenuItem("Strand propensity");
        this.strand.setState(false);
        this.colour.add(this.strand);
        this.turn = new CheckboxMenuItem("Turn propensity");
        this.turn.setState(false);
        this.colour.add(this.turn);
        this.buried = new CheckboxMenuItem("Buried index");
        this.buried.setState(false);
        this.colour.add(this.buried);
        this.colour.addSeparator();
        this.conservation = new CheckboxMenuItem("By conservation");
        this.conservation.disable();
        this.conservation.setState(false);
        this.ap.conservation = false;
        this.conservation.disable();
        this.colour.add(this.conservation);
        this.colour.addSeparator();
        this.PIDthreshold = new MenuItem("Above PID threshold only...");
        this.PIDthreshold.disable();
        this.incitem = new MenuItem("Conservation colour increment...");
        this.incitem.disable();
        this.colour.add(this.PIDthreshold);
        this.colour.add(this.incitem);
        this.userColours = new MenuItem("User defined colours...");
        this.userColours.disable();
        this.colour.add(this.userColours);
        this.colour.addSeparator();
        this.PID = new CheckboxMenuItem("By PID");
        this.PID.setState(false);
        SequenceGroup sg = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(0);
        sg.colourScheme = new PIDColourScheme();
        this.colour.add(this.PID);
        this.BLOSUM62 = new CheckboxMenuItem("By BLOSUM62 score");
        this.BLOSUM62.setState(false);
        this.colour.add(this.BLOSUM62);
        this.colour.addSeparator();
        this.features = new MenuItem("Fetch sequence features");
        this.colour.add(this.features);
        this.structures = new MenuItem("Fetch PDB structure");
        this.colour.add(this.structures);
    }

    public void calcMenu() {
        this.calc = new Menu("Calculate", true);
        this.calc.add("Consensus");
        this.autoconsensus = new CheckboxMenuItem("Autocalculate consensus");
        this.autoconsensus.setState(false);
        this.ap.seqPanel.align.autoConsensus = false;
        this.calc.add(this.autoconsensus);
        this.calc.addSeparator();
        this.calc.add("Sort by pairwise identity");
        this.calc.add("Sort by ID");
        this.calc.add("Sort by group");
        this.calc.add("Sort by tree order");
        this.calc.add("Remove redundancy");
        this.calc.addSeparator();
        this.calc.add("Pairwise alignments");
        this.calc.add("Principal component analysis");
        this.calc.addSeparator();
        this.calc.add("Average distance tree using PID");
        this.calc.add("Neighbour joining tree using PID");
        this.calc.addSeparator();
        this.calc.add("Conservation");
    }

    public void helpMenu() {
        this.help = new Menu("Help", true);
        this.help.add("Information");
        this.help.add("Contents");
    }

    public void alignMenu() {
        this.align = new Menu("Align", true);
        if (this.parent instanceof Applet) {
            Applet app = (Applet)this.parent;
            if (app.getCodeBase().getHost().equals("circinus.ebi.ac.uk")) {
                this.align.add("Remote alignment at EBI");
                this.align.add("Remote postal analysis at EBI");
                this.align.add("Remote Jnet analysis at EBI");
            } else {
                this.align.disable();
            }
        } else {
            this.align.add("Local alignment");
            this.align.add("Remote alignment at EBI");
            this.align.add("Remote postal analysis at EBI");
            this.align.add("Remote Jnet analysis at EBI");
        }
    }

    public void setAlignFont(String name, int style, int size) {
        this.ap.seqPanel.seqCanvas.fontName = name;
        this.ap.seqPanel.seqCanvas.fontStyle = style;
        this.ap.seqPanel.seqCanvas.fontSize = size;
        this.ap.seqPanel.seqCanvas.setFont(new Font(name, style, size));
        if (this.bp.scorePanel != null) {
            this.bp.scorePanel.seqPanel.seqCanvas.fontName = name;
            this.bp.scorePanel.seqPanel.seqCanvas.fontStyle = style;
            this.bp.scorePanel.seqPanel.seqCanvas.fontSize = size;
            this.bp.scorePanel.seqPanel.seqCanvas.setFont(new Font(name, style, size));
        }
    }

    public Font getAlignFont() {
        return this.ap.seqPanel.seqCanvas.f;
    }

    public void setFont(String fontName) {
        this.ap.seqPanel.seqCanvas.fontName = fontName;
        this.ap.seqPanel.seqCanvas.setFont(new Font(fontName, this.ap.seqPanel.seqCanvas.fontStyle, this.ap.seqPanel.seqCanvas.fontSize));
        if (this.bp.scorePanel != null) {
            this.bp.scorePanel.seqPanel.seqCanvas.fontName = fontName;
            this.bp.scorePanel.seqPanel.seqCanvas.setFont(new Font(fontName, this.ap.seqPanel.seqCanvas.fontStyle, this.ap.seqPanel.seqCanvas.fontSize));
        }
        this.updateFont();
        this.status.setText("Font changed to " + fontName);
    }

    public void setFont(int style, int size) {
        this.ap.seqPanel.seqCanvas.setFont(style, size);
        if (this.bp.scorePanel != null) {
            this.bp.scorePanel.seqPanel.seqCanvas.setFont(style, size);
        }
        this.updateFont();
        this.status.setText("Font changed to " + style + " " + size);
    }

    public void updateFont() {
        super.repaint();
        if (this.ap instanceof BigPanel) {
            BigPanel bp = (BigPanel)this.ap;
            bp.setScrollValues(this.ap.seqPanel.offx, 0);
            if (bp.scorePanel != null) {
                bp.scorePanel.seqPanel.invalidate();
                bp.scorePanel.idPanel.idCanvas.invalidate();
                bp.scorePanel.idPanel.invalidate();
                bp.scorePanel.scalePanel.invalidate();
                bp.scorePanel.invalidate();
                bp.scorePanel.validate();
                bp.invalidate();
                bp.validate();
                bp.scorePanel.idPanel.idCanvas.paintFlag = true;
                bp.scorePanel.seqPanel.seqCanvas.paintFlag = true;
                bp.scorePanel.scalePanel.scaleCanvas.paintFlag = true;
                bp.scorePanel.scalePanel.scaleCanvas.repaint();
                bp.scorePanel.idPanel.idCanvas.paint(bp.scorePanel.idPanel.idCanvas.getGraphics());
                bp.scorePanel.seqPanel.seqCanvas.paint(bp.scorePanel.seqPanel.seqCanvas.getGraphics());
                bp.scorePanel.invalidate();
                bp.scorePanel.validate();
            }
        }
        this.ap.seqPanel.setScrollValues(this.ap.seqPanel.offx, this.ap.seqPanel.offy);
        this.ap.idPanel.idCanvas.paintFlag = true;
        this.ap.seqPanel.seqCanvas.paintFlag = true;
        this.ap.scalePanel.scaleCanvas.paintFlag = true;
        this.ap.scalePanel.scaleCanvas.repaint();
        this.ap.idPanel.idCanvas.paint(this.ap.idPanel.idCanvas.getGraphics());
        this.ap.seqPanel.seqCanvas.paint(this.ap.seqPanel.seqCanvas.getGraphics());
        this.ap.invalidate();
        this.ap.validate();
        this.validate();
        if (this.tt != null) {
            this.tt.tf.p.mc.repaint();
        }
        if (this.pca != null) {
            this.pca.p.rc.redrawneeded = true;
            this.pca.p.rc.repaint();
        }
    }

    public MailProperties getMailProperties() {
        return this.mp;
    }

    public PostscriptProperties getPostscriptProperties() {
        return this.pp;
    }

    public FileProperties getFileProperties() {
        return this.fp;
    }

    public void setMailProperties(MailProperties mp) {
        this.mp = mp;
    }

    public void setPostscriptProperties(PostscriptProperties pp) {
        this.pp = pp;
    }

    public void setFileProperties(FileProperties fp) {
        this.fp = fp;
    }

    public String getText(String format) {
        if (FormatProperties.contains(format)) {
            return FormatAdapter.get(format, this.ap.seqPanel.align.sequences);
        }
        return null;
    }

    public void getPostscript(BufferedWriter bw) {
        Postscript p = new Postscript(this, bw);
        p.generate();
    }

    public StringBuffer getPostscript() {
        Postscript p = new Postscript(this, true);
        p.generate();
        return p.out;
    }

    public void getPostscript(PrintStream ps) {
        Postscript p = new Postscript(this, ps);
        p.generate();
        ps.flush();
        ps.close();
    }

    public static void fetchPDBStructure(DrawableSequence seq2, String srsServer) throws UnknownHostException, IOException {
        if (seq2.pdbcode.size() > 0) {
            System.out.println("code = " + seq2.pdbcode.elementAt(0));
            PDBfile pdb = new PDBfile("http://" + srsServer + "wgetz?-e+[pdb-id:" + seq2.pdbcode.elementAt(0) + "]", "URL");
            seq2.setPDBfile(pdb);
            ((PDBChain)pdb.chains.elementAt((int)seq2.maxchain)).isVisible = true;
            ((PDBChain)pdb.chains.elementAt((int)seq2.maxchain)).ds = seq2;
            ((PDBChain)pdb.chains.elementAt(seq2.maxchain)).colourBySequence();
            rotFrame f = new rotFrame(pdb);
            f.resize(500, 500);
            f.show();
        } else {
            System.out.println("No pdb code found");
        }
    }

    public static AlignFrame parseArgs(String[] args) {
        AlignFrame af = null;
        int[] done = new int[args.length];
        int i = 0;
        while (i < done.length) {
            done[i] = 0;
            ++i;
        }
        try {
            if (args.length == 2) {
                af = new AlignFrame(null, args[0], args[1], "MSF");
                af.setTitle(args[0]);
            } else if (args.length >= 3) {
                af = new AlignFrame(null, args[0], args[1], args[2]);
                af.setTitle(args[0]);
                i = 0;
                while (i < args.length) {
                    if (args[i].equals("-mail")) {
                        af.mp.server = args[i + 1];
                        System.out.println("Mail server = " + af.mp.server);
                    }
                    if (args[i].equals("-srsserver")) {
                        af.srsServer = args[i + 1];
                        if (!af.srsServer.substring(af.srsServer.length() - 1).equals("/")) {
                            af.srsServer = String.valueOf(af.srsServer) + "/";
                        }
                        System.out.println("Srs server = " + af.srsServer);
                    }
                    if (args[i].equals("-database")) {
                        af.database = args[i + 1];
                        System.out.println("SRS database = " + af.database);
                    }
                    ++i;
                }
            } else {
                System.out.println("\nUsage: java jalview.AlignFrame <alignmentfile> <type> <format> [-mail <mailServer>]\n");
                System.out.println("              [-srsserver <srsServer>] [-database <srs database>]\n");
                System.out.println("  type  = File or URL  (case is important I'm afraid)");
                System.out.println("format  = MSF, CLUSTAL, FASTA, BLC, MSP  or PIR\n");
                System.out.println("srsServer is the cgi-bin directory containing wgetz on your srs server.");
                System.out.println("For example: srs.ebi.ac.uk:5000/srs5bin/cgi-bin");
                System.out.println("database is the srs database to be queried");
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return af;
    }

    public void regroup(float threshold) {
        if (this.tt != null) {
            this.status.setText("Regrouping sequences by tree...");
            this.status.validate();
            TreeFile tree2 = this.tt.tf.p.njt.tf;
            tree2.groups.removeAllElements();
            tree2.groupNodes(tree2.top, threshold);
            tree2.setColor(tree2.top, Color.black);
            int i = 0;
            while (i < tree2.groups.size()) {
                this.ap.sel.removeAllElements();
                int tmp = i % 7;
                Color[] col = ResidueProperties.groupColors[tmp];
                tree2.setColor((SequenceNode)tree2.groups.elementAt(i), col[0].darker());
                Vector l = tree2.findLeaves((SequenceNode)tree2.groups.elementAt(i), new Vector());
                int j = 0;
                while (j < l.size()) {
                    SequenceNode sn = (SequenceNode)l.elementAt(j);
                    this.ap.sel.addElement((Sequence)sn.element);
                    ++j;
                }
                SequenceGroup sg = this.ap.seqPanel.align.addGroup();
                SequenceGroup sg2 = this.ap.seqPanel.align.findGroup((Sequence)this.ap.sel.elementAt(0));
                sg.colourScheme = sg2.colourScheme;
                sg.conserve = null;
                sg.color = this.ap.color;
                int ii = 0;
                while (ii < this.ap.sel.size()) {
                    this.ap.seqPanel.align.removeFromGroup(this.ap.seqPanel.align.findGroup((Sequence)this.ap.sel.elementAt(ii)), (Sequence)this.ap.sel.elementAt(ii));
                    this.ap.seqPanel.align.addToGroup(sg, (Sequence)this.ap.sel.elementAt(ii));
                    ++ii;
                }
                if (this.conservation.getState() && sg.conserve != null) {
                    this.status.setText("Setting conservation colour scheme...");
                    this.status.validate();
                    sg.colourScheme = new ConservationColourScheme(sg);
                }
                this.status.setText("Setting residue colours...");
                this.status.validate();
                sg.colourScheme.setColours(sg);
                this.ap.seqPanel.align.setColourScheme(sg);
                this.status.setText("Finished group");
                this.status.validate();
                ++i;
            }
            this.ap.sel.removeAllElements();
            this.updateFont();
            this.status.setText("Finished grouping nodes");
            this.status.validate();
        } else {
            this.error("ERROR: No tree defined yet", true);
        }
    }

    public static void showConsole() {
        Frame console = new Frame("Jalview console");
        console.setLayout(new BorderLayout());
        TextArea ta = new TextArea(20, 80);
        console.add("Center", ta);
        console.resize(700, 200);
        console.show();
        TextAreaPrintStream taps = new TextAreaPrintStream((OutputStream)System.out, ta);
        System.setOut(taps);
    }

    public void wait(int s) {
        try {
            Thread.sleep(s);
        }
        catch (Exception exception) {}
    }

    public static void main(String[] args) {
        AlignFrame af = AlignFrame.parseArgs(args);
        af.printVersion();
        if (af != null) {
            af.ap.seqPanel.align.percentIdentity();
            ClustalxColourScheme cxcs = new ClustalxColourScheme(af.ap.seqPanel.align.cons2, af.ap.seqPanel.align.size());
            af.ap.seqPanel.align.setColourScheme(cxcs);
            af.resize(700, 500);
            af.show();
            af.status.setText("Updating font and colours");
            af.status.validate();
            af.wait(500);
            af.updateFont();
            af.status.setText("done");
            af.status.validate();
        } else {
            System.out.println("ERROR in argument list");
            System.exit(0);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void printVersion() {
        System.out.println("Jalview version : 1.6.4jnet2");
        System.out.println("Author: Michele Clamp (c) 1998");
        System.out.println("$Header: /homes/michele/cvs/java/jalview/AlignFrame.java,v 1.9.4.4 1999/01/06 11:57:51 michele Exp $");
    }

    public void error(String text, boolean beep) {
        this.status.setText(text);
        this.status.validate();
        if (beep) {
            System.out.print("\u0007");
            System.out.flush();
        }
    }
}

