/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Alignment;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Conservation {
    Vector sequences;
    int start;
    int end;
    Vector total = new Vector();
    String consString = "";
    DrawableSequence consSequence;
    Hashtable propHash;
    int threshold;
    Hashtable[] freqs;
    String name = "";

    public Conservation(String name, Hashtable[] freqs, Hashtable propHash, int threshold, Vector sequences, int start, int end) {
        this.name = name;
        this.freqs = freqs;
        this.propHash = propHash;
        this.threshold = threshold;
        this.sequences = sequences;
        this.start = start;
        this.end = end;
    }

    public void calculate() {
        int i = this.start;
        while (i <= this.end) {
            String res;
            Hashtable resultHash = null;
            resultHash = new Hashtable();
            Hashtable<String, Integer> residueHash = null;
            residueHash = new Hashtable<String, Integer>();
            int j = 0;
            while (j < this.sequences.size()) {
                if (this.sequences.elementAt(j) instanceof Sequence) {
                    Sequence s = (Sequence)this.sequences.elementAt(j);
                    if (s.getSequence().length() > i) {
                        res = s.getSequence().substring(i, i + 1);
                        if (residueHash.containsKey(res)) {
                            int count = (Integer)residueHash.get(res);
                            residueHash.put(res, new Integer(++count));
                        } else {
                            residueHash.put(res, new Integer(1));
                        }
                    } else if (residueHash.containsKey("-")) {
                        int count = (Integer)residueHash.get("-");
                        residueHash.put("-", new Integer(++count));
                    } else {
                        residueHash.put("-", new Integer(1));
                    }
                }
                ++j;
            }
            int thresh = this.threshold * this.sequences.size() / 100;
            Enumeration e = residueHash.keys();
            while (e.hasMoreElements()) {
                res = (String)e.nextElement();
                if ((Integer)residueHash.get(res) <= thresh) continue;
                Enumeration e2 = this.propHash.keys();
                while (e2.hasMoreElements()) {
                    String type = (String)e2.nextElement();
                    Hashtable ht = (Hashtable)this.propHash.get(type);
                    if (!resultHash.containsKey(type)) {
                        if (ht.containsKey(res)) {
                            resultHash.put(type, ht.get(res));
                            continue;
                        }
                        resultHash.put(type, ht.get("-"));
                        continue;
                    }
                    if (((Integer)resultHash.get(type)).equals((Integer)ht.get(res))) continue;
                    resultHash.put(type, new Integer(-1));
                }
            }
            this.total.addElement(resultHash);
            ++i;
        }
    }

    public int countGaps(int j) {
        int count = 0;
        int i = 0;
        while (i < this.sequences.size()) {
            String tmp = ((Sequence)this.sequences.elementAt((int)i)).sequence.substring(j, j + 1);
            if (tmp.equals(" ") || tmp.equals(".") || tmp.equals("-")) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void verdict(boolean consflag, float percentageGaps) {
        String consString = "";
        int i = this.start;
        while (i <= this.end) {
            int totGaps = this.countGaps(i);
            float pgaps = (float)totGaps * 100.0f / (float)this.sequences.size();
            if (percentageGaps > pgaps) {
                Hashtable resultHash = (Hashtable)this.total.elementAt(i);
                int count = 0;
                Enumeration e3 = resultHash.keys();
                while (e3.hasMoreElements()) {
                    String type = (String)e3.nextElement();
                    Integer result = (Integer)resultHash.get(type);
                    if (consflag) {
                        if (result != 1) continue;
                        ++count;
                        continue;
                    }
                    if (result == -1) continue;
                    ++count;
                }
                consString = count < 10 ? String.valueOf(consString) + String.valueOf(count) : String.valueOf(consString) + "*";
            } else {
                consString = String.valueOf(consString) + "-";
            }
            ++i;
        }
        this.consSequence = new DrawableSequence(this.name, consString, this.start, this.end);
    }

    public static void main(String[] args) {
        Sequence[] s = null;
        s = FormatAdapter.toDrawableSequence(FormatAdapter.read(args[0], "File", args[1]));
        AlignFrame af = new AlignFrame(null, (DrawableSequence[])s);
        af.resize(700, 500);
        af.show();
        Vector<Sequence> tmp = new Vector<Sequence>();
        int i = 0;
        while (i < s.length) {
            tmp.addElement(s[i]);
            ++i;
        }
        Alignment al = new Alignment(s);
        al.percentIdentity();
        DrawableSequence[] c = new DrawableSequence[20];
        int count = 0;
        Enumeration en = ResidueProperties.propHash.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Hashtable<String, Hashtable> hyd = new Hashtable<String, Hashtable>();
            hyd.put(key, (Hashtable)ResidueProperties.propHash.get(key));
            Conservation cons = new Conservation(key, al.cons, hyd, 3, tmp, 0, s[0].getSequence().length() - 1);
            cons.calculate();
            cons.verdict(false, 20.0f);
            c[count++] = cons.consSequence;
        }
        Conservation cons2 = new Conservation("All", al.cons, ResidueProperties.propHash, 3, tmp, 0, s[0].getSequence().length() - 1);
        cons2.calculate();
        cons2.verdict(false, 20.0f);
        c[count++] = cons2.consSequence;
        af.ap.seqPanel.align.addSequence(c);
        int i2 = 0;
        while (i2 < count) {
            System.out.println(">" + c[i2].getName() + "\n" + c[i2].getSequence());
            ++i2;
        }
        System.exit(0);
    }
}

