/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.Popup;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.io.File;

public class FilePopup
extends Popup {
    TextField tf = new TextField(40);
    Label tfLabel = new Label("Filename : ");
    Button b;
    Label format = new Label("Alignment format");
    Choice f = new Choice();

    public FilePopup(Frame parent, String title) {
        super(parent, title);
        int i = 0;
        while (i < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(i));
            ++i;
        }
        this.b = new Button("Browse..");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 4, 1);
        this.add(this.format, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 1, 1, 1);
        this.add(this.b, this.gb, this.gbc, 5, 0, 1, 1);
        this.gbc.fill = 2;
        this.add(this.status, this.gb, this.gbc, 0, 2, 1, 1);
        this.gbc.fill = 0;
        this.add(this.apply, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 3, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            this.status.setText("Reading file...");
            this.status.validate();
            String fileStr = this.tf.getText();
            File tmp = new File(fileStr);
            if (tmp.isFile()) {
                DrawableSequence[] s = null;
                s = FormatAdapter.toDrawableSequence(FormatAdapter.read(fileStr, "File", this.f.getSelectedItem()));
                if (s != null) {
                    this.status.setText("Creating new alignment window...");
                    this.status.validate();
                    AlignFrame af = new AlignFrame(this.parent.getParent(), s);
                    if (af.ap.seqPanel.align.size() > 0) {
                        af.resize(700, 500);
                        af.show();
                        ConsThread ct = new ConsThread(af);
                        ct.start();
                    }
                    this.hide();
                    this.dispose();
                } else {
                    this.status.setText("ERROR: No sequences found. Check format.");
                }
            } else {
                this.status.setText("ERROR: File not found or wrong format");
            }
            return true;
        }
        if (e.target == this.b && e.id == 1001) {
            FileDialog fd = new FileDialog(this.parent, "Open alignment file", 0);
            fd.show();
            String dir = "";
            String file = "";
            if (fd.getDirectory() != null) {
                dir = fd.getDirectory();
            }
            if (fd.getFile() != null) {
                file = fd.getFile();
            }
            this.tf.setText(String.valueOf(dir) + file);
            return true;
        }
        return super.handleEvent(e);
    }
}

