/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BLCFile;
import jalview.ClustalFile;
import jalview.DrawableSequence;
import jalview.FastaFile;
import jalview.FormatProperties;
import jalview.JnetFile;
import jalview.MSFfile;
import jalview.MSPFile;
import jalview.PIRFile;
import jalview.PfamFile;
import jalview.PostalFile;
import jalview.Sequence;
import java.io.IOException;

public class FormatAdapter {
    public static String get(String format, Sequence[] s) {
        if (FormatProperties.contains(format)) {
            if (FormatProperties.indexOf(format) == FormatProperties.MSF) {
                return MSFfile.print(s);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.FASTA) {
                return FastaFile.print(s, 72);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.CLUSTAL) {
                return ClustalFile.print(s);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.PIR) {
                return PIRFile.print(s, 72);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.BLC) {
                return BLCFile.print(s);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.MSP) {
                return MSPFile.print(s);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.PFAM) {
                return PfamFile.print(s);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.POSTAL) {
                return PostalFile.print(s);
            }
            if (FormatProperties.indexOf(format) == FormatProperties.JNET) {
                return JnetFile.print(s);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Sequence[] read(String format, String inStr) {
        if (FormatProperties.contains(format)) {
            if (FormatProperties.indexOf(format) == FormatProperties.MSF) {
                MSFfile msf = new MSFfile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.FASTA) {
                FastaFile msf = new FastaFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.CLUSTAL) {
                ClustalFile msf = new ClustalFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.PIR) {
                PIRFile msf = new PIRFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.BLC) {
                BLCFile msf = new BLCFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.MSP) {
                MSPFile msf = new MSPFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.PFAM) {
                PfamFile msf = new PfamFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.POSTAL) {
                PostalFile msf = new PostalFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
            if (FormatProperties.indexOf(format) == FormatProperties.JNET) {
                JnetFile msf = new JnetFile(inStr);
                Sequence[] s = new Sequence[msf.seqs.size()];
                int i = 0;
                while (i < msf.seqs.size()) {
                    s[i] = (Sequence)msf.seqs.elementAt(i);
                    ++i;
                }
                return s;
            }
        } else {
            return null;
        }
        return null;
    }

    public static Sequence[] read(String infile, String type, String format) {
        System.out.println("In FormatAdapter");
        if (FormatProperties.contains(format)) {
            try {
                if (FormatProperties.indexOf(format) == FormatProperties.MSF) {
                    MSFfile msf = new MSFfile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.FASTA) {
                    System.out.println("In fasta");
                    FastaFile msf = new FastaFile(infile, type);
                    System.out.println("Size = " + msf.seqs.size());
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.CLUSTAL) {
                    ClustalFile msf = new ClustalFile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.PIR) {
                    PIRFile msf = new PIRFile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.BLC) {
                    BLCFile msf = new BLCFile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.MSP) {
                    MSPFile msf = new MSPFile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.PFAM) {
                    PfamFile msf = new PfamFile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.POSTAL) {
                    PostalFile msf = new PostalFile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
                if (FormatProperties.indexOf(format) == FormatProperties.JNET) {
                    JnetFile msf = new JnetFile(infile, type);
                    Sequence[] s = new Sequence[msf.seqs.size()];
                    int i = 0;
                    while (i < msf.seqs.size()) {
                        s[i] = (Sequence)msf.seqs.elementAt(i);
                        ++i;
                    }
                    return s;
                }
            }
            catch (IOException e) {
                System.out.println("IOException " + e + " in FormatAdapter");
            }
        } else {
            return null;
        }
        return null;
    }

    public static DrawableSequence[] toDrawableSequence(Sequence[] s) {
        System.out.println("In FormatAdapter " + s.length);
        DrawableSequence[] ds = new DrawableSequence[s.length];
        int i = 0;
        while (i < ds.length && s[i] != null) {
            ds[i] = new DrawableSequence(s[i]);
            ++i;
        }
        return ds;
    }

    public static void main(String[] args) {
        Sequence[] s = FormatAdapter.read(args[0], "File", args[1]);
        System.out.println(FormatAdapter.get(args[2], s));
    }
}

