/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Alignment;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.MSPSequence;
import jalview.QuickSort;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MSPFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector words = new Vector();
    long start;
    long end;

    public MSPFile(String inStr) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.readLines(inStr);
        this.parse();
    }

    public MSPFile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        System.out.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        int i = 0;
        while (i < this.lineArray.size()) {
            StringTokenizer st;
            String line = (String)this.lineArray.elementAt(i);
            if (line.indexOf("#") == -1 && (st = new StringTokenizer(line)).countTokens() == 8) {
                try {
                    String s = st.nextToken();
                    int score = Integer.parseInt(s);
                    String frame = st.nextToken();
                    int qstart = Integer.parseInt(st.nextToken());
                    int qend = Integer.parseInt(st.nextToken());
                    int hstart = Integer.parseInt(st.nextToken());
                    int hend = Integer.parseInt(st.nextToken());
                    String id = st.nextToken();
                    String seq2 = st.nextToken();
                    String database = "";
                    if (id.indexOf("|") != -1) {
                        StringTokenizer st2 = new StringTokenizer(id, "|");
                        while (st2.hasMoreTokens()) {
                            String tmp = st2.nextToken();
                            if (tmp.equals("")) continue;
                            id = tmp;
                        }
                    } else if (id.indexOf(":") != -1) {
                        database = id.substring(0, id.indexOf(":"));
                        id = id.substring(id.indexOf(":") + 1);
                    }
                    this.seqs.addElement(new MSPSequence(id, seq2, hstart, hend, qstart, qend, score, frame, database));
                }
                catch (NumberFormatException nfe) {
                    System.out.println("NumberFormatException " + nfe);
                }
            }
            ++i;
        }
        this.noSeqs = this.seqs.size();
    }

    public static String print(Sequence[] s) {
        return MSPFile.print(s, true);
    }

    public static String print(Sequence[] s, boolean gaps) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < s.length && s[i] != null) {
            if (s[i] instanceof MSPSequence) {
                MSPSequence tmp = (MSPSequence)s[i];
                out.append(String.valueOf(tmp.score) + " (" + tmp.frame + ")  " + tmp.qstart + " " + tmp.qend + " " + tmp.start + " " + tmp.end + " " + tmp.name + " " + tmp.sequence.substring(tmp.qstart - 1) + "\n");
            }
            ++i;
        }
        return out.toString();
    }

    public void extractSeqs(int sgapthresh, int qgapthresh, boolean fullseq) {
        Sequence[] seq2 = new MSPSequence[this.seqs.size()];
        new Vector();
        Vector<DrawableSequence> seq22 = new Vector<DrawableSequence>();
        int i = 0;
        while (i < this.seqs.size()) {
            seq2[i] = (MSPSequence)this.seqs.elementAt(i);
            ++i;
        }
        Alignment al = new Alignment(seq2);
        al.sortByID();
        int i2 = 0;
        while (i2 < al.sequences.length) {
            System.out.println(String.valueOf(i2) + " " + al.sequences[i2].name);
            ++i2;
        }
        i2 = 0;
        while (i2 < al.sequences.length) {
            String name = al.sequences[i2].name;
            Vector<Sequence> tmp2 = new Vector<Sequence>();
            tmp2.addElement(al.sequences[i2]);
            while (++i2 < al.sequences.length && al.sequences[i2].name.equals(name)) {
                System.out.println(String.valueOf(name) + " " + i2);
                tmp2.addElement(al.sequences[i2]);
                name = al.sequences[i2].name;
            }
            System.out.println("ID  " + i2 + " " + al.sequences[i2 - 1].name + " has " + tmp2.size() + " elements ");
            ((Sequence)tmp2.elementAt(0)).getFeatures("srs.ebi.ac.uk/srs5bin/cgi-bin/", "swall");
            Sequence sp = ((Sequence)tmp2.elementAt((int)0)).sp.sequence;
            if (sp != null) {
                if (!fullseq) {
                    if (tmp2.size() > 1) {
                        Object[] tmp3 = new MSPSequence[tmp2.size()];
                        float[] starts = new float[tmp2.size()];
                        int j = 0;
                        while (j < tmp3.length) {
                            tmp3[j] = (MSPSequence)tmp2.elementAt(j);
                            starts[j] = ((MSPSequence)tmp3[j]).start;
                            ++j;
                        }
                        QuickSort.sort(starts, tmp3);
                        int start = ((MSPSequence)tmp3[0]).start;
                        int end = ((MSPSequence)tmp3[0]).end;
                        int qend = ((MSPSequence)tmp3[0]).qend;
                        Vector<Integer> jstart = new Vector<Integer>();
                        Vector<Integer> jend = new Vector<Integer>();
                        jstart.addElement(new Integer(start));
                        int k = 1;
                        while (k < tmp3.length) {
                            int sgap = ((MSPSequence)tmp3[k]).start - end;
                            int qgap = ((MSPSequence)tmp3[k]).qstart - qend;
                            if (((MSPSequence)tmp3[k]).start < end && ((MSPSequence)tmp3[k]).end > end) {
                                end = ((MSPSequence)tmp3[k]).end;
                                qend = ((MSPSequence)tmp3[k]).qend;
                            } else if (sgap == qgap && sgap < sgapthresh) {
                                end = ((MSPSequence)tmp3[k]).end;
                            } else if ((qgap - sgap) / qgap < qgapthresh) {
                                end = ((MSPSequence)tmp3[k]).end;
                            } else {
                                jend.addElement(new Integer(end));
                                jstart.addElement(new Integer(((MSPSequence)tmp3[k]).start));
                                start = ((MSPSequence)tmp3[k]).start;
                                end = ((MSPSequence)tmp3[k]).end;
                            }
                            ++k;
                        }
                        jend.addElement(new Integer(end));
                        int kk = 0;
                        while (kk < jstart.size()) {
                            int lstart = (Integer)jstart.elementAt(kk);
                            int lend = (Integer)jend.elementAt(kk);
                            seq22.addElement(new DrawableSequence(sp.name, sp.sequence.substring(lstart - 1, lend - 1), lstart, lend));
                            ++kk;
                        }
                        continue;
                    }
                    Sequence t2 = (Sequence)tmp2.elementAt(0);
                    String useq = this.unPad(t2.sequence, true);
                    useq = this.unPad(useq, false);
                    seq22.addElement(new DrawableSequence(t2.name, useq, t2.start, t2.end));
                    continue;
                }
                System.out.println("Adding " + sp.name);
                seq22.addElement(new DrawableSequence(sp.name, sp.sequence, sp.start, sp.end));
                continue;
            }
            System.out.println("ERROR: Couldn't fetch SRS sequence");
        }
        DrawableSequence[] outseq = new DrawableSequence[seq22.size()];
        int l = 0;
        while (l < seq22.size()) {
            DrawableSequence t;
            outseq[l] = t = (DrawableSequence)seq22.elementAt(l);
            System.out.println(String.valueOf(t.name) + " " + t.start + " " + t.end + " " + t.sequence);
            ++l;
        }
        AlignFrame aa = new AlignFrame(outseq);
        aa.resize(700, 500);
        aa.show();
    }

    public String unPad(String in, boolean end) {
        if (end) {
            while (in.length() > 0 && (in.substring(0, 1).equals(" ") || in.substring(0, 1).equals("-") || in.substring(0, 1).equals("."))) {
                in = in.substring(1);
            }
            return in;
        }
        if (!end) {
            while (in.length() > 0 && (in.substring(in.length() - 1).equals(" ") || in.substring(in.length() - 1).equals("-") || in.substring(in.length() - 1).equals("."))) {
                in = in.substring(0, in.length() - 1);
            }
            return in;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            MSPFile msp = new MSPFile(args[0], "File");
            Sequence[] s = new MSPSequence[msp.seqs.size()];
            msp.extractSeqs(5, 20, true);
            int i = 0;
            while (i < msp.seqs.size()) {
                s[i] = (MSPSequence)msp.seqs.elementAt(i);
                ++i;
            }
            String out = MSPFile.print(s);
            AlignFrame af = new AlignFrame((DrawableSequence[])s);
            af.resize(700, 500);
            af.show();
            ConsThread ct = new ConsThread(af);
            ct.start();
            System.out.println(out);
            System.out.println("done");
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

