/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.FormatProperties;
import jalview.Mail;
import jalview.OutputGenerator;
import jalview.Popup;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.net.InetAddress;

public class MailTextPopup
extends Popup {
    TextField tf;
    Label tfLabel;
    Mail mail;
    Label format;
    Choice f;
    OutputGenerator og;

    public MailTextPopup(Frame parent, String title, OutputGenerator og) {
        super(parent, title);
        this.og = og;
        this.tf = new TextField(40);
        this.tf.setText(og.getMailProperties().address);
        this.tfLabel = new Label("Mail address : ");
        this.format = new Label("Alignment format");
        this.f = new Choice();
        int i = 0;
        while (i < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(i));
            ++i;
        }
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 4, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 2, 1, 1);
        this.add(this.format, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 1, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.apply && evt.id == 1001) {
            String address = this.tf.getText();
            if (address.indexOf(64) == -1) {
                System.out.println("Invalid mail address (enter name@my.email.server )");
                this.hide();
                this.dispose();
            } else {
                System.out.println("Mail address " + address);
                this.og.getMailProperties().address = address;
                this.mail = new Mail();
                String recipient = this.og.getMailProperties().address;
                String author = "<michele@ebi.ac.uk>";
                String subject = "Jalview alignment";
                String text = "";
                System.out.println("Mail Server = " + this.og.getMailProperties().server);
                if (this.og.getMailProperties().server != null && !this.og.getMailProperties().server.equals("")) {
                    this.mail.send(this.og.getMailProperties().server, recipient, author, subject, text);
                    this.sendText();
                    this.mail.finish();
                    InetAddress ia = null;
                    String pog = "";
                    try {
                        ia = InetAddress.getLocalHost();
                        pog = ia.getHostName();
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                    }
                    subject = "Jalview sent to " + this.og.getMailProperties().address + " (" + pog + ")";
                    System.out.println("Mail server = " + this.og.getMailProperties().server);
                    this.mail.send(this.og.getMailProperties().server, "michele@ebi.ac.uk", author, subject, text);
                }
                this.mail.finish();
                this.hide();
                this.dispose();
            }
            return true;
        }
        return super.handleEvent(evt);
    }

    public void sendText() {
        String text = "";
        text = this.og.getText(this.f.getSelectedItem());
        this.mail.send(this.mail.out, text);
    }

    public static void main(String[] args) {
        AlignFrame af = new AlignFrame(null, "lipase.msf", "File", "MSF");
        af.resize(700, 300);
        af.show();
        new MailTextPopup((Frame)af, "Popup", af);
    }
}

