/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.FilePopup;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class OutputFilePopup
extends FilePopup {
    public OutputFilePopup(Frame parent, String title) {
        super(parent, title);
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            String fileStr = this.tf.getText();
            if (FormatProperties.contains(this.f.getSelectedItem())) {
                if (this.parent instanceof AlignFrame) {
                    AlignFrame af = (AlignFrame)this.parent;
                    String outStr = FormatAdapter.get(this.f.getSelectedItem().toUpperCase(), af.ap.seqPanel.align.sequences);
                    System.out.println(String.valueOf(outStr) + " " + fileStr);
                    try {
                        PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileStr)));
                        this.status.setText("Saving file");
                        this.status.validate();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                        ps.print(outStr);
                        ps.close();
                        this.status.setText("done");
                        this.status.validate();
                        this.hide();
                        this.dispose();
                    }
                    catch (IOException ex) {
                        this.status.setText("ERROR: Can't open file");
                        System.out.println("Exception : " + ex);
                    }
                } else {
                    System.out.println("Error : parent isn't Alignment Frame");
                }
            } else {
                this.status.setText("Format not yet supported");
            }
            return true;
        }
        if (e.target == this.b && e.id == 1001) {
            FileDialog fd = new FileDialog(this.parent, "Save alignment file", 0);
            fd.show();
            String dir = "";
            String file = "";
            if (fd.getDirectory() != null) {
                dir = fd.getDirectory();
            }
            if (fd.getFile() != null) {
                file = fd.getFile();
            }
            this.tf.setText(String.valueOf(dir) + file);
            return true;
        }
        return super.handleEvent(e);
    }
}

