/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableAlignment;
import jalview.DrawableSequence;
import jalview.Popup;
import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.io.IOException;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.Vector;

public class PDBPopup
extends Popup {
    PrintStream o = System.out;
    List pdbList;
    Label title1;
    Label title1a;
    Label title2;
    Label sequenceLabel;
    TextField tf;
    Label tfLabel;
    Button fetch;
    DrawableAlignment da;
    Vector codes;
    DrawableSequence seq;

    public PDBPopup(Frame parent, String title, DrawableAlignment da) {
        super(parent, title);
        System.out.println("poppoy");
        this.da = da;
        this.title1 = new Label("Select a pdb code obtained from the database entry");
        this.title2 = new Label("Or enter a code yourself");
        this.sequenceLabel = new Label("No code selected");
        this.title1a = new Label();
        this.pdbList = new List(9, false);
        this.addCodes();
        this.tf = new TextField(20);
        this.tfLabel = new Label("Enter PDB code");
        this.fetch = new Button("Fetch structure");
        this.apply.setLabel("Fetch structure");
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.add(this.title1, this.gb, this.gbc, 0, 0, 2, 1);
        this.add(this.pdbList, this.gb, this.gbc, 0, 1, 1, 3);
        this.add(this.sequenceLabel, this.gb, this.gbc, 1, 1, 1, 1);
        this.add(this.title1a, this.gb, this.gbc, 1, 2, 1, 1);
        this.gbc.fill = 0;
        this.add(this.apply, this.gb, this.gbc, 1, 3, 1, 1);
        this.gbc.fill = 1;
        this.add(this.title2, this.gb, this.gbc, 0, 4, 2, 1);
        this.add(this.tf, this.gb, this.gbc, 0, 5, 1, 1);
        this.gbc.fill = 0;
        this.add(this.fetch, this.gb, this.gbc, 1, 5, 1, 1);
        this.gbc.fill = 1;
        this.status = new Label("Status:", 0);
        this.add(this.status, this.gb, this.gbc, 0, 6, 2, 1);
        this.gbc.fill = 0;
        this.add(this.close, this.gb, this.gbc, 0, 7, 2, 1);
        this.pack();
        this.show();
    }

    public void addCodes() {
        this.codes = this.da.getPDBCodes();
        if (this.codes.size() == 0) {
            this.sequenceLabel.setText("No PDB codes available");
        } else {
            int i = 0;
            while (i < this.codes.size()) {
                this.pdbList.addItem((String)this.codes.elementAt(i));
                ++i;
            }
        }
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            this.applyCommand();
        } else if (e.target == this.fetch && e.id == 1001 & !this.tf.getText().equals("")) {
            if (this.da.ds[0].pdbcode == null) {
                this.da.ds[0].pdbcode = new Vector();
            }
            this.da.ds[0].pdbcode.insertElementAt(this.tf.getText(), 0);
            this.seq = this.da.ds[0];
            this.applyCommand();
        } else {
            if (e.target == this.pdbList) {
                String code = this.pdbList.getSelectedItem();
                int i = 0;
                while (i < this.da.ds.length && this.da.ds[i] != null) {
                    if (this.da.ds[i].pdbcode != null) {
                        int j = 0;
                        while (j < this.da.ds[i].pdbcode.size()) {
                            if (((String)this.da.ds[i].pdbcode.elementAt(j)).equals(code)) {
                                this.seq = this.da.ds[i];
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.sequenceLabel.setText("PDB structure is attached to :");
                this.title1a.setText(this.seq.name);
                return true;
            }
            super.handleEvent(e);
        }
        return super.handleEvent(e);
    }

    public void applyCommand() {
        if (this.seq != null) {
            if (this.parent instanceof AlignFrame) {
                try {
                    AlignFrame cfr_ignored_0 = (AlignFrame)this.parent;
                    AlignFrame.fetchPDBStructure(this.seq, ((AlignFrame)this.parent).srsServer);
                }
                catch (UnknownHostException e) {
                    System.out.print("\u0007");
                    System.out.flush();
                    this.status.setText("ERROR: host can't be contacted");
                    this.status.validate();
                    System.out.println(e);
                }
                catch (IOException e) {
                    System.out.print("\u0007");
                    System.out.flush();
                    this.status.setText("ERROR: IO exception in fetching pdb entry");
                    this.status.validate();
                    System.out.println(e);
                }
            } else {
                try {
                    AlignFrame.fetchPDBStructure(this.seq, "srs.ebi.ac.uk/srs5bin/cgi-bin/");
                }
                catch (IOException e) {
                    System.out.println("Exception in fetching pdb structure " + e);
                }
            }
        } else {
            this.sequenceLabel.setText("No sequence found");
        }
    }
}

