/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.FileProperties;
import jalview.MSFfile;
import jalview.MailProperties;
import jalview.NJTree;
import jalview.OutputGenerator;
import jalview.PostscriptPopup;
import jalview.PostscriptProperties;
import jalview.Sequence;
import jalview.TreeThreadCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;
import java.util.Vector;

public class TreePanel
extends Panel {
    NJTree njt;
    Object parent;
    Panel p;
    Button close;
    Button output;
    Checkbox cb;
    TreeThreadCanvas mc;
    Choice f;
    MailProperties mp;
    FileProperties fp;
    PostscriptProperties pp;
    Vector selected;

    public TreePanel(Object parent, NJTree njt) {
        this.njt = njt;
        this.parent = parent;
        this.treeInit();
    }

    public TreePanel(Object parent, Sequence[] s, String treetype, String pairdist) {
        this.njt = new NJTree(s, treetype, pairdist);
        if (parent instanceof AlignFrame) {
            ((AlignFrame)parent).status.setText("Finished calculating tree");
            ((AlignFrame)parent).status.validate();
        }
        this.parent = parent;
        this.treeInit();
    }

    public TreePanel(Object parent, Sequence[] s) {
        this(parent, s, "AV", "PID");
    }

    public void treeInit() {
        this.setLayout(new BorderLayout());
        this.p = new Panel();
        Panel p2 = new Panel();
        this.p.setLayout(new BorderLayout());
        p2.setLayout(new FlowLayout());
        this.close = new Button("Close");
        this.output = new Button("Output");
        this.cb = new Checkbox("Show distances");
        this.cb.setState(false);
        Label l = new Label("Font size");
        this.f = new Choice();
        this.f.addItem("6");
        this.f.addItem("8");
        this.f.addItem("10");
        this.f.addItem("12");
        this.f.addItem("14");
        this.f.select("8");
        this.njt.tf.setFontSize(8);
        this.njt.tf.showDistances = false;
        this.njt.tf.reCount(this.njt.tf.top);
        this.njt.tf.findHeight(this.njt.tf.top);
        this.mc = new TreeThreadCanvas(this.njt.tf);
        this.mc.setBackground(Color.white);
        if (this.parent instanceof OutputGenerator) {
            this.njt.tf.mp.server = ((OutputGenerator)this.parent).getMailProperties().server;
        }
        this.p.add("Center", this.mc);
        p2.add(l);
        p2.add(this.f);
        p2.add(this.cb);
        p2.add(this.close);
        p2.add(this.output);
        this.add("Center", this.p);
        this.add("South", p2);
        if (this.parent instanceof AlignFrame) {
            this.selected = ((AlignFrame)this.parent).ap.sel;
            this.njt.tf.selected = ((AlignFrame)this.parent).ap.sel;
        } else {
            this.selected = new Vector();
        }
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (e.target == this.mc) {
            Object ob = this.njt.tf.findElement(this.mc, x, y);
            if (ob instanceof Sequence) {
                Sequence s = (Sequence)ob;
                System.out.println(s.name);
                if (this.selected.contains(s)) {
                    this.selected.removeElement(s);
                } else {
                    this.selected.addElement(s);
                }
                if (this.parent instanceof AlignFrame) {
                    AlignFrame af = (AlignFrame)this.parent;
                    af.ap.idPanel.idCanvas.paintFlag = true;
                    af.ap.idPanel.idCanvas.repaint();
                    if (af.pca != null) {
                        af.pca.p.rc.redrawneeded = true;
                        af.pca.p.rc.repaint();
                    }
                }
                this.mc.repaint();
            } else if (this.njt.tf.maxheight != 0.0f) {
                float t = (float)(x - this.njt.tf.offx) / (float)((double)this.size().width * 0.8 - (double)(2 * this.njt.tf.offx));
                System.out.println("New threshold = " + t);
                this.mc.threshold = x;
                this.mc.paint(this.mc.getGraphics());
                if (this.parent instanceof AlignFrame) {
                    AlignFrame af = (AlignFrame)this.parent;
                    af.regroup(t);
                }
            }
        }
        return true;
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target == this.f) {
            int size = Integer.parseInt(this.f.getSelectedItem());
            this.njt.tf.setFontSize(size);
            this.mc.repaint();
        }
        return true;
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.close && evt.id == 1001) {
            this.hide();
            if (this.getParent() instanceof Frame) {
                ((Frame)this.getParent()).dispose();
            }
            return true;
        }
        if (evt.target == this.output && evt.id == 1001) {
            if (this.parent instanceof Frame) {
                new PostscriptPopup((Frame)this.parent, "Mail postscript", this.njt.tf);
            }
            return true;
        }
        if (evt.target == this.cb) {
            this.njt.tf.showDistances = this.cb.getState();
            this.mc.repaint();
            if (this.parent instanceof Frame) {
                ((Frame)this.parent).validate();
            }
            return true;
        }
        return super.handleEvent(evt);
    }

    public void show() {
        super.show();
        this.njt.tf.draw(this.p.getGraphics(), 500, 500);
    }

    public static void main(String[] args) {
        try {
            MSFfile msf = new MSFfile(args[0], "File");
            Sequence[] s = new Sequence[msf.seqs.size()];
            int i = 0;
            while (i < msf.seqs.size()) {
                s[i] = (Sequence)msf.seqs.elementAt(i);
                ++i;
            }
            Frame tf = new Frame("Average distance tree");
            TreePanel tp = new TreePanel((Object)tf, s);
            tf.setLayout(new BorderLayout());
            tf.add("Center", tp);
            tf.resize(500, 500);
            tf.show();
        }
        catch (IOException e) {
            System.out.println("Exception : " + e);
        }
    }
}

