/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;
import uk.ac.sanger.artemis.ChangeEvent;
import uk.ac.sanger.artemis.ChangeListener;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class Selection
implements FeatureChangeListener,
EntryChangeListener,
Transferable,
ClipboardOwner {
    private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};
    private FeatureVector features = new FeatureVector();
    private FeatureSegmentVector segments = new FeatureSegmentVector();
    private FeatureVector all_features = null;
    private MarkerRange marker_range = null;
    private final Vector selection_listener_list = new Vector();
    private final Clipboard clipboard;
    private Marker lowest_base_marker = null;
    private Marker highest_base_marker = null;
    private Marker start_base_marker = null;
    private Marker end_base_marker = null;

    public Selection(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.stringFlavor);
    }

    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.getSelectionText();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public String getSelectionText() {
        FeatureVector selection_features = this.getAllFeatures();
        StringBuffer buffer = new StringBuffer();
        MarkerRange marker_range = this.getMarkerRange();
        if (marker_range != null) {
            String selection_bases = Strand.markerRangeBases(marker_range);
            buffer.append(selection_bases);
        }
        int i = 0;
        while (i < selection_features.size() && i < 50) {
            buffer.append(selection_features.elementAt(i).toString());
            ++i;
        }
        return buffer.toString();
    }

    public void featureChanged(FeatureChangeEvent event) {
        if (this.segments == null && this.features.contains(event.getFeature()) || this.getAllFeatures().contains(event.getFeature())) {
            if (event.getType() == 2 || event.getType() == 3) {
                SelectionChangeEvent selection_change_event = new SelectionChangeEvent(this, 3);
                this.fireAction(this.selection_listener_list, selection_change_event);
            } else {
                this.changeSelection(3);
            }
        }
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.features.remove(event.getFeature());
                if (this.contains(event.getFeature())) {
                    this.removeSegmentsOf(event.getFeature());
                    break;
                }
                this.changeSelection(1);
            }
        }
    }

    public void addSelectionChangeListener(SelectionChangeListener l) {
        this.selection_listener_list.addElement(l);
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        this.selection_listener_list.removeElement(l);
    }

    private void changeSelection(int type) {
        this.resetCache();
        SelectionChangeEvent event = new SelectionChangeEvent(this, type);
        this.fireAction(this.selection_listener_list, event);
        if (this.clipboard != null) {
            this.clipboard.setContents(this, this);
        }
    }

    public void add(Feature feature) {
        if (this.addWithoutEvent(feature)) {
            this.changeSelection(1);
        }
    }

    public void add(FeatureVector features) {
        int i = 0;
        while (i < features.size()) {
            this.addWithoutEvent(features.elementAt(i));
            ++i;
        }
        this.changeSelection(1);
    }

    private boolean addWithoutEvent(Feature feature) {
        if (this.features.contains(feature)) {
            return false;
        }
        this.features.add(feature);
        return true;
    }

    public void add(FeatureSegment segment) {
        if (this.addWithoutEvent(segment)) {
            this.changeSelection(1);
        }
    }

    private boolean addWithoutEvent(FeatureSegment segment) {
        if (this.segments.contains(segment)) {
            return false;
        }
        this.segments.addElement(segment);
        return true;
    }

    public void set(Feature feature) {
        this.clearWithoutEvent();
        this.addWithoutEvent(feature);
        this.changeSelection(1);
    }

    public void set(FeatureSegment feature_segment) {
        this.clearWithoutEvent();
        this.addWithoutEvent(feature_segment);
        this.changeSelection(1);
    }

    public void set(FeatureVector features) {
        this.clearWithoutEvent();
        int i = 0;
        while (i < features.size()) {
            this.addWithoutEvent(features.elementAt(i));
            ++i;
        }
        this.changeSelection(1);
    }

    public void setMarkerRange(MarkerRange marker_range) {
        if (this.marker_range != marker_range) {
            MarkerRange old_marker_range = this.marker_range;
            this.clearWithoutEvent();
            this.marker_range = marker_range;
            if (old_marker_range == null) {
                this.changeSelection(1);
            } else {
                this.changeSelection(3);
            }
        }
    }

    public boolean isEmpty() {
        return this.features.size() == 0 && this.segments.size() == 0 && this.marker_range == null;
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.clearWithoutEvent();
            this.changeSelection(1);
        }
    }

    private void clearWithoutEvent() {
        this.features.removeAllElements();
        this.segments.removeAllElements();
        this.marker_range = null;
    }

    public void remove(Feature feature) {
        if (this.features.remove(feature)) {
            this.changeSelection(1);
        }
    }

    public void removeSegmentsOf(Feature feature) {
        FeatureSegmentVector segments = feature.getSegments();
        int segment_index = 0;
        while (segment_index < segments.size()) {
            FeatureSegment this_segment = segments.elementAt(segment_index);
            this.remove(this_segment);
            ++segment_index;
        }
    }

    public void remove(FeatureSegment segment) {
        if (this.segments.removeElement(segment)) {
            this.changeSelection(1);
        }
    }

    public boolean contains(Feature feature) {
        if (this.getSelectedFeatures().contains(feature)) {
            return true;
        }
        int i = 0;
        while (i < this.segments.size()) {
            FeatureSegment this_segment = this.segments.elementAt(i);
            Feature this_feature = this_segment.getFeature();
            if (feature == this_feature) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(FeatureSegment feature_segment) {
        return this.getAllSegments().indexOf(feature_segment) != -1;
    }

    public Range getSelectionRange() {
        Marker lowest_base_marker = this.getLowestBaseOfSelection();
        Marker highest_base_marker = this.getHighestBaseOfSelection();
        if (lowest_base_marker == null || highest_base_marker == null) {
            return null;
        }
        lowest_base_marker.getStrand();
        int first_postion = lowest_base_marker.getRawPosition();
        int last_postion = highest_base_marker.getRawPosition();
        try {
            return new Range(first_postion, last_postion);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public RangeVector getSelectionRanges() {
        RangeVector return_ranges = new RangeVector();
        if (this.getSelectedFeatures().size() > 0 || this.getSelectedSegments().size() > 0) {
            FeatureSegmentVector segments = this.getAllSegments();
            int i = 0;
            while (i < segments.size()) {
                FeatureSegment this_segment = segments.elementAt(i);
                return_ranges.add(this_segment.getRawRange());
                ++i;
            }
        } else {
            MarkerRange marker_range = this.getMarkerRange();
            if (marker_range != null) {
                return_ranges.add(marker_range.getRawRange());
            }
        }
        return return_ranges;
    }

    public Marker getLowestBaseOfSelection() {
        if (this.lowest_base_marker != null) {
            return this.lowest_base_marker;
        }
        if (this.getSelectedFeatures().size() > 0 || this.getSelectedSegments().size() > 0) {
            FeatureSegmentVector segments = this.getAllSegments();
            int current_min = 99999999;
            Marker current_min_marker = null;
            int i = 0;
            while (i < segments.size()) {
                Marker end_marker;
                FeatureSegment this_segment = segments.elementAt(i);
                Marker start_marker = this_segment.getStart();
                if (start_marker.getRawPosition() < current_min) {
                    current_min = start_marker.getRawPosition();
                    current_min_marker = start_marker;
                }
                if ((end_marker = this_segment.getEnd()).getRawPosition() < current_min) {
                    current_min = end_marker.getRawPosition();
                    current_min_marker = end_marker;
                }
                ++i;
            }
            this.lowest_base_marker = current_min_marker;
        } else {
            MarkerRange range = this.getMarkerRange();
            this.lowest_base_marker = range == null ? null : (range.isForwardMarker() ? range.getStart() : range.getEnd());
        }
        return this.lowest_base_marker;
    }

    public Marker getHighestBaseOfSelection() {
        if (this.highest_base_marker != null) {
            return this.highest_base_marker;
        }
        if (this.getSelectedFeatures().size() > 0 || this.getSelectedSegments().size() > 0) {
            FeatureSegmentVector segments = this.getAllSegments();
            int current_max = -1;
            Marker current_max_marker = null;
            int i = 0;
            while (i < segments.size()) {
                Marker end_marker;
                FeatureSegment this_segment = segments.elementAt(i);
                Marker start_marker = this_segment.getStart();
                if (start_marker.getRawPosition() > current_max) {
                    current_max = start_marker.getRawPosition();
                    current_max_marker = start_marker;
                }
                if ((end_marker = this_segment.getEnd()).getRawPosition() > current_max) {
                    current_max = end_marker.getRawPosition();
                    current_max_marker = end_marker;
                }
                ++i;
            }
            this.highest_base_marker = current_max_marker;
        } else {
            MarkerRange range = this.getMarkerRange();
            this.highest_base_marker = range == null ? null : (range.isForwardMarker() ? range.getEnd() : range.getStart());
        }
        return this.highest_base_marker;
    }

    public Marker getStartBaseOfSelection() {
        if (this.start_base_marker != null) {
            return this.start_base_marker;
        }
        if (this.getSelectedFeatures().size() > 0 || this.getSelectedSegments().size() > 0) {
            FeatureSegmentVector segments = this.getAllSegments();
            boolean seen_forward_feature = false;
            boolean seen_reverse_feature = false;
            int current_min = 99999999;
            FeatureSegment current_min_segment = null;
            int i = 0;
            while (i < segments.size()) {
                FeatureSegment this_segment = segments.elementAt(i);
                if (this_segment.getFeature().isForwardFeature()) {
                    seen_forward_feature = true;
                } else {
                    seen_reverse_feature = true;
                }
                if (seen_forward_feature && seen_reverse_feature) {
                    return this.getLowestBaseOfSelection();
                }
                Marker start_marker = this_segment.getStart();
                if (current_min_segment == null || start_marker.getPosition() < current_min) {
                    current_min = start_marker.getPosition();
                    current_min_segment = this_segment;
                }
                ++i;
            }
            this.start_base_marker = current_min_segment == null ? null : current_min_segment.getStart();
        } else {
            MarkerRange range = this.getMarkerRange();
            this.start_base_marker = range == null ? null : range.getStart();
        }
        return this.start_base_marker;
    }

    public Marker getEndBaseOfSelection() {
        if (this.end_base_marker != null) {
            return this.end_base_marker;
        }
        if (this.getSelectedFeatures().size() > 0 || this.getSelectedSegments().size() > 0) {
            FeatureSegmentVector segments = this.getAllSegments();
            boolean seen_forward_feature = false;
            boolean seen_reverse_feature = false;
            int current_max = -1;
            FeatureSegment current_max_segment = null;
            int i = 0;
            while (i < segments.size()) {
                FeatureSegment this_segment = segments.elementAt(i);
                if (this_segment.getFeature().isForwardFeature()) {
                    seen_forward_feature = true;
                } else {
                    seen_reverse_feature = true;
                }
                if (seen_forward_feature && seen_reverse_feature) {
                    return this.getHighestBaseOfSelection();
                }
                Marker start_marker = this_segment.getStart();
                if (current_max_segment == null || start_marker.getPosition() > current_max) {
                    current_max = start_marker.getPosition();
                    current_max_segment = this_segment;
                }
                ++i;
            }
            this.end_base_marker = current_max_segment == null ? null : current_max_segment.getEnd();
        } else {
            MarkerRange range = this.getMarkerRange();
            this.end_base_marker = range == null ? null : range.getEnd();
        }
        return this.end_base_marker;
    }

    public String getSelectedBases() {
        if (this.getMarkerRange() == null) {
            StringBuffer buffer = new StringBuffer();
            FeatureVector all_features = this.getAllFeatures();
            int i = 0;
            while (i < all_features.size()) {
                Feature this_feature = all_features.elementAt(i);
                buffer.append(this_feature.getBases());
                ++i;
            }
            return buffer.toString();
        }
        return Strand.markerRangeBases(this.getMarkerRange());
    }

    public MarkerRange getMarkerRange() {
        return this.marker_range;
    }

    public FeatureVector getSelectedFeatures() {
        return this.features;
    }

    public FeatureSegmentVector getSelectedSegments() {
        return this.segments;
    }

    public FeatureSegmentVector getAllSegments() {
        FeatureSegmentVector return_segments = new FeatureSegmentVector();
        int i = 0;
        while (i < this.features.size()) {
            Feature selection_feature = this.features.elementAt(i);
            FeatureSegmentVector segments = selection_feature.getSegments();
            int segment_index = 0;
            while (segment_index < segments.size()) {
                FeatureSegment this_segment = segments.elementAt(segment_index);
                if (!return_segments.contains(this_segment)) {
                    return_segments.addElement(this_segment);
                }
                ++segment_index;
            }
            ++i;
        }
        i = 0;
        while (i < this.segments.size()) {
            FeatureSegment this_segment = this.segments.elementAt(i);
            if (!return_segments.contains(this_segment)) {
                return_segments.addElement(this_segment);
            }
            ++i;
        }
        return return_segments;
    }

    public FeatureVector getAllFeatures() {
        if (this.all_features == null) {
            this.all_features = (FeatureVector)this.features.clone();
            int i = 0;
            while (i < this.segments.size()) {
                FeatureSegment this_segment = this.segments.elementAt(i);
                Feature this_feature = this_segment.getFeature();
                if (!this.all_features.contains(this_feature)) {
                    this.all_features.add(this_feature);
                }
                ++i;
            }
        }
        return this.all_features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(Vector listeners, ChangeEvent event) {
        Vector targets;
        Selection selection = this;
        synchronized (selection) {
            targets = (Vector)listeners.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            ChangeListener target = (ChangeListener)targets.elementAt(i);
            if (!(event instanceof SelectionChangeEvent)) {
                throw new Error("Selection.fireAction () - unknown event");
            }
            SelectionChangeListener selection_change_listener = (SelectionChangeListener)target;
            selection_change_listener.selectionChanged((SelectionChangeEvent)event);
            ++i;
        }
    }

    private void resetCache() {
        this.lowest_base_marker = null;
        this.highest_base_marker = null;
        this.start_base_marker = null;
        this.end_base_marker = null;
        this.all_features = null;
    }
}

