/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import uk.ac.sanger.artemis.ExternalProgramEvent;
import uk.ac.sanger.artemis.ExternalProgramMonitor;
import uk.ac.sanger.artemis.Logger;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.SimpleExternalProgramMonitor;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.Task;

public class TaskMonitor
extends SimpleExternalProgramMonitor
implements ExternalProgramMonitor {
    private final int SLEEP_TIME;
    public final Task task;

    public TaskMonitor(Task task, String name, Logger logger) {
        super(name, logger);
        this.task = task;
        this.SLEEP_TIME = 1000 * Options.getOptions().getIntegerProperty("jcon_task_check_time");
    }

    public void run() {
        while (true) {
            try {
                Status status = this.task.getStatus();
                String message = null;
                if (status == null) {
                    message = String.valueOf(this.getProgramName()) + " disappeared";
                } else {
                    int status_id = status.getId();
                    switch (status_id) {
                        case 4: {
                            message = String.valueOf(this.getProgramName()) + " completed";
                            break;
                        }
                        case 5: {
                            message = String.valueOf(this.getProgramName()) + " failed";
                            break;
                        }
                        case 6: {
                            message = String.valueOf(this.getProgramName()) + " cancelled";
                            break;
                        }
                        case 7: {
                            message = String.valueOf(this.getProgramName()) + " skipped";
                        }
                    }
                }
                if (message != null) {
                    ExternalProgramEvent event = new ExternalProgramEvent(1, message, this.task);
                    this.sendEvent(event);
                    this.getLogger().log(String.valueOf(message) + "\n");
                    return;
                }
                Thread.sleep(this.SLEEP_TIME);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

