/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import org.biojava.bio.seq.io.SequenceFormat;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.EntrySourceVector;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.EntryEdit;
import uk.ac.sanger.artemis.components.EntryEditVector;
import uk.ac.sanger.artemis.components.EntryFileDialog;
import uk.ac.sanger.artemis.components.FileManager;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.Splash;
import uk.ac.sanger.artemis.components.SwingWorker;
import uk.ac.sanger.artemis.io.BioJavaEntry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.DocumentFactory;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class ArtemisMain
extends Splash {
    public static final String version = "Release 6 (Java2)";
    private EntryEditVector entry_edit_objects = new EntryEditVector();
    protected static FileManager filemanager = null;

    public ArtemisMain() {
        super("Artemis", "Artemis", version);
        ActionListener menu_listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (filemanager == null) {
                    filemanager = new FileManager(ArtemisMain.this);
                } else {
                    filemanager.setVisible(true);
                }
            }
        };
        ArtemisMain.makeMenuItem(this.file_menu, "Open File Manager ...", menu_listener);
        EntrySourceVector entry_sources = this.getEntrySources(this);
        int source_index = 0;
        while (source_index < entry_sources.size()) {
            final EntrySource this_entry_source = entry_sources.elementAt(source_index);
            String entry_source_name = this_entry_source.getSourceName();
            String menu_name = null;
            menu_name = entry_source_name.equals("Filesystem") ? "Open ..." : "Open from " + entry_source_name + " ...";
            menu_listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ArtemisMain.this.getEntryEditFromEntrySource(this_entry_source);
                }
            };
            ArtemisMain.makeMenuItem(this.file_menu, menu_name, menu_listener);
            ++source_index;
        }
        menu_listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ArtemisMain.this.exit();
            }
        };
        ArtemisMain.makeMenuItem(this.file_menu, "Quit", menu_listener);
    }

    public void readArgsAndOptions(String[] args, ProgressThread progress_thread) {
        if (args.length == 0) {
            this.readDefaultEntries();
            return;
        }
        if (args[0].equals("-biojava")) {
            this.handleBioJava(args);
            return;
        }
        EntryInformation artemis_entry_information = Options.getArtemisEntryInformation();
        Window last_entry_edit = null;
        boolean seen_plus = false;
        if (progress_thread != null) {
            progress_thread.start();
        }
        int i = 0;
        while (i < args.length) {
            String new_entry_name = args[i];
            if (new_entry_name.length() != 0) {
                Document entry_document;
                if (new_entry_name.equals("+")) {
                    seen_plus = true;
                } else if (new_entry_name.startsWith("+") && last_entry_edit != null || seen_plus) {
                    entry_document = seen_plus ? DocumentFactory.makeDocument(new_entry_name) : DocumentFactory.makeDocument(new_entry_name.substring(1));
                    InputStreamProgressListener progress_listener = this.getInputStreamProgressListener();
                    entry_document.addInputStreamProgressListener(progress_listener);
                    uk.ac.sanger.artemis.io.Entry new_embl_entry = EntryFileDialog.getEntryFromFile(this, entry_document, artemis_entry_information, false);
                    if (new_embl_entry == null) break;
                    try {
                        Entry new_entry = new Entry(((EntryEdit)last_entry_edit).getEntryGroup().getBases(), new_embl_entry);
                        ((EntryEdit)last_entry_edit).getEntryGroup().add(new_entry);
                    }
                    catch (OutOfRangeException e) {
                        new MessageDialog(this, "read failed: one of the features in " + new_entry_name + " has an out of range " + "location: " + e.getMessage());
                    }
                } else {
                    if (last_entry_edit != null) {
                        last_entry_edit.setVisible(true);
                        last_entry_edit = null;
                    }
                    entry_document = DocumentFactory.makeDocument(new_entry_name);
                    entry_document.addInputStreamProgressListener(this.getInputStreamProgressListener());
                    uk.ac.sanger.artemis.io.Entry new_embl_entry = EntryFileDialog.getEntryFromFile(this, entry_document, artemis_entry_information, false);
                    if (new_embl_entry == null) break;
                    try {
                        Entry entry = new Entry(new_embl_entry);
                        last_entry_edit = this.makeEntryEdit(entry);
                        this.addEntryEdit((EntryEdit)last_entry_edit);
                        this.getStatusLabel().setText("");
                    }
                    catch (OutOfRangeException e) {
                        new MessageDialog(this, "read failed: one of the features in " + new_entry_name + " has an out of range " + "location: " + e.getMessage());
                        break;
                    }
                    catch (NoSequenceException noSequenceException) {
                        new MessageDialog(this, "read failed: " + new_entry_name + " contains no sequence");
                        break;
                    }
                }
            }
            ++i;
        }
        int entry_index = 0;
        while (entry_index < this.entry_edit_objects.size()) {
            this.entry_edit_objects.elementAt(entry_index).show();
            ++entry_index;
        }
    }

    private void handleBioJava(String[] args) {
        block11: {
            if (args.length == 3) {
                String class_name = args[1];
                String location = args[2];
                Document location_document = DocumentFactory.makeDocument(location);
                try {
                    Object biojava_object = Class.forName(class_name).newInstance();
                    EntryInformation entry_information = Options.getArtemisEntryInformation();
                    if (biojava_object instanceof SequenceFormat) {
                        SequenceFormat sequence_format = (SequenceFormat)biojava_object;
                        BioJavaEntry emblEntry = new BioJavaEntry(entry_information, location_document, sequence_format);
                        Entry new_entry = new Entry(emblEntry);
                        EntryEdit new_entry_edit = this.makeEntryEdit(new_entry);
                        new_entry_edit.setVisible(true);
                        break block11;
                    }
                    new MessageDialog(this, "not a SequenceFormat: " + class_name);
                }
                catch (IllegalAccessException illegalAccessException) {
                    new MessageDialog(this, "cannot create class: " + class_name + " - IllegalAccessException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    new MessageDialog(this, "cannot find class: " + class_name);
                }
                catch (ClassCastException classCastException) {
                    new MessageDialog(this, String.valueOf(class_name) + " is not a sub-class of " + "SequenceFormat");
                }
                catch (IOException e) {
                    new MessageDialog(this, "I/O error while reading from " + location + ": " + e.getMessage());
                }
                catch (NoSequenceException noSequenceException) {
                    new MessageDialog(this, String.valueOf(location) + " contained no sequence");
                }
                catch (InstantiationException instantiationException) {
                    new MessageDialog(this, "cannot instantiate " + class_name);
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(this, "read failed: one of the features in " + location + " has an out of range location: " + e.getMessage());
                }
            } else {
                new MessageDialog(this, "the -biojava option needs two arguments");
            }
        }
    }

    private void readDefaultEntries() {
        EntryInformation artemis_entry_information = Options.getArtemisEntryInformation();
        String default_sequence_file_name = Options.getOptions().getDefaultSequenceFileName();
        String default_feature_file_name = Options.getOptions().getDefaultFeatureFileName();
        if (default_sequence_file_name != null) {
            String default_sequence_file_name_embl = String.valueOf(default_sequence_file_name) + "_embl";
            uk.ac.sanger.artemis.io.Entry new_embl_entry = null;
            Document entry_document = DocumentFactory.makeDocument(default_sequence_file_name_embl);
            InputStreamProgressListener progress_listener = this.getInputStreamProgressListener();
            entry_document.addInputStreamProgressListener(progress_listener);
            if (entry_document.readable()) {
                new_embl_entry = EntryFileDialog.getEntryFromFile(this, entry_document, artemis_entry_information, false);
            }
            if (new_embl_entry == null || new_embl_entry.getSequence() == null || new_embl_entry.getSequence().length() == 0) {
                File entry_file = new File(default_sequence_file_name);
                if (entry_file.exists()) {
                    new_embl_entry = EntryFileDialog.getEntryFromFile(this, entry_document, artemis_entry_information, false);
                } else {
                    System.err.println("file does not exist: " + default_sequence_file_name + "(given in options files)");
                    return;
                }
            }
            if (new_embl_entry == null || new_embl_entry.getSequence() == null || new_embl_entry.getSequence().length() == 0) {
                System.err.println("failed to read " + default_sequence_file_name + "(given in options files)");
                return;
            }
            this.getStatusLabel().setText("");
            try {
                Entry entry = new Entry(new_embl_entry);
                EntryEdit new_entry_edit = this.makeEntryEdit(entry);
                new_entry_edit.setVisible(true);
                if (default_feature_file_name != null) {
                    Document feature_document = DocumentFactory.makeDocument(default_feature_file_name);
                    uk.ac.sanger.artemis.io.Entry new_embl_table_entry = EntryFileDialog.getEntryFromFile(this, feature_document, artemis_entry_information, false);
                    if (new_embl_table_entry == null) {
                        return;
                    }
                    EntryGroup entry_group = new_entry_edit.getEntryGroup();
                    Entry new_table_entry = new Entry(entry.getBases(), new_embl_table_entry);
                    entry_group.add(new_table_entry);
                }
            }
            catch (OutOfRangeException e) {
                new MessageDialog(this, "read failed: one of the features in " + default_feature_file_name + " has an out of range location: " + e.getMessage());
            }
            catch (NoSequenceException noSequenceException) {
                new MessageDialog(this, "read failed: " + new_embl_entry.getName() + " contains no sequence");
            }
        }
    }

    private EntryEdit makeEntryEdit(Entry entry) {
        Bases bases = entry.getBases();
        SimpleEntryGroup entry_group = new SimpleEntryGroup(bases);
        entry_group.add(entry);
        EntryEdit entry_edit = new EntryEdit(entry_group);
        return entry_edit;
    }

    public void entryEditFinished(EntryEdit entry_edit) {
        if (entry_edit == null) {
            throw new Error("entryEditFinished() was passed a null object");
        }
        if (!this.entry_edit_objects.removeElement(entry_edit)) {
            throw new Error("entryEditFinished() - could not remove a object from an empty vector");
        }
        entry_edit.setVisible(false);
        entry_edit.dispose();
    }

    public synchronized void addEntryEdit(EntryEdit entry_edit) {
        this.entry_edit_objects.addElement(entry_edit);
    }

    private void getEntryEditFromEntrySource(final EntrySource entry_source) {
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        SwingWorker entryWorker = new SwingWorker(){
            EntryEdit entry_edit;

            public Object construct() {
                try {
                    Entry entry = entry_source.getEntry(true, progress_thread);
                    if (entry == null) {
                        return null;
                    }
                    SimpleEntryGroup entry_group = new SimpleEntryGroup(entry.getBases());
                    entry_group.add(entry);
                    this.entry_edit = new EntryEdit(entry_group);
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(ArtemisMain.this, "read failed: one of the features in  the entry has an out of range location: " + e.getMessage());
                }
                catch (NoSequenceException noSequenceException) {
                    new MessageDialog(ArtemisMain.this, "read failed: entry contains no sequence");
                }
                catch (IOException e) {
                    new MessageDialog(ArtemisMain.this, "read failed due to IO error: " + e);
                }
                return null;
            }

            public void finished() {
                if (this.entry_edit != null) {
                    this.entry_edit.setVisible(true);
                }
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
    }

    private void redisplayAll() {
        int i = 0;
        while (i < this.entry_edit_objects.size()) {
            this.entry_edit_objects.elementAt(i).redisplay();
            ++i;
        }
    }

    protected void exit() {
        System.exit(0);
    }

    public static void main(final String[] args) {
        ArtemisMain main_window = new ArtemisMain();
        main_window.setVisible(true);
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        SwingWorker entryWorker = new SwingWorker(){

            public Object construct() {
                ArtemisMain.this.readArgsAndOptions(args, progress_thread);
                return null;
            }

            public void finished() {
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
    }
}

