/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class CanvasPanel
extends JPanel {
    private Image offscreen;
    private JPanel mid_panel = null;
    private JComponent canvas = null;
    private int font_ascent;
    private int font_max_ascent;
    private int font_descent;
    private int font_width;
    private int font_base_line;

    public CanvasPanel() {
        this.setLayout(new BorderLayout());
        this.setFontInfo();
        this.createCanvas();
    }

    protected void repaintCanvas() {
        this.getCanvas().repaint();
    }

    private void createCanvas() {
        this.mid_panel = new JPanel();
        this.mid_panel.setLayout(new BorderLayout());
        this.canvas = new JComponent(){

            public void invalidate() {
                super.invalidate();
                CanvasPanel.this.offscreen = null;
            }

            public void update(Graphics g) {
                this.paint(g);
            }

            public void paint(Graphics g) {
                int canvas_width = ((CanvasPanel)CanvasPanel.this).canvas.getSize().width;
                int canvas_height = ((CanvasPanel)CanvasPanel.this).canvas.getSize().height;
                if (canvas_height <= 0 || canvas_width <= 0) {
                    return;
                }
                if (!CanvasPanel.this.canvas.isVisible()) {
                    return;
                }
                if (CanvasPanel.this.offscreen == null) {
                    CanvasPanel.this.offscreen = CanvasPanel.this.canvas.createImage(canvas_width, canvas_height);
                }
                Graphics og = CanvasPanel.this.offscreen.getGraphics();
                og.setClip(0, 0, canvas_width, canvas_height);
                CanvasPanel.this.paintCanvas(og);
                g.drawImage(CanvasPanel.this.offscreen, 0, 0, null);
                g.dispose();
            }
        };
        this.mid_panel.add((Component)this.canvas, "Center");
        this.add((Component)this.mid_panel, "Center");
    }

    protected JComponent getCanvas() {
        return this.canvas;
    }

    protected JPanel getMidPanel() {
        return this.mid_panel;
    }

    protected abstract void paintCanvas(Graphics var1);

    private void setFontInfo() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.font_width = fm.charWidth('M');
        this.font_ascent = fm.getAscent();
        this.font_max_ascent = fm.getMaxAscent();
        this.font_descent = fm.getDescent();
    }

    public int getCanvasWidth() {
        return this.getCanvas().getSize().width;
    }

    public int getCanvasHeight() {
        return this.getCanvas().getSize().height;
    }

    public int getFontWidth() {
        return this.font_width;
    }

    public int getFontAscent() {
        return this.font_ascent;
    }

    public int getFontMaxAscent() {
        return this.font_ascent;
    }

    public int getFontDescent() {
        return this.font_descent;
    }

    public int getFontHeight() {
        return this.getFontMaxAscent() + this.getFontDescent();
    }
}

