/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.EntrySourceVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.AddMenu;
import uk.ac.sanger.artemis.components.ArtemisMain;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.EditMenu;
import uk.ac.sanger.artemis.components.EntryFileDialog;
import uk.ac.sanger.artemis.components.EntryGroupDisplay;
import uk.ac.sanger.artemis.components.EntryGroupMenu;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.FeatureList;
import uk.ac.sanger.artemis.components.FileManager;
import uk.ac.sanger.artemis.components.FileNode;
import uk.ac.sanger.artemis.components.GotoMenu;
import uk.ac.sanger.artemis.components.GraphMenu;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.ReadFeaturesActionListener;
import uk.ac.sanger.artemis.components.RunMenu;
import uk.ac.sanger.artemis.components.SaveEntryActionListener;
import uk.ac.sanger.artemis.components.SaveEntryAsActionListener;
import uk.ac.sanger.artemis.components.SaveEntryAsEMBLActionListener;
import uk.ac.sanger.artemis.components.SaveEntryAsGFFActionListener;
import uk.ac.sanger.artemis.components.SaveEntryAsGenbankActionListener;
import uk.ac.sanger.artemis.components.SaveEntryAsSubmissionActionListener;
import uk.ac.sanger.artemis.components.SelectMenu;
import uk.ac.sanger.artemis.components.SelectionInfoDisplay;
import uk.ac.sanger.artemis.components.SwingWorker;
import uk.ac.sanger.artemis.components.Utilities;
import uk.ac.sanger.artemis.components.ViewMenu;
import uk.ac.sanger.artemis.components.WriteMenu;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class EntryEdit
extends JFrame
implements EntryGroupChangeListener,
EntryChangeListener,
DropTargetListener {
    static final KeyStroke SAVE_DEFAULT_KEY = KeyStroke.getKeyStroke(83, 2);
    private EntryGroup entry_group;
    private GotoEventSource goto_event_source;
    private final JMenuBar menu_bar = new JMenuBar();
    private final JMenu file_menu = new JMenu("File");
    private EntryGroupDisplay group_display;
    private FeatureDisplay one_line_per_entry_display;
    private FeatureDisplay feature_display;
    private FeatureDisplay base_display;
    private BasePlotGroup base_plot_group;
    private FeatureList feature_list;
    private Selection selection = null;
    private EntrySourceVector entry_sources;
    protected static Border dropBorder = new BevelBorder(1);

    public EntryEdit(EntryGroup entry_group) {
        super("Artemis Entry Edit");
        boolean option_value;
        Font default_font;
        String name;
        this.setDefaultCloseOperation(0);
        this.setDropTarget(new DropTarget(this, this));
        entry_group.ref();
        this.entry_group = entry_group;
        this.entry_sources = Utilities.getEntrySources(this, null);
        this.goto_event_source = new SimpleGotoEventSource(this.getEntryGroup());
        this.selection = new Selection(null);
        this.getEntryGroup().addFeatureChangeListener(this.selection);
        this.getEntryGroup().addEntryChangeListener(this.selection);
        this.getEntryGroup().addEntryGroupChangeListener(this);
        this.getEntryGroup().addEntryChangeListener(this);
        if (this.getEntryGroup().getDefaultEntry() != null && (name = this.getEntryGroup().getDefaultEntry().getName()) != null) {
            this.setTitle("Artemis Entry Edit: " + name);
        }
        if ((default_font = this.getDefaultFont()) != null) {
            FontMetrics fm = this.getFontMetrics(default_font);
            fm.getHeight();
            fm.getMaxAscent();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                EntryEdit.this.closeEntryEdit();
            }
        });
        Box box_panel = Box.createVerticalBox();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)box_panel, "North");
        this.menu_bar.setFont(default_font);
        SelectionInfoDisplay selection_info = new SelectionInfoDisplay(this.getEntryGroup(), this.getSelection());
        box_panel.add(selection_info);
        this.group_display = new EntryGroupDisplay(this);
        box_panel.add(this.group_display);
        boolean entry_buttons_option = Options.getOptions().getPropertyTruthValue("show_entry_buttons");
        this.group_display.setVisible(entry_buttons_option);
        this.base_plot_group = new BasePlotGroup(this.getEntryGroup(), this, this.getSelection(), this.getGotoEventSource());
        box_panel.add(this.base_plot_group);
        this.base_plot_group.setVisible(true);
        this.one_line_per_entry_display = new FeatureDisplay(this.getEntryGroup(), this.getSelection(), this.getGotoEventSource(), this.base_plot_group);
        this.one_line_per_entry_display.setShowLabels(false);
        this.one_line_per_entry_display.setOneLinePerEntry(true);
        box_panel.add(this.one_line_per_entry_display);
        this.one_line_per_entry_display.setVisible(false);
        this.feature_display = new FeatureDisplay(this.getEntryGroup(), this.getSelection(), this.getGotoEventSource(), this.base_plot_group);
        Options options = Options.getOptions();
        if (options.getProperty("overview_feature_labels") != null) {
            option_value = options.getPropertyTruthValue("overview_feature_labels");
            this.feature_display.setShowLabels(option_value);
        }
        if (options.getProperty("overview_one_line_per_entry") != null) {
            option_value = options.getPropertyTruthValue("overview_one_line_per_entry");
            this.feature_display.setOneLinePerEntry(option_value);
        }
        this.feature_display.addDisplayAdjustmentListener(this.base_plot_group);
        this.feature_display.addDisplayAdjustmentListener(this.one_line_per_entry_display);
        this.one_line_per_entry_display.addDisplayAdjustmentListener(this.feature_display);
        box_panel.add(this.feature_display);
        this.feature_display.setVisible(true);
        this.base_display = new FeatureDisplay(this.getEntryGroup(), this.getSelection(), this.getGotoEventSource(), this.base_plot_group);
        this.base_display.setShowLabels(false);
        this.base_display.setScaleFactor(0);
        box_panel.add(this.base_display);
        boolean show_base_view = Options.getOptions().getProperty("show_base_view") != null ? Options.getOptions().getPropertyTruthValue("show_base_view") : true;
        this.base_display.setVisible(show_base_view);
        this.feature_list = new FeatureList(this.getEntryGroup(), this.getSelection(), this.getGotoEventSource(), this.base_plot_group);
        this.feature_list.setFont(default_font);
        boolean list_option_value = Options.getOptions().getPropertyTruthValue("show_list");
        if (list_option_value) {
            this.feature_list.setVisible(true);
        } else {
            this.feature_list.setVisible(false);
        }
        this.getContentPane().add((Component)this.feature_list, "Center");
        this.makeMenus();
        this.pack();
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon icon = new ImageIcon(cl.getResource("images/icon.gif"));
        if (icon != null) {
            Toolkit.getDefaultToolkit();
            Image icon_image = icon.getImage();
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(icon_image, 0);
            try {
                tracker.waitForAll();
                this.setIconImage(icon_image);
            }
            catch (InterruptedException interruptedException) {}
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int screen_height = screen.height;
        int screen_width = screen.width;
        if (screen_width <= 900 || screen_height <= 700) {
            this.setSize(screen_width * 9 / 10, screen_height * 9 / 10);
        } else {
            this.setSize(900, 700);
        }
        Utilities.centreFrame(this);
    }

    private void closeEntryEdit() {
        YesNoDialog yes_no_dialog;
        if (this.getEntryGroup().hasUnsavedChanges() && this.getEntryGroup().refCount() == 1 && !(yes_no_dialog = new YesNoDialog(this, "there are unsaved changes - really close?")).getResult()) {
            return;
        }
        this.entryEditFinished();
    }

    public void redisplay() {
        this.feature_display.redisplay();
        this.base_display.redisplay();
    }

    public void makeSelectionVisible() {
        Marker first_base = this.getSelection().getStartBaseOfSelection();
        GotoEvent new_event = new GotoEvent(this, first_base);
        this.getGotoEventSource().sendGotoEvent(new_event);
    }

    public GotoEventSource getGotoEventSource() {
        return this.goto_event_source;
    }

    public EntryGroup getEntryGroup() {
        return this.entry_group;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: {
                this.makeFileMenu();
            }
        }
    }

    public void entryChanged(EntryChangeEvent event) {
        if (event.getType() == 3) {
            this.makeFileMenu();
        }
    }

    private void entryEditFinished() {
        this.setVisible(false);
        this.getEntryGroup().removeFeatureChangeListener(this.selection);
        this.getEntryGroup().removeEntryChangeListener(this.selection);
        this.getEntryGroup().removeEntryGroupChangeListener(this);
        this.getEntryGroup().removeEntryChangeListener(this);
        this.getEntryGroup().unref();
        this.dispose();
    }

    private void saveDefaultEntry() {
        if (this.getEntryGroup().getDefaultEntry() == null) {
            new MessageDialog(this, "There is no default entry");
        } else {
            this.saveEntry(this.entry_group.getDefaultEntry(), true, false, true, 0);
        }
    }

    void saveEntry(Entry entry, boolean include_diana_extensions, boolean ask_for_name, boolean keep_new_name, int destination_type) {
        YesNoDialog yes_no_dialog;
        if (!include_diana_extensions && this.displaySaveWarnings(entry)) {
            return;
        }
        if (destination_type != 0 && entry.getHeaderText() != null && !(yes_no_dialog = new YesNoDialog(this, "header section will be lost. continue?")).getResult()) {
            return;
        }
        if (!System.getProperty("os.arch").equals("alpha")) {
            EntryFileDialog file_dialog = new EntryFileDialog(this, false);
            file_dialog.saveEntry(entry, include_diana_extensions, ask_for_name, keep_new_name, destination_type);
        } else {
            this.alphaBug(entry, include_diana_extensions, ask_for_name, keep_new_name, destination_type);
        }
    }

    private void alphaBug(Entry entry, boolean include_diana_extensions, boolean ask_for_name, boolean keep_new_name, int destination_type) {
        block36: {
            try {
                if (ask_for_name || entry.getName() == null) {
                    File file;
                    block35: {
                        YesNoDialog yes_no_dialog;
                        int n;
                        JCheckBox emblHeader = new JCheckBox("Add EMBL ID Header", false);
                        Box bdown = Box.createVerticalBox();
                        JTextField fileField = new JTextField(String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator"));
                        fileField.selectAll();
                        bdown.add(fileField);
                        if (!(destination_type != 1 || entry.getHeaderText() != null && this.isHeaderEMBL(entry.getHeaderText()))) {
                            bdown.add(emblHeader);
                        }
                        if ((n = JOptionPane.showConfirmDialog(null, bdown, "Enter a filename", 2, 3)) == 2) {
                            return;
                        }
                        if (emblHeader.isSelected()) {
                            bdown = Box.createVerticalBox();
                            JTextField idField = new JTextField("");
                            bdown.add(idField);
                            n = JOptionPane.showConfirmDialog(null, bdown, "Enter the entry ID", 2, 3);
                            if (n != 2 && !idField.getText().trim().equals("")) {
                                String header = "ID   " + idField.getText().trim();
                                if (entry.getFeatureCount() > 0) {
                                    header = header.concat("\nFH   Key             Location/Qualifiers\nFH\n");
                                }
                                entry.setHeaderText(header);
                            }
                        }
                        if ((file = new File(fileField.getText())).exists() && !(yes_no_dialog = new YesNoDialog(this, "this file exists: " + file.getName() + " overwrite it?")).getResult()) {
                            return;
                        }
                        MessageDialog message = new MessageDialog((JFrame)this, "saving to " + file.getName() + " ...", false);
                        try {
                            try {
                                if (include_diana_extensions) {
                                    entry.save(file, destination_type, false);
                                } else {
                                    entry.saveStandardOnly(file, destination_type, true);
                                }
                            }
                            catch (EntryInformationException e) {
                                YesNoDialog yes_no_dialog2 = new YesNoDialog(this, "destination format can't handle all keys/qualifiers - continue?");
                                if (yes_no_dialog2.getResult()) {
                                    try {
                                        if (include_diana_extensions) {
                                            entry.save(file, destination_type, true);
                                        } else {
                                            entry.saveStandardOnly(file, destination_type, true);
                                        }
                                        break block35;
                                    }
                                    catch (EntryInformationException entryInformationException) {
                                        throw new Error("internal error - unexpected exception: " + e);
                                    }
                                    catch (IOException ioe) {
                                        new MessageDialog(this, "error while saving: " + ioe);
                                        if (message != null) {
                                            message.dispose();
                                        }
                                        return;
                                    }
                                }
                                if (message != null) {
                                    message.dispose();
                                }
                                return;
                            }
                        }
                        finally {
                            if (message != null) {
                                message.dispose();
                            }
                        }
                    }
                    if (keep_new_name) {
                        entry.setName(file.getName());
                    }
                    break block36;
                }
                MessageDialog message = new MessageDialog((JFrame)this, "saving to " + entry.getName() + " ...", false);
                try {
                    if (include_diana_extensions) {
                        entry.save(destination_type);
                    } else {
                        entry.saveStandardOnly(destination_type);
                    }
                }
                finally {
                    message.dispose();
                }
            }
            catch (ReadOnlyException readOnlyException) {
                new MessageDialog(this, "this entry is read only");
                return;
            }
            catch (IOException e) {
                new MessageDialog(this, "error while saving: " + e);
                return;
            }
            catch (EntryInformationException e) {
                new MessageDialog(this, "error while saving: " + e);
                return;
            }
        }
    }

    private boolean isHeaderEMBL(String header) {
        StringReader reader = new StringReader(header);
        BufferedReader buff_reader = new BufferedReader(reader);
        try {
            if (!buff_reader.readLine().startsWith("ID")) {
                return false;
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    public void saveAllEntries() {
        int entry_index = 0;
        while (entry_index < this.entry_group.size()) {
            this.saveEntry(this.entry_group.elementAt(entry_index), true, false, true, 0);
            ++entry_index;
        }
    }

    private boolean displaySaveWarnings(final Entry entry) {
        YesNoDialog yes_no_dialog;
        FeatureVector invalid_starts = entry.checkFeatureStartCodons();
        FeatureVector invalid_stops = entry.checkFeatureStopCodons();
        FeatureVector invalid_keys = entry.checkForNonEMBLKeys();
        FeatureVector duplicate_features = entry.checkForEMBLDuplicates();
        FeatureVector overlapping_cds_features = entry.checkForOverlappingCDSs();
        FeatureVector missing_qualifier_features = entry.checkForMissingQualifiers();
        FeaturePredicate predicate = new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                return feature.getEntry() == entry;
            }
        };
        String entry_name = entry.getName();
        if (entry_name == null) {
            entry_name = "no name";
        }
        FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(this.getEntryGroup(), predicate, "features from " + entry_name);
        if (invalid_starts.size() + invalid_stops.size() + invalid_keys.size() + duplicate_features.size() + overlapping_cds_features.size() > 0 && !(yes_no_dialog = new YesNoDialog(this, "warning: some features may have problems. continue with save?")).getResult()) {
            this.getSelection().clear();
            if (invalid_starts.size() > 0) {
                this.getSelection().add(invalid_starts);
                ViewMenu.showBadStartCodons(this, this.getSelection(), filtered_entry_group, this.getGotoEventSource(), this.base_plot_group);
            }
            if (invalid_stops.size() > 0) {
                this.getSelection().add(invalid_stops);
                ViewMenu.showBadStopCodons(this, this.getSelection(), filtered_entry_group, this.getGotoEventSource(), this.base_plot_group);
            }
            if (invalid_keys.size() > 0) {
                this.getSelection().add(invalid_keys);
                ViewMenu.showNonEMBLKeys(this, this.getSelection(), filtered_entry_group, this.getGotoEventSource(), this.base_plot_group);
            }
            if (duplicate_features.size() > 0) {
                this.getSelection().add(duplicate_features);
                ViewMenu.showDuplicatedFeatures(this, this.getSelection(), filtered_entry_group, this.getGotoEventSource(), this.base_plot_group);
            }
            if (overlapping_cds_features.size() > 0) {
                this.getSelection().add(overlapping_cds_features);
                ViewMenu.showOverlappingCDSs(this, this.getSelection(), filtered_entry_group, this.getGotoEventSource(), this.base_plot_group);
            }
            if (missing_qualifier_features.size() > 0) {
                this.getSelection().add(missing_qualifier_features);
                ViewMenu.showMissingQualifierFeatures(this, this.getSelection(), filtered_entry_group, this.getGotoEventSource(), this.base_plot_group);
            }
            return true;
        }
        return false;
    }

    private void makeMenus() {
        this.getDefaultFont();
        this.setJMenuBar(this.menu_bar);
        this.makeFileMenu();
        this.menu_bar.add(this.file_menu);
        if (Options.readWritePossible() || this.getEntryGroup().size() > 1) {
            EntryGroupMenu entry_group_menu = new EntryGroupMenu(this, this.getEntryGroup());
            this.menu_bar.add(entry_group_menu);
        }
        SelectMenu select_menu = new SelectMenu(this, this.getSelection(), this.getGotoEventSource(), this.getEntryGroup(), this.base_plot_group);
        this.menu_bar.add(select_menu);
        ViewMenu view_menu = new ViewMenu(this, this.getSelection(), this.getGotoEventSource(), this.getEntryGroup(), this.base_plot_group);
        this.menu_bar.add(view_menu);
        GotoMenu goto_menu = new GotoMenu(this, this.getSelection(), this.getGotoEventSource(), this.getEntryGroup());
        this.menu_bar.add(goto_menu);
        if (Options.readWritePossible()) {
            EditMenu edit_menu = new EditMenu(this, this.getSelection(), this.getGotoEventSource(), this.getEntryGroup(), this.base_plot_group);
            this.menu_bar.add(edit_menu);
            AddMenu add_menu = new AddMenu(this, this.getSelection(), this.getEntryGroup(), this.getGotoEventSource(), this.base_plot_group);
            this.menu_bar.add(add_menu);
            WriteMenu write_menu = new WriteMenu((JFrame)this, this.getSelection(), this.getEntryGroup());
            this.menu_bar.add(write_menu);
            if (Options.isUnixHost()) {
                RunMenu run_menu = new RunMenu(this, this.getSelection());
                this.menu_bar.add(run_menu);
            }
        }
        GraphMenu graph_menu = new GraphMenu(this, this.getEntryGroup(), this.base_plot_group, this.feature_display);
        this.menu_bar.add(graph_menu);
        JMenu display_menu = new JMenu("Display");
        final JCheckBoxMenuItem show_entry_buttons_item = new JCheckBoxMenuItem("Show Entry Buttons");
        show_entry_buttons_item.setState(true);
        show_entry_buttons_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                EntryEdit.this.group_display.setVisible(show_entry_buttons_item.getState());
                EntryEdit.this.validate();
            }
        });
        display_menu.add(show_entry_buttons_item);
        final JCheckBoxMenuItem show_one_line = new JCheckBoxMenuItem("Show One Line Per Entry View", false);
        show_one_line.setState(this.one_line_per_entry_display.isVisible());
        show_one_line.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                EntryEdit.this.one_line_per_entry_display.setVisible(show_one_line.getState());
                EntryEdit.this.validate();
            }
        });
        display_menu.add(show_one_line);
        final JCheckBoxMenuItem show_base_display_item = new JCheckBoxMenuItem("Show Base View");
        show_base_display_item.setState(this.base_display.isVisible());
        show_base_display_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                EntryEdit.this.base_display.setVisible(show_base_display_item.getState());
                EntryEdit.this.validate();
            }
        });
        display_menu.add(show_base_display_item);
        final JCheckBoxMenuItem show_feature_list_item = new JCheckBoxMenuItem("Show Feature List");
        show_feature_list_item.setState(this.feature_list.isVisible());
        show_feature_list_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                EntryEdit.this.feature_list.setVisible(show_feature_list_item.getState());
                EntryEdit.this.validate();
            }
        });
        display_menu.add(show_feature_list_item);
        this.menu_bar.add(display_menu);
    }

    private void makeFileMenu() {
        this.file_menu.removeAll();
        if (Options.readWritePossible()) {
            JMenuItem popFileManager = new JMenuItem("Show File Manager ...");
            popFileManager.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (ArtemisMain.filemanager == null) {
                        ArtemisMain.filemanager = new FileManager(EntryEdit.this);
                    } else {
                        ArtemisMain.filemanager.setVisible(true);
                    }
                }
            });
            this.file_menu.add(popFileManager);
            EntrySource filesystem_entry_source = null;
            int source_index = 0;
            while (source_index < this.entry_sources.size()) {
                final EntrySource this_source = this.entry_sources.elementAt(source_index);
                if (!this_source.isFullEntrySource()) {
                    if (this_source.getSourceName().equals("Filesystem")) {
                        filesystem_entry_source = this_source;
                    }
                    String entry_source_name = this_source.getSourceName();
                    String menu_item_name = null;
                    menu_item_name = entry_source_name.equals("Filesystem") ? "Read An Entry ..." : "Read An Entry From " + entry_source_name + " ...";
                    JMenuItem read_entry = new JMenuItem(menu_item_name);
                    read_entry.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            EntryEdit.this.readAnEntry(this_source);
                        }
                    });
                    this.file_menu.add(read_entry);
                }
                ++source_index;
            }
            JMenu read_features_menu = null;
            if (filesystem_entry_source != null && this.entry_group != null && this.entry_group.size() > 0) {
                read_features_menu = new JMenu("Read Entry Into");
                this.file_menu.add(read_features_menu);
            }
            this.file_menu.addSeparator();
            JMenuItem save_default = new JMenuItem("Save Default Entry");
            save_default.setAccelerator(SAVE_DEFAULT_KEY);
            save_default.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    EntryEdit.this.saveDefaultEntry();
                }
            });
            this.file_menu.add(save_default);
            if (this.entry_group != null && this.entry_group.size() != 0) {
                JMenu save_entry_menu = new JMenu("Save An Entry");
                JMenu save_as_menu = new JMenu("Save An Entry As");
                JMenu save_as = new JMenu("New File");
                JMenu save_as_embl = new JMenu("EMBL Format");
                JMenu save_as_genbank = new JMenu("GENBANK Format");
                JMenu save_as_gff = new JMenu("GFF Format");
                JMenu save_embl_only = new JMenu("EMBL Submission Format");
                int i = 0;
                while (i < this.getEntryGroup().size()) {
                    Entry this_entry = this.getEntryGroup().elementAt(i);
                    String entry_name = this_entry.getName();
                    if (entry_name == null) {
                        entry_name = "no name";
                    }
                    SaveEntryActionListener save_entry_listener = new SaveEntryActionListener(this, this_entry);
                    JMenuItem save_entry_item = new JMenuItem(entry_name);
                    save_entry_item.addActionListener(save_entry_listener);
                    SaveEntryAsActionListener save_as_listener = new SaveEntryAsActionListener(this, this_entry);
                    JMenuItem save_as_item = new JMenuItem(entry_name);
                    save_as_item.addActionListener(save_as_listener);
                    SaveEntryAsEMBLActionListener save_as_embl_listener = new SaveEntryAsEMBLActionListener(this, this_entry);
                    JMenuItem save_as_embl_item = new JMenuItem(entry_name);
                    save_as_embl_item.addActionListener(save_as_embl_listener);
                    SaveEntryAsGenbankActionListener save_as_genbank_listener = new SaveEntryAsGenbankActionListener(this, this_entry);
                    JMenuItem save_as_genbank_item = new JMenuItem(entry_name);
                    save_as_genbank_item.addActionListener(save_as_genbank_listener);
                    SaveEntryAsGFFActionListener save_as_gff_listener = new SaveEntryAsGFFActionListener(this, this_entry);
                    JMenuItem save_as_gff_item = new JMenuItem(entry_name);
                    save_as_gff_item.addActionListener(save_as_gff_listener);
                    SaveEntryAsSubmissionActionListener save_embl_only_listener = new SaveEntryAsSubmissionActionListener(this, this_entry);
                    JMenuItem save_embl_only_item = new JMenuItem(entry_name);
                    save_embl_only_item.addActionListener(save_embl_only_listener);
                    if (read_features_menu != null) {
                        ReadFeaturesActionListener read_into_listener = new ReadFeaturesActionListener(this, filesystem_entry_source, this_entry);
                        JMenuItem read_into_item = new JMenuItem(entry_name);
                        read_into_item.addActionListener(read_into_listener);
                        read_features_menu.add(read_into_item);
                    }
                    save_entry_menu.add(save_entry_item);
                    save_as.add(save_as_item);
                    save_as_embl.add(save_as_embl_item);
                    save_as_genbank.add(save_as_genbank_item);
                    save_as_gff.add(save_as_gff_item);
                    save_embl_only.add(save_embl_only_item);
                    ++i;
                }
                save_as_menu.add(save_as);
                save_as_menu.add(save_as_embl);
                save_as_menu.add(save_as_genbank);
                save_as_menu.add(save_as_gff);
                save_as_menu.addSeparator();
                save_as_menu.add(save_embl_only);
                this.file_menu.add(save_entry_menu);
                this.file_menu.add(save_as_menu);
            }
            JMenuItem save_all = new JMenuItem("Save All Entries");
            save_all.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    EntryEdit.this.saveAllEntries();
                }
            });
            this.file_menu.add(save_all);
            this.file_menu.addSeparator();
        }
        JMenuItem clone_entry_edit = new JMenuItem("Clone This Window");
        clone_entry_edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                new EntryEdit(EntryEdit.this.getEntryGroup()).show();
            }
        });
        this.file_menu.add(clone_entry_edit);
        this.file_menu.addSeparator();
        JMenuItem close = new JMenuItem("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EntryEdit.this.closeEntryEdit();
            }
        });
        this.file_menu.add(close);
    }

    private void readAnEntry(final EntrySource this_source) {
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        SwingWorker entryWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Entry new_entry = this_source.getEntry(EntryEdit.this.entry_group.getBases(), progress_thread, true);
                    if (new_entry != null) {
                        EntryEdit.this.getEntryGroup().add(new_entry);
                    }
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(EntryEdit.this, "read failed: one of the features in the entry has an out of range location: " + e.getMessage());
                }
                catch (IOException e) {
                    new MessageDialog(EntryEdit.this, "read failed due to an IO error: " + e.getMessage());
                }
                return null;
            }

            public void finished() {
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
    }

    private void readAnEntryFromFile(final File file) {
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        progress_thread.start();
        SwingWorker entryWorker = new SwingWorker(){

            public Object construct() {
                try {
                    SimpleEntryInformation new_entry_information = new SimpleEntryInformation(Options.getArtemisEntryInformation());
                    Entry new_entry = new Entry(EntryEdit.this.entry_group.getBases(), EntryFileDialog.getEntryFromFile(null, new FileDocument(file), new_entry_information, false));
                    if (new_entry != null) {
                        EntryEdit.this.getEntryGroup().add(new_entry);
                    }
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(EntryEdit.this, "read failed: one of the features in the entry has an out of range location: " + e.getMessage());
                }
                return null;
            }

            public void finished() {
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
    }

    private Font getDefaultFont() {
        return Options.getOptions().getFont();
    }

    public void drop(DropTargetDropEvent e) {
        block7: {
            Transferable t = e.getTransferable();
            try {
                try {
                    if (t.isDataFlavorSupported(FileNode.FILENODE)) {
                        FileNode fn = (FileNode)t.getTransferData(FileNode.FILENODE);
                        this.readAnEntryFromFile(fn.getFile());
                        break block7;
                    }
                    e.rejectDrop();
                }
                catch (UnsupportedFlavorException ufe) {
                    ufe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            finally {
                ((JComponent)this.getContentPane()).setBorder(null);
            }
        }
    }

    public void dragExit(DropTargetEvent e) {
        ((JComponent)this.getContentPane()).setBorder(null);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE)) {
            Point ploc = e.getLocation();
            if (this.contains(ploc.x, ploc.y)) {
                ((JComponent)this.getContentPane()).setBorder(dropBorder);
                e.acceptDrag(3);
            } else {
                e.rejectDrag();
            }
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE)) {
            e.acceptDrag(3);
        }
    }
}

