/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.DisplayAdjustmentListener;
import uk.ac.sanger.artemis.components.Plot;
import uk.ac.sanger.artemis.plot.FeatureAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;

public class FeaturePlot
extends Plot
implements DisplayAdjustmentListener,
FeatureChangeListener {
    private static final int HEIGHT;
    private float[][] value_array_array = null;
    private int step_size = 0;
    private float min_value = Float.MAX_VALUE;
    private float max_value = Float.MIN_VALUE;
    private int start_base;
    private int end_base;
    private int width_in_bases;

    static {
        Integer feature_plot_height = Options.getOptions().getIntegerProperty("feature_plot_height");
        HEIGHT = feature_plot_height == null ? 160 : feature_plot_height;
    }

    public FeaturePlot(FeatureAlgorithm algorithm) {
        super(algorithm, true);
        this.getFeature().addFeatureChangeListener(this);
        this.recalculate_flag = true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, HEIGHT);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getSize().width, HEIGHT);
    }

    void stopListening() {
        this.getFeature().removeFeatureChangeListener(this);
    }

    public void displayAdjustmentValueChanged(DisplayAdjustmentEvent event) {
        this.start_base = event.getStart();
        this.end_base = event.getEnd();
        this.width_in_bases = event.getWidthInBases();
        this.recalculate_flag = true;
        this.repaintCanvas();
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.recalculate_flag = true;
    }

    public FeatureAlgorithm getFeatureAlgorithm() {
        return (FeatureAlgorithm)super.getAlgorithm();
    }

    private int getStart() {
        return this.start_base;
    }

    private int getEnd() {
        return this.end_base;
    }

    private int getWidthInBases() {
        return this.width_in_bases;
    }

    protected void recalculateValues() {
        Float algorithm_minimum = this.getAlgorithm().getMinimum();
        Float algorithm_maximum = this.getAlgorithm().getMaximum();
        this.max_value = algorithm_maximum == null ? Float.MIN_VALUE : algorithm_maximum.floatValue();
        this.min_value = algorithm_minimum == null ? Float.MAX_VALUE : algorithm_minimum.floatValue();
        int window_size = this.getWindowSize();
        Integer default_step_size = this.getAlgorithm().getDefaultStepSize(window_size);
        this.step_size = default_step_size == null ? window_size : (default_step_size < window_size ? default_step_size : window_size);
        int unit_count = this.getEnd() - this.getStart();
        int number_of_values = (unit_count - (window_size - this.step_size)) / this.step_size;
        if (number_of_values < 2) {
            this.value_array_array = null;
            return;
        }
        int get_values_return_count = this.getFeatureAlgorithm().getValueCount();
        if (this.value_array_array == null) {
            this.value_array_array = new float[get_values_return_count][];
        }
        if (this.value_array_array[0] == null || this.value_array_array[0].length != number_of_values) {
            int i = 0;
            while (i < this.value_array_array.length) {
                this.value_array_array[i] = new float[number_of_values];
                ++i;
            }
        }
        if (!this.isVisible()) {
            return;
        }
        float[] temp_values = new float[get_values_return_count];
        int i = 0;
        while (i < number_of_values) {
            this.getFeatureAlgorithm().getValues(this.getStart() + i * this.step_size, this.getStart() + i * this.step_size + window_size - 1, temp_values);
            int value_index = 0;
            while (value_index < get_values_return_count) {
                float current_value;
                this.value_array_array[value_index][i] = current_value = temp_values[value_index];
                if (algorithm_maximum == null && current_value > this.max_value) {
                    this.max_value = current_value;
                }
                if (algorithm_minimum == null && current_value < this.min_value) {
                    this.min_value = current_value;
                }
                ++value_index;
            }
            ++i;
        }
        this.recalculate_flag = false;
    }

    protected void drawMultiValueGraph(Graphics g) {
        if (this.recalculate_flag) {
            this.recalculateValues();
        }
        if (this.value_array_array == null) {
            this.drawMinMax(g, 0.0f, 1.0f);
            return;
        }
        int window_size = this.getWindowSize();
        int get_values_return_count = this.getFeatureAlgorithm().getValueCount();
        int number_of_values = this.value_array_array[0].length;
        if (number_of_values > 1) {
            this.drawGlobalAverage(g, this.min_value, this.max_value);
        }
        int value_index = 0;
        while (value_index < get_values_return_count) {
            if (get_values_return_count == 1) {
                g.setColor(Color.black);
            } else {
                switch (value_index) {
                    case 0: {
                        g.setColor(new Color(255, 0, 0));
                        break;
                    }
                    case 1: {
                        g.setColor(new Color(100, 255, 100));
                        break;
                    }
                    case 2: {
                        g.setColor(new Color(0, 0, 255));
                        break;
                    }
                    default: {
                        g.setColor(Color.black);
                    }
                }
            }
            this.drawPoints(g, this.min_value, this.max_value, this.step_size, window_size, this.getCanvas().getSize().width, 0, this.value_array_array[value_index]);
            ++value_index;
        }
        this.drawMinMax(g, this.min_value, this.max_value);
        this.drawScaleLine(g, this.getStart(), this.getEnd());
        int cross_hair_position = this.getCrossHairPosition();
        if (cross_hair_position >= 0) {
            if (cross_hair_position >= this.getTranslation().length()) {
                this.cancelCrossHairs();
            } else {
                this.drawCrossHair(g, cross_hair_position, String.valueOf(this.getPointPosition(cross_hair_position + this.getStart() - 1)), 0);
            }
        }
    }

    protected int getPointPosition(int canvas_x_position) {
        return canvas_x_position + 1;
    }

    private Feature getFeature() {
        return this.getFeatureAlgorithm().getFeature();
    }

    private AminoAcidSequence getTranslation() {
        return this.getFeature().getTranslation();
    }
}

