/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.EntrySourceVector;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.ActMain;
import uk.ac.sanger.artemis.components.AddMenu;
import uk.ac.sanger.artemis.components.AlignmentViewer;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.ComparatorGlue;
import uk.ac.sanger.artemis.components.EditMenu;
import uk.ac.sanger.artemis.components.EntryEdit;
import uk.ac.sanger.artemis.components.EntryFileDialog;
import uk.ac.sanger.artemis.components.EntryGroupMenu;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.FileManager;
import uk.ac.sanger.artemis.components.FileNode;
import uk.ac.sanger.artemis.components.GotoMenu;
import uk.ac.sanger.artemis.components.GraphMenu;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.RunMenu;
import uk.ac.sanger.artemis.components.SelectMenu;
import uk.ac.sanger.artemis.components.Splash;
import uk.ac.sanger.artemis.components.SwingWorker;
import uk.ac.sanger.artemis.components.Utilities;
import uk.ac.sanger.artemis.components.ViewMenu;
import uk.ac.sanger.artemis.components.WriteMenu;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class MultiComparator
extends JFrame
implements DropTargetListener {
    private final JMenuBar menu_bar = new JMenuBar();
    private EntryGroup[] entry_group_array = null;
    private ComparisonData[] comparison_data_array = null;
    private Selection[] selection_array = null;
    private GotoEventSource[] goto_event_source_array = null;
    private FeatureDisplay[] feature_display_array = null;
    private AlignmentViewer[] alignment_viewer_array = null;
    private ComparatorGlue[] comparator_glue_array = null;
    private BasePlotGroup[] base_plot_group_array = null;
    private final JMenu file_menu = new JMenu("File");
    private EntrySourceVector entry_sources;
    private InputStreamProgressListener progress_listener;
    private int current_group = -1;
    protected static Border dropBorder = new BevelBorder(1);
    static /* synthetic */ Class class$0;

    public MultiComparator(EntryGroup[] entry_group_array, ComparisonData[] comparison_data_array, InputStreamProgressListener progress_listener) {
        this.setDefaultCloseOperation(0);
        if (entry_group_array.length != comparison_data_array.length + 1) {
            throw new Error("internal error - MultiComparator got illegal arguments");
        }
        this.entry_group_array = entry_group_array;
        this.comparison_data_array = comparison_data_array;
        this.progress_listener = progress_listener;
        this.entry_sources = Utilities.getEntrySources(this, null);
        this.setDropTarget(new DropTarget(this, this));
        StringBuffer title_buffer = new StringBuffer();
        title_buffer.append("ACT: ");
        int i = 0;
        while (i < entry_group_array.length - 1) {
            String sequence_name = entry_group_array[i].getDefaultEntry().getName();
            title_buffer.append(sequence_name).append(" vs ");
            ++i;
        }
        EntryGroup last_entry_group = entry_group_array[entry_group_array.length - 1];
        title_buffer.append(last_entry_group.getDefaultEntry().getName());
        this.setTitle(title_buffer.toString());
        this.makeSelectionArray();
        this.makeGotoEventSourceArray();
        this.feature_display_array = new FeatureDisplay[entry_group_array.length];
        this.base_plot_group_array = new BasePlotGroup[entry_group_array.length];
        this.alignment_viewer_array = new AlignmentViewer[comparison_data_array.length];
        this.comparator_glue_array = new ComparatorGlue[comparison_data_array.length];
        int i2 = 0;
        while (i2 < this.getEntryGroupArray().length) {
            EntryGroup this_entry_group = this.getEntryGroupArray()[i2];
            BasePlotGroup base_plot_group = new BasePlotGroup(this_entry_group, this, this.getSelectionArray()[i2], this.getGotoEventSourceArray()[i2]);
            int scroll_bar_position = i2 == this.getEntryGroupArray().length - 1 && this.getEntryGroupArray().length == 2 ? 2 : 1;
            this.feature_display_array[i2] = new FeatureDisplay(this_entry_group, this.getSelectionArray()[i2], this.getGotoEventSourceArray()[i2], base_plot_group, scroll_bar_position);
            this.feature_display_array[i2].setShowLabels(false);
            this.feature_display_array[i2].setHardLeftEdge(false);
            if (this.getEntryGroupArray().length > 2) {
                this.feature_display_array[i2].setShowForwardFrameLines(false);
                this.feature_display_array[i2].setShowReverseFrameLines(false);
            }
            this.feature_display_array[i2].addDisplayAdjustmentListener(base_plot_group);
            this.base_plot_group_array[i2] = base_plot_group;
            this_entry_group.ref();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.getComparisonDataArray().length) {
            this.alignment_viewer_array[i2] = new AlignmentViewer(this.getFeatureDisplayArray()[i2], this.getFeatureDisplayArray()[i2 + 1], this.getComparisonDataArray()[i2]);
            this.comparator_glue_array[i2] = new ComparatorGlue(this, this.getFeatureDisplayArray()[i2], this.getFeatureDisplayArray()[i2 + 1], this.getAlignmentViewerArray()[i2]);
            ++i2;
        }
        Font default_font = this.getDefaultFont();
        this.setFont(default_font);
        this.makeMenus();
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 11;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        int i3 = 0;
        while (i3 < this.getFeatureDisplayArray().length) {
            if (i3 != this.getEntryGroupArray().length - 1 || this.getEntryGroupArray().length != 2) {
                c.weighty = 0.0;
                gridbag.setConstraints(this.base_plot_group_array[i3], c);
                this.getContentPane().add(this.base_plot_group_array[i3]);
            }
            c.weighty = 0.0;
            gridbag.setConstraints(this.feature_display_array[i3], c);
            this.getContentPane().add(this.feature_display_array[i3]);
            if (i3 == this.getEntryGroupArray().length - 1 && this.getEntryGroupArray().length == 2) {
                c.weighty = 0.0;
                gridbag.setConstraints(this.base_plot_group_array[i3], c);
                this.getContentPane().add(this.base_plot_group_array[i3]);
            }
            if (i3 < this.getAlignmentViewerArray().length) {
                c.fill = 1;
                c.weighty = 1.0;
                gridbag.setConstraints(this.getAlignmentViewerArray()[i3], c);
                this.getContentPane().add(this.getAlignmentViewerArray()[i3]);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.getEntryGroupArray().length) {
            EntryGroupChangeListener change_listener = new EntryGroupChangeListener(){

                public void entryGroupChanged(EntryGroupChangeEvent event) {
                    switch (event.getType()) {
                        case 1: 
                        case 2: {
                            MultiComparator.this.makeFileMenu();
                        }
                    }
                }
            };
            this.getEntryGroupArray()[i3].addEntryGroupChangeListener(change_listener);
            EntryChangeListener entry_change_listener = new EntryChangeListener(){

                public void entryChanged(EntryChangeEvent event) {
                    switch (event.getType()) {
                        case 3: {
                            MultiComparator.this.makeFileMenu();
                        }
                    }
                }
            };
            this.getEntryGroupArray()[i3].addEntryChangeListener(entry_change_listener);
            ++i3;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                MultiComparator.this.closeComparator();
            }
        });
        URL icon_url = Splash.class.getResource("/icon.gif");
        if (icon_url != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image icon_image = toolkit.getImage(icon_url);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(icon_image, 0);
            try {
                tracker.waitForAll();
                this.setIconImage(icon_image);
            }
            catch (InterruptedException interruptedException) {}
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.packme();
        int screen_height = screen.height;
        int screen_width = screen.width;
        if (this.getAlignmentViewerArray().length > 0) {
            if (screen_width <= 900 || screen_height <= 700) {
                this.setSize(screen_width * 9 / 10, screen_height * 9 / 10);
            } else {
                this.setSize(900, 700);
            }
        }
        this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
    }

    private void rotateSequences() {
        EntryGroup[] new_entry_groups = new EntryGroup[this.getEntryGroupArray().length];
        ComparisonData[] new_comparison_data = new ComparisonData[this.getComparisonDataArray().length];
        int i = 1;
        while (i < new_entry_groups.length) {
            new_entry_groups[i - 1] = this.getEntryGroupArray()[i];
            ++i;
        }
        new_entry_groups[new_entry_groups.length - 1] = new_entry_groups[0];
        i = 1;
        while (i < new_comparison_data.length) {
            new_comparison_data[i - 1] = this.getComparisonDataArray()[i];
            ++i;
        }
        new_comparison_data[new_comparison_data.length - 1] = this.getComparisonDataArray()[0];
        MultiComparator new_comparator = new MultiComparator(new_entry_groups, new_comparison_data, this.progress_listener);
        this.setVisible(false);
        new_comparator.setVisible(true);
        this.closeComparator();
    }

    private void closeComparator() {
        EntryGroup entry_group;
        int i = 0;
        while (i < this.getEntryGroupArray().length) {
            YesNoDialog yes_no_dialog;
            entry_group = this.getEntryGroupArray()[i];
            if (entry_group.hasUnsavedChanges() && entry_group.refCount() == 1 && !(yes_no_dialog = new YesNoDialog(this, "there are unsaved changes - really close?")).getResult()) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.getEntryGroupArray().length) {
            entry_group = this.getEntryGroupArray()[i];
            entry_group.unref();
            ++i;
        }
        this.dispose();
    }

    public void packme() {
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x_position = (screen.width - this.getSize().width) / 2;
        int y_position = (screen.height - this.getSize().height) / 2;
        if (y_position < 10) {
            y_position = 10;
        }
        this.setLocation(new Point(x_position, y_position));
    }

    private void makeSelectionArray() {
        this.selection_array = new Selection[this.getEntryGroupArray().length];
        int i = 0;
        while (i < this.selection_array.length) {
            this.selection_array[i] = new Selection(null);
            ++i;
        }
    }

    private void makeGotoEventSourceArray() {
        this.goto_event_source_array = new GotoEventSource[this.getEntryGroupArray().length];
        int i = 0;
        while (i < this.goto_event_source_array.length) {
            this.goto_event_source_array[i] = new SimpleGotoEventSource(this.getEntryGroupArray()[i]){

                public void sendGotoEvent(GotoEvent goto_event) {
                    super.sendGotoEvent(goto_event);
                }
            };
            ++i;
        }
    }

    private void saveEntry(Entry entry) {
        if (entry.getName() == null) {
            EntryFileDialog file_dialog = new EntryFileDialog(this, true);
            file_dialog.saveEntry(entry, true, true, true, 0);
        } else {
            try {
                entry.save(0);
            }
            catch (IOException e) {
                new MessageDialog(this, "error while saving: " + e);
                return;
            }
            catch (EntryInformationException e) {
                new MessageDialog(this, "error while saving: " + e);
                return;
            }
        }
    }

    private String makeNewSubMenuName(EntryGroup entry_group) {
        Entry sequence_entry = entry_group.getSequenceEntry();
        if (sequence_entry == null) {
            return "(no name)";
        }
        String sequence_name = sequence_entry.getName();
        if (sequence_name == null) {
            return "(no name)";
        }
        return sequence_name;
    }

    private void makeMenus() {
        this.getDefaultFont();
        this.setJMenuBar(this.menu_bar);
        this.makeFileMenu();
        this.menu_bar.add(this.file_menu);
        JMenu entries_menu = new JMenu("Entries");
        this.menu_bar.add(entries_menu);
        JMenu select_menu = new JMenu("Select");
        this.menu_bar.add(select_menu);
        JMenu view_menu = new JMenu("View");
        this.menu_bar.add(view_menu);
        JMenu goto_menu = new JMenu("Goto");
        this.menu_bar.add(goto_menu);
        JMenu edit_menu = new JMenu("Edit");
        this.menu_bar.add(edit_menu);
        JMenu create_menu = new JMenu("Create");
        this.menu_bar.add(create_menu);
        JMenu write_menu = new JMenu("Write");
        this.menu_bar.add(write_menu);
        JMenu run_menu = null;
        if (Options.isUnixHost()) {
            run_menu = new JMenu("Run");
            this.menu_bar.add(run_menu);
        }
        JMenu graph_menu = new JMenu("Graph");
        this.menu_bar.add(graph_menu);
        int i = 0;
        while (i < this.getEntryGroupArray().length) {
            EntryGroup entry_group = this.getEntryGroupArray()[i];
            String sub_menu_name = this.makeNewSubMenuName(entry_group);
            EntryGroupMenu this_entries_menu = new EntryGroupMenu(this, this.getEntryGroupArray()[i], sub_menu_name);
            entries_menu.add(this_entries_menu);
            SelectMenu this_select_menu = new SelectMenu(this, this.getSelectionArray()[i], this.getGotoEventSourceArray()[i], this.getEntryGroupArray()[i], this.getBasePlotGroupArray()[i], sub_menu_name);
            select_menu.add(this_select_menu);
            ViewMenu this_view_menu = new ViewMenu(this, this.getSelectionArray()[i], this.getGotoEventSourceArray()[i], this.getEntryGroupArray()[i], this.getBasePlotGroupArray()[i], sub_menu_name);
            view_menu.add(this_view_menu);
            GotoMenu this_goto_menu = new GotoMenu(this, this.getSelectionArray()[i], this.getGotoEventSourceArray()[i], this.getEntryGroupArray()[i], sub_menu_name);
            goto_menu.add(this_goto_menu);
            AddMenu this_create_menu = null;
            if (Options.readWritePossible()) {
                EditMenu this_edit_menu = new EditMenu(this, this.getSelectionArray()[i], this.getGotoEventSourceArray()[i], this.getEntryGroupArray()[i], this.getBasePlotGroupArray()[i], sub_menu_name);
                edit_menu.add(this_edit_menu);
                this_create_menu = new AddMenu(this, this.getSelectionArray()[i], this.getEntryGroupArray()[i], this.getGotoEventSourceArray()[i], this.getBasePlotGroupArray()[i], sub_menu_name);
                create_menu.add(this_create_menu);
                WriteMenu this_write_menu = new WriteMenu(this, this.getSelectionArray()[i], this.getEntryGroupArray()[i], sub_menu_name);
                write_menu.add(this_write_menu);
                if (Options.isUnixHost()) {
                    RunMenu this_run_menu = new RunMenu((JFrame)this, this.getSelectionArray()[i], sub_menu_name);
                    run_menu.add(this_run_menu);
                }
            }
            GraphMenu this_graph_menu = new GraphMenu(this, this.getEntryGroupArray()[i], this.getBasePlotGroupArray()[i], this.getFeatureDisplayArray()[i], sub_menu_name);
            graph_menu.add(this_graph_menu);
            ++i;
        }
        JMenu display_menu = new JMenu("Display");
        JMenuItem hide_on_frame_lines_item = new JMenuItem("Hide Frame Lines");
        hide_on_frame_lines_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int i = 0;
                while (i < MultiComparator.this.getFeatureDisplayArray().length) {
                    MultiComparator.this.getFeatureDisplayArray()[i].setShowForwardFrameLines(false);
                    MultiComparator.this.getFeatureDisplayArray()[i].setShowReverseFrameLines(false);
                    ++i;
                }
            }
        });
        display_menu.add(hide_on_frame_lines_item);
        JMenuItem show_on_frame_lines_item = new JMenuItem("Show Frame Lines");
        show_on_frame_lines_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int i = 0;
                while (i < MultiComparator.this.getFeatureDisplayArray().length) {
                    MultiComparator.this.getFeatureDisplayArray()[i].setShowForwardFrameLines(true);
                    MultiComparator.this.getFeatureDisplayArray()[i].setShowReverseFrameLines(true);
                    ++i;
                }
            }
        });
        display_menu.add(show_on_frame_lines_item);
        this.menu_bar.add(display_menu);
    }

    private void makeFileMenu() {
        this.file_menu.removeAll();
        EntryGroup[] entry_group_array = this.getEntryGroupArray();
        JMenuItem popFileManager = new JMenuItem("Show File Manager ...");
        popFileManager.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ActMain.filemanager == null) {
                    ActMain.filemanager = new FileManager(MultiComparator.this, null);
                } else {
                    ActMain.filemanager.setVisible(true);
                }
            }
        });
        this.file_menu.add(popFileManager);
        if (entry_group_array[0] == entry_group_array[entry_group_array.length - 1]) {
            JMenuItem rotate_button = new JMenuItem("Rotate Sequences");
            rotate_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MultiComparator.this.rotateSequences();
                }
            });
            this.file_menu.add(rotate_button);
            this.file_menu.addSeparator();
        }
        int i = 0;
        while (i < this.getEntryGroupArray().length) {
            final EntryGroup entry_group = this.getEntryGroupArray()[i];
            String new_menu_name = this.makeNewSubMenuName(entry_group);
            JMenu entry_group_menu = new JMenu(new_menu_name);
            this.file_menu.add(entry_group_menu);
            int source_index = 0;
            while (source_index < this.entry_sources.size()) {
                final EntrySource this_source = this.entry_sources.elementAt(source_index);
                if (!this_source.isFullEntrySource()) {
                    String entry_source_name = this_source.getSourceName();
                    String menu_item_name = null;
                    menu_item_name = entry_source_name.equals("Filesystem") ? "Read An Entry ..." : "Read An Entry From " + entry_source_name + " ...";
                    JMenuItem read_entry = new JMenuItem(menu_item_name);
                    read_entry.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            MultiComparator.this.readAnEntry(this_source, entry_group);
                        }
                    });
                    entry_group_menu.add(read_entry);
                }
                ++source_index;
            }
            entry_group_menu.addSeparator();
            if (entry_group != null && entry_group.size() != 0) {
                JMenu save_entry_menu = new JMenu("Save Entry");
                int entry_index = 0;
                while (entry_index < entry_group.size()) {
                    final Entry this_entry = entry_group.elementAt(entry_index);
                    String entry_name = this_entry.getName();
                    if (entry_name == null) {
                        entry_name = "no name";
                    }
                    ActionListener save_entry_listener = new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            MultiComparator.this.saveEntry(this_entry);
                        }
                    };
                    JMenuItem save_entry_item = new JMenuItem(entry_name);
                    save_entry_item.addActionListener(save_entry_listener);
                    save_entry_menu.add(save_entry_item);
                    ++entry_index;
                }
                entry_group_menu.add(save_entry_menu);
                JMenuItem save_all_menu = new JMenuItem("Save All");
                save_all_menu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        int entry_index = 0;
                        while (entry_index < entry_group.size()) {
                            Entry this_entry = entry_group.elementAt(entry_index);
                            MultiComparator.this.saveEntry(this_entry);
                            ++entry_index;
                        }
                    }
                });
                entry_group_menu.add(save_all_menu);
                entry_group_menu.addSeparator();
            }
            JMenuItem edit_subject = new JMenuItem("Edit In Artemis");
            edit_subject.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    EntryEdit entry_edit = new EntryEdit(entry_group);
                    entry_edit.setVisible(true);
                }
            });
            entry_group_menu.add(edit_subject);
            ++i;
        }
        this.file_menu.addSeparator();
        JMenuItem close_button = new JMenuItem("Close");
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MultiComparator.this.closeComparator();
            }
        });
        this.file_menu.add(close_button);
    }

    private void readAnEntry(final EntrySource this_source, final EntryGroup entry_group) {
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        SwingWorker entryWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Entry new_entry = this_source.getEntry(entry_group.getBases(), progress_thread, true);
                    if (new_entry != null) {
                        entry_group.add(new_entry);
                    }
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(MultiComparator.this, "read failed: one of the features in the entry has an out of range location: " + e.getMessage());
                }
                catch (IOException e) {
                    new MessageDialog(MultiComparator.this, "read failed due to an IO error: " + e.getMessage());
                }
                return null;
            }

            public void finished() {
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
    }

    private void readAnEntryFromFile(final File file, final EntryGroup entry_group) {
        final ProgressThread progress_thread = new ProgressThread(null, "Loading Entry...");
        progress_thread.start();
        SwingWorker entryWorker = new SwingWorker(){

            public Object construct() {
                try {
                    SimpleEntryInformation new_entry_information = new SimpleEntryInformation(Options.getArtemisEntryInformation());
                    Entry new_entry = new Entry(entry_group.getBases(), EntryFileDialog.getEntryFromFile(null, new FileDocument(file), new_entry_information, false));
                    if (new_entry != null) {
                        entry_group.add(new_entry);
                    }
                }
                catch (OutOfRangeException e) {
                    new MessageDialog(MultiComparator.this, "read failed: one of the features in the entry has an out of range location: " + e.getMessage());
                }
                return null;
            }

            public void finished() {
                if (progress_thread != null) {
                    progress_thread.finished();
                }
            }
        };
        entryWorker.start();
    }

    private Font getDefaultFont() {
        return Options.getOptions().getFont();
    }

    private EntryGroup[] getEntryGroupArray() {
        return this.entry_group_array;
    }

    private ComparisonData[] getComparisonDataArray() {
        return this.comparison_data_array;
    }

    private AlignmentViewer[] getAlignmentViewerArray() {
        return this.alignment_viewer_array;
    }

    private FeatureDisplay[] getFeatureDisplayArray() {
        return this.feature_display_array;
    }

    private Selection[] getSelectionArray() {
        return this.selection_array;
    }

    private GotoEventSource[] getGotoEventSourceArray() {
        return this.goto_event_source_array;
    }

    private BasePlotGroup[] getBasePlotGroupArray() {
        return this.base_plot_group_array;
    }

    public void drop(DropTargetDropEvent e) {
        block7: {
            Transferable t = e.getTransferable();
            try {
                try {
                    if (t.isDataFlavorSupported(FileNode.FILENODE)) {
                        FileNode fn = (FileNode)t.getTransferData(FileNode.FILENODE);
                        this.readAnEntryFromFile(fn.getFile(), this.entry_group_array[this.current_group]);
                        break block7;
                    }
                    e.rejectDrop();
                }
                catch (UnsupportedFlavorException ufe) {
                    ufe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            finally {
                this.feature_display_array[this.current_group].setBorder(null);
            }
        }
    }

    public void dragExit(DropTargetEvent e) {
        int i = 0;
        while (i < this.feature_display_array.length) {
            this.feature_display_array[i].setBorder(null);
            ++i;
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE)) {
            Point ploc = e.getLocation();
            int i = 0;
            while (i < this.feature_display_array.length) {
                int top = this.feature_display_array[i].getY();
                int btm = top + this.feature_display_array[i].getHeight();
                if (ploc.y > top && ploc.y < btm) {
                    this.feature_display_array[i].setBorder(dropBorder);
                    e.acceptDrag(3);
                    this.current_group = i;
                    return;
                }
                ++i;
            }
            e.rejectDrag();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE)) {
            e.acceptDrag(3);
        }
    }
}

