/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.components.ScoreChangeEvent;
import uk.ac.sanger.artemis.components.ScoreChangeListener;
import uk.ac.sanger.artemis.components.ScoreScrollbar;

public class ScoreChanger
extends JFrame {
    final ScoreChangeListener minimum_listener;
    final ScoreScrollbar minimum_score_scrollbar;
    final ScoreChangeListener maximum_listener;
    final ScoreScrollbar maximum_score_scrollbar;
    final int minimum_value;
    final int maximum_value;
    final JLabel minimum_label;
    final JLabel maximum_label;

    public ScoreChanger(String name, ScoreChangeListener minimum_listener, ScoreChangeListener maximum_listener, int minimum_value, int maximum_value) throws IllegalArgumentException {
        super(name);
        this.minimum_listener = minimum_listener;
        this.maximum_listener = maximum_listener;
        this.minimum_value = minimum_value;
        this.maximum_value = maximum_value;
        this.getContentPane().setLayout(new GridLayout(5, 1));
        this.minimum_label = new JLabel();
        this.getContentPane().add(this.minimum_label);
        this.minimum_score_scrollbar = new ScoreScrollbar(minimum_value, maximum_value);
        ScoreChangeListener this_minimum_listener = new ScoreChangeListener(){

            public void scoreChanged(ScoreChangeEvent event) {
                ScoreChanger.this.minimum_label.setText("Minimum Cutoff: " + event.getValue());
            }
        };
        this.minimum_score_scrollbar.addScoreChangeListener(this_minimum_listener);
        this.getContentPane().add(this.minimum_score_scrollbar);
        this.maximum_label = new JLabel();
        this.getContentPane().add(this.maximum_label);
        this.maximum_score_scrollbar = new ScoreScrollbar(minimum_value, maximum_value);
        ScoreChangeListener this_maximum_listener = new ScoreChangeListener(){

            public void scoreChanged(ScoreChangeEvent event) {
                ScoreChanger.this.maximum_label.setText("Maximum Cutoff: " + event.getValue());
            }
        };
        this.maximum_score_scrollbar.addScoreChangeListener(this_maximum_listener);
        this.getContentPane().add(this.maximum_score_scrollbar);
        FlowLayout flow_layout = new FlowLayout(1, 18, 0);
        JPanel button_panel = new JPanel(flow_layout);
        JButton reset_button = new JButton("Reset");
        reset_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScoreChanger.this.reset();
            }
        });
        button_panel.add(reset_button);
        JButton close_button = new JButton("Close");
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScoreChanger.this.dispose();
            }
        });
        button_panel.add(close_button);
        this.getContentPane().add(button_panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                ScoreChanger.this.dispose();
            }
        });
        this.pack();
        this.setSize(270, this.getSize().height);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        this.reset();
        this.minimum_score_scrollbar.addScoreChangeListener(minimum_listener);
        this.maximum_score_scrollbar.addScoreChangeListener(maximum_listener);
    }

    public void dispose() {
        this.reset();
        this.minimum_score_scrollbar.removeScoreChangeListener(this.minimum_listener);
        this.maximum_score_scrollbar.removeScoreChangeListener(this.maximum_listener);
        super.dispose();
    }

    private void reset() {
        this.minimum_score_scrollbar.setValue(this.minimum_value);
        this.maximum_score_scrollbar.setValue(this.maximum_value);
        this.minimum_label.setText("Minimum Cutoff: " + this.minimum_value);
        this.maximum_label.setText("Maximum Cutoff: " + this.maximum_value);
        ScoreChangeEvent minimum_event = new ScoreChangeEvent(this, this.minimum_value);
        this.minimum_listener.scoreChanged(minimum_event);
        ScoreChangeEvent maximum_event = new ScoreChangeEvent(this, this.maximum_value);
        this.maximum_listener.scoreChanged(maximum_event);
    }
}

