/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import uk.ac.sanger.artemis.editor.CommonMenu;
import uk.ac.sanger.artemis.editor.DataViewInternalFrame;
import uk.ac.sanger.artemis.editor.MultiLineToolTipUI;

public class BigPane
extends JFrame {
    protected static Font font = new Font("Monospaced", 0, 11);
    protected static Font font_sm = new Font("Monospaced", 0, 10);
    protected static JCheckBoxMenuItem srsBrowser;
    protected static JCheckBoxMenuItem srsTabPane;
    protected static JCheckBoxMenuItem srsWin;
    protected static JInternalFrame srsFrame;
    private JTextArea qualifier;

    public BigPane(Object[] dataFile, JTextArea qualifier) {
        this(dataFile, qualifier.getText());
        this.qualifier = qualifier;
    }

    public BigPane(Object[] dataFile, String qualifier_txt) {
        super("Object Editor");
        MultiLineToolTipUI.initialize();
        this.setFont(font);
        JDesktopPane desktop = new JDesktopPane();
        desktop.setDragMode(0);
        this.getContentPane().add(desktop);
        int inset = 80;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.addWindowListener(new winExit());
        int hgt = this.getHeight() - 60;
        int wid = this.getWidth() - 100;
        DataViewInternalFrame dataView = new DataViewInternalFrame(dataFile, desktop, wid, qualifier_txt);
        dataView.setLocation(50, 0);
        dataView.setSize(wid, hgt);
        dataView.setVisible(true);
        desktop.add(dataView);
        JMenuBar menuBar = this.createMenuBar(desktop, dataView);
        this.setJMenuBar(menuBar);
        this.setVisible(true);
    }

    private JMenuBar createMenuBar(final JDesktopPane desktop, final DataViewInternalFrame dataView) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem reReadMenu = new JMenuItem("Re-read selected results");
        reReadMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dataView.reReadSelectedResults();
            }
        });
        fileMenu.add(reReadMenu);
        fileMenu.add(new JSeparator());
        JMenuItem exitMenu = new JMenuItem("Close");
        exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BigPane.this.qualifier == null) {
                    System.exit(0);
                }
                BigPane.this.qualifier.setText(dataView.getFeatureText());
                srsFrame = null;
                BigPane.this.dispose();
            }
        });
        fileMenu.add(exitMenu);
        JMenu optionMenu = new JMenu("Options");
        menuBar.add(optionMenu);
        JMenu srsMenu = new JMenu("Show SRS in");
        optionMenu.add(srsMenu);
        srsBrowser = new JCheckBoxMenuItem("Browser", false);
        srsTabPane = new JCheckBoxMenuItem("Tab Pane", true);
        srsWin = new JCheckBoxMenuItem("New Window", false);
        srsMenu.add(srsBrowser);
        srsMenu.add(srsTabPane);
        srsMenu.add(srsWin);
        JMenu dragMenu = new JMenu("Drag Mode");
        optionMenu.add(dragMenu);
        JRadioButtonMenuItem liveDrag = new JRadioButtonMenuItem("Live", true);
        liveDrag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                desktop.setDragMode(0);
            }
        });
        dragMenu.add(liveDrag);
        JRadioButtonMenuItem outlineDrag = new JRadioButtonMenuItem("Outline", false);
        outlineDrag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                desktop.setDragMode(1);
            }
        });
        dragMenu.add(outlineDrag);
        ButtonGroup buttGroup = new ButtonGroup();
        buttGroup.add(liveDrag);
        buttGroup.add(outlineDrag);
        return menuBar;
    }

    protected static void setUpSRSFrame(int hgt, JDesktopPane desktop) {
        srsFrame = new JInternalFrame("SRS", true, true, true, true);
        srsFrame.setDefaultCloseOperation(1);
        srsFrame.setLocation(0, 0);
        srsFrame.setSize(500, hgt);
        final JTabbedPane jtab = new JTabbedPane();
        srsFrame.getContentPane().add(jtab);
        JMenuBar menuBar = new JMenuBar();
        CommonMenu cmen = new CommonMenu(srsFrame);
        menuBar.add(cmen);
        JMenuItem closeTabMenu = new JMenuItem("Close tab");
        cmen.add(closeTabMenu);
        closeTabMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int select = jtab.getSelectedIndex();
                if (select > -1) {
                    jtab.removeTabAt(select);
                }
            }
        });
        srsFrame.setJMenuBar(menuBar);
        desktop.add(srsFrame);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:: java BigPane data_file");
            System.exit(0);
        }
        new BigPane((Object[])args, "");
    }

    class winExit
    extends WindowAdapter {
        winExit() {
        }

        public void windowClosing(WindowEvent we) {
            System.exit(0);
        }
    }
}

