/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import uk.ac.sanger.artemis.io.ComparableFeature;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.DocumentFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.SimpleDocumentFeature;
import uk.ac.sanger.artemis.io.StreamFeature;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class BlastStreamFeature
extends SimpleDocumentFeature
implements DocumentFeature,
StreamFeature,
ComparableFeature {
    private DocumentEntry entry;
    private String blast_line = null;

    public BlastStreamFeature(Key key, Location location, QualifierVector qualifiers) {
        super(null);
        try {
            this.setKey(key);
            this.setLocation(location);
            this.setQualifiers(qualifiers);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public BlastStreamFeature(Feature feature) {
        super(null);
        if (feature instanceof BlastStreamFeature) {
            this.blast_line = ((BlastStreamFeature)feature).blast_line;
        }
        try {
            this.setKey(feature.getKey());
            this.setLocation(feature.getLocation());
            this.setQualifiers(feature.getQualifiers());
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public Feature copy() {
        BlastStreamFeature return_value = new BlastStreamFeature(this);
        return return_value;
    }

    private BlastStreamFeature(String line) throws ReadFormatException {
        super(null);
        StringVector line_bits = StringVector.getStrings(line, "\t");
        if (line_bits.size() < 12) {
            throw new ReadFormatException("invalid Blast line (not enough fields): " + line);
        }
        try {
            int query_start = Integer.valueOf(line_bits.elementAt(6));
            int query_end = Integer.valueOf(line_bits.elementAt(7));
            String percent_id = line_bits.elementAt(2);
            String query_id = line_bits.elementAt(0);
            String subject_id = line_bits.elementAt(1);
            String subject_start_string = line_bits.elementAt(8);
            String subject_end_string = line_bits.elementAt(9);
            String score = line_bits.elementAt(11);
            String e_value = line_bits.elementAt(10);
            Qualifier blast_score_qualifier = new Qualifier("blast_score", score);
            Qualifier score_qualifier = new Qualifier("score", percent_id);
            Qualifier percent_id_qualifier = new Qualifier("percent_id", percent_id);
            Qualifier query_id_qualifier = new Qualifier("query_id", query_id);
            Qualifier subject_start_qualifier = new Qualifier("subject_start", subject_start_string);
            Qualifier subject_end_qualifier = new Qualifier("subject_end", subject_end_string);
            Qualifier subject_id_qualifier = new Qualifier("subject_id", subject_id);
            this.setQualifier(blast_score_qualifier);
            this.setQualifier(score_qualifier);
            this.setQualifier(percent_id_qualifier);
            this.setQualifier(query_id_qualifier);
            this.setQualifier(subject_start_qualifier);
            this.setQualifier(subject_end_qualifier);
            this.setQualifier(subject_id_qualifier);
            int subject_start = Integer.valueOf(subject_start_string);
            int subject_end = Integer.valueOf(subject_end_string);
            Key key = new Key("BLASTCDS");
            this.setKey(key);
            StringVector note_values = new StringVector();
            note_values.add("hit to " + subject_id + " " + subject_start + ".." + subject_end + "  score: " + score + "  percent id: " + percent_id + "  e-value: " + e_value);
            Qualifier note_qualifier = new Qualifier("note", note_values);
            this.setQualifier(note_qualifier);
            boolean complement_flag = subject_end < subject_start;
            if (query_start > query_end) {
                int tmp = query_end;
                query_end = query_start;
                query_start = tmp;
                complement_flag = !complement_flag;
            }
            RangeVector ranges = new RangeVector(new Range(query_start, query_end));
            this.setLocation(new Location(ranges, complement_flag));
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        this.blast_line = line;
    }

    protected static BlastStreamFeature readFromStream(LinePushBackReader stream) throws IOException, InvalidRelationException {
        String line = stream.readLine();
        if (line == null) {
            return null;
        }
        try {
            BlastStreamFeature new_feature = new BlastStreamFeature(line);
            return new_feature;
        }
        catch (ReadFormatException exception) {
            String new_error_string = exception.getMessage();
            throw new ReadFormatException(new_error_string, stream.getLineNumber());
        }
    }

    public void setFromStream(EntryInformation entry_information, LinePushBackReader in_stream) throws IOException, InvalidRelationException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void writeToStream(Writer writer) throws IOException {
        writer.write(String.valueOf(this.blast_line) + "\n");
    }
}

