/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.GFFDocumentEntry;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public abstract class DocumentEntryFactory {
    public static final int UNKNOWN_FORMAT = 0;
    public static final int ANY_FORMAT = 0;
    public static final int EMBL_FORMAT = 1;
    public static final int GENBANK_FORMAT = 2;
    public static final int GFF_FORMAT = 3;
    public static final int BSML_FORMAT = 4;
    public static final int GAME_FORMAT = 5;
    public static final int AVAGE_FORMAT = 5;

    public static DocumentEntry makeDocumentEntry(Document document, ReadListener listener) throws IOException {
        try {
            EntryInformation entry_information = SimpleEntryInformation.getDefaultEntryInformation();
            return DocumentEntryFactory.makeDocumentEntry(entry_information, document, listener);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public static DocumentEntry makeDocumentEntry(EntryInformation entry_information, Document document, ReadListener listener) throws IOException, EntryInformationException {
        LinePushBackReader document_reader = document.getLinePushBackReader();
        String first_line = document_reader.readLine();
        if (first_line == null) {
            return new EmblDocumentEntry(entry_information, document, listener);
        }
        int first_line_type = LineGroup.getLineType(first_line);
        document_reader.pushBack(first_line);
        switch (first_line_type) {
            case 8: 
            case 9: {
                GFFDocumentEntry document_entry = new GFFDocumentEntry(document, listener);
                return document_entry;
            }
            case 10: {
                MSPcrunchDocumentEntry document_entry = new MSPcrunchDocumentEntry(document, listener);
                return document_entry;
            }
            case 11: {
                BlastDocumentEntry document_entry = new BlastDocumentEntry(document, listener);
                return document_entry;
            }
            case 5: 
            case 7: {
                GenbankDocumentEntry document_entry = new GenbankDocumentEntry(entry_information, document, listener);
                return document_entry;
            }
        }
        EmblDocumentEntry document_entry = new EmblDocumentEntry(entry_information, document, listener);
        return document_entry;
    }

    public static DocumentEntry makeDocumentEntry(Entry entry, int destination_type) throws EntryInformationException {
        SimpleEntryInformation entry_information = new SimpleEntryInformation(entry.getEntryInformation());
        return DocumentEntryFactory.makeDocumentEntry(entry_information, entry, destination_type, false);
    }

    public static DocumentEntry makeDocumentEntry(EntryInformation entry_information, Entry entry, int destination_type, boolean force) throws EntryInformationException {
        if (destination_type == 0) {
            destination_type = entry instanceof EmblDocumentEntry ? 1 : (entry instanceof GenbankDocumentEntry ? 2 : (entry instanceof GFFDocumentEntry ? 3 : 1));
        }
        switch (destination_type) {
            case 1: {
                return new EmblDocumentEntry(entry_information, entry, force);
            }
            case 2: {
                return new GenbankDocumentEntry(entry_information, entry, force);
            }
            case 3: {
                return new GFFDocumentEntry(entry, force);
            }
        }
        throw new Error("internal error - unknown DocumentEntry type");
    }
}

