/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.plot.Algorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

public abstract class BaseAlgorithm
extends Algorithm {
    private Bases bases;
    private boolean rev_comp_display = false;
    private boolean forward_flag;

    public BaseAlgorithm(Strand strand, String algorithm_name, String algorithm_short_name) {
        super(algorithm_name, algorithm_short_name);
        this.bases = strand.getBases();
        this.forward_flag = strand.isForwardStrand();
    }

    public Bases getBases() {
        return this.bases;
    }

    public Strand getStrand() {
        if (this.forward_flag ^ this.rev_comp_display) {
            return this.getBases().getForwardStrand();
        }
        return this.getBases().getReverseStrand();
    }

    public void setRevCompDisplay(boolean rev_comp_display) {
        this.rev_comp_display = rev_comp_display;
    }

    public boolean isRevCompDisplay() {
        return this.rev_comp_display;
    }

    public abstract void getValues(int var1, int var2, float[] var3);

    public abstract int getValueCount();
}

