/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.sequence;

import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class MarkerRange {
    private Marker start = null;
    private Marker end = null;

    public MarkerRange(Strand strand, int start, int end) throws OutOfRangeException {
        if (start <= end) {
            this.start = strand.makeMarker(start);
            this.end = strand.makeMarker(end);
        } else {
            this.start = strand.makeMarker(end);
            this.end = strand.makeMarker(start);
        }
    }

    public MarkerRange(Marker marker) {
        this.start = marker;
        this.end = marker;
    }

    public Strand getStrand() {
        return this.getStart().getStrand();
    }

    public boolean isForwardMarker() {
        return this.getStrand().isForwardStrand();
    }

    public Marker getStart() {
        return this.start;
    }

    public Marker getEnd() {
        return this.end;
    }

    public int getCount() {
        return this.getRawEnd().getRawPosition() - this.getRawStart().getRawPosition() + 1;
    }

    public Marker getRawStart() {
        if (this.getStart().getRawPosition() <= this.getEnd().getRawPosition()) {
            return this.getStart();
        }
        return this.getEnd();
    }

    public Marker getRawEnd() {
        if (this.getEnd().getRawPosition() <= this.getStart().getRawPosition()) {
            return this.getStart();
        }
        return this.getEnd();
    }

    public Range getRawRange() {
        try {
            if (this.getStrand().isForwardStrand()) {
                return new Range(this.getStart().getRawPosition(), this.getEnd().getRawPosition());
            }
            return new Range(this.getEnd().getRawPosition(), this.getStart().getRawPosition());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public Range getRange() {
        try {
            return new Range(this.getStart().getPosition(), this.getEnd().getPosition());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean overlaps(MarkerRange arg_range) {
        if (this.getStart().getPosition() < arg_range.getStart().getPosition() && this.getEnd().getPosition() < arg_range.getStart().getPosition()) {
            return false;
        }
        return this.getStart().getPosition() <= arg_range.getEnd().getPosition() || this.getEnd().getPosition() <= arg_range.getEnd().getPosition();
    }

    public MarkerRange extendRange(MarkerRange arg_range) {
        return this.combineRanges(arg_range, true);
    }

    public MarkerRange combineRanges(MarkerRange arg_range, boolean truncate_if_contained) {
        MarkerRange return_range;
        if (this.getStrand() != arg_range.getStrand()) {
            throw new Error("internal error - strands do not match");
        }
        try {
            return_range = new MarkerRange(this.getStrand(), this.getStart().getPosition(), this.getEnd().getPosition());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        if (return_range.contains(arg_range)) {
            if (truncate_if_contained) {
                if (arg_range.getStart().getPosition() - return_range.getStart().getPosition() > return_range.getEnd().getPosition() - arg_range.getEnd().getPosition()) {
                    return_range.end = arg_range.getEnd();
                } else {
                    return_range.start = arg_range.getStart();
                }
            }
        } else {
            if (return_range.getStart().getPosition() > arg_range.getStart().getPosition()) {
                return_range.start = arg_range.getStart();
            }
            if (return_range.getEnd().getPosition() < arg_range.getEnd().getPosition()) {
                return_range.end = arg_range.getEnd();
            }
        }
        return return_range;
    }

    public boolean contains(MarkerRange arg_range) {
        return this.getStart().getPosition() <= arg_range.getStart().getPosition() && this.getEnd().getPosition() >= arg_range.getEnd().getPosition();
    }

    public Location createLocation() {
        try {
            Location new_location = new Location(this.getRawRange());
            if (this.getStrand().isForwardStrand()) {
                return new_location;
            }
            return new_location.getComplement();
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }
}

