/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml.xppdom;

import com.thoughtworks.xstream.io.xml.xppdom.Xpp3Dom;
import java.io.Reader;
import java.util.ArrayList;
import org.xmlpull.mxp1.MXParser;

public class Xpp3DomBuilder {
    public static Xpp3Dom build(Reader reader) throws Exception {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        Xpp3Dom configuration = null;
        MXParser parser = new MXParser();
        parser.setInput(reader);
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                String rawName = parser.getName();
                Xpp3Dom childConfiguration = Xpp3DomBuilder.createConfiguration(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                values.add(new StringBuffer());
                int attributesSize = parser.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                valueBuffer.append(parser.getText());
            } else if (eventType == 3) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                String accumulatedValue = values.remove(depth).toString();
                if (finishedConfiguration.getChildCount() == 0) {
                    String finishedValue = 0 == accumulatedValue.length() ? null : accumulatedValue;
                    finishedConfiguration.setValue(finishedValue);
                }
                if (0 == depth) {
                    configuration = finishedConfiguration;
                }
            }
            eventType = parser.next();
        }
        reader.close();
        return configuration;
    }

    private static Xpp3Dom createConfiguration(String localName) {
        return new Xpp3Dom(localName);
    }
}

