/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCDriver
implements Driver {
    public static final int MAJORVERSION = 1;
    public static final int MINORVERSION = 2;
    private static Constructor makeConn = null;
    protected Connection conn;

    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith("sqlite:/") || string.startsWith("jdbc:sqlite:/");
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        if (properties != null) {
            objectArray[1] = properties.getProperty("encoding");
        }
        if (objectArray[1] == null) {
            objectArray[1] = System.getProperty("SQLite.encoding");
        }
        try {
            this.conn = (Connection)makeConn.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        return this.conn;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 2;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("encoding", "");
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{driverPropertyInfo};
        return driverPropertyInfoArray;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            Class[] classArray;
            Class<?> clazz = null;
            classArray = new Class[]{Class.forName("java.lang.String"), classArray[0]};
            String string = System.getProperty("java.version");
            if (string == null || string.startsWith("1.0")) {
                throw new Exception("unsupported java version");
            }
            String string2 = string.startsWith("1.1") ? "SQLite.JDBC1.JDBCConnection" : (string.startsWith("1.2") || string.startsWith("1.3") ? "SQLite.JDBC2.JDBCConnection" : (string.startsWith("1.4") ? "SQLite.JDBC2x.JDBCConnection" : "SQLite.JDBC2y.JDBCConnection"));
            clazz = Class.forName(string2);
            makeConn = clazz.getConstructor(classArray);
            DriverManager.registerDriver(new JDBCDriver());
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

