/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.osgi.service.condpermadmin.Condition;

public class FrameworkSecurityManager
extends SecurityManager {
    ThreadLocal localCheckContext = new ThreadLocal();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager$CheckPermissionAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager$CheckContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    boolean addConditionsForDomain(Condition[][] condSet) {
        CheckContext cc = (CheckContext)this.localCheckContext.get();
        if (cc == null) {
            return false;
        }
        if (cc.depth > 0) {
            return false;
        }
        if (cc.condSets == null) {
            cc.condSets = new Vector();
        }
        cc.condSets.add(condSet);
        return true;
    }

    public void checkPermission(Permission perm, Object context) {
        AccessController.doPrivileged(new CheckPermissionAction(this, perm, context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void internalCheckPermission(Permission perm, Object context) {
        AccessControlContext acc = (AccessControlContext)context;
        CheckContext cc = (CheckContext)this.localCheckContext.get();
        if (cc != null) {
            ++cc.depth;
        } else {
            cc = new CheckContext();
            this.localCheckContext.set(cc);
        }
        try {
            acc.checkPermission(perm);
            if (cc.depth == 0 && cc.condSets != null) {
                Hashtable condContextDict = new Hashtable(2);
                boolean passed = false;
                Condition[][] conds = (Condition[][])cc.condSets.get(0);
                cc.condSets.removeElementAt(0);
                int i = 0;
                while (i < conds.length && !passed) {
                    passed = this.recursiveCheck(cc.condSets, conds[i], new Hashtable(2), condContextDict);
                    ++i;
                }
                if (!passed) {
                    throw new SecurityException("Conditions not satisfied");
                }
            }
            Object var9_11 = null;
            if (cc.depth == 0) {
                this.localCheckContext.set(null);
            }
            --cc.depth;
            return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (cc.depth == 0) {
                this.localCheckContext.set(null);
            }
            --cc.depth;
            throw throwable;
        }
    }

    private boolean recursiveCheck(Vector remainingSets, Condition[] conditions, Hashtable condDict, Hashtable condContextDict) {
        int i = 0;
        while (i < conditions.length) {
            if (conditions[i] != null) {
                Vector<Condition> condList = (Vector<Condition>)condDict.get(conditions[i].getClass());
                if (condList == null) {
                    condList = new Vector<Condition>();
                    condDict.put(conditions[i].getClass(), condList);
                }
                condList.add(conditions[i]);
            }
            ++i;
        }
        if (remainingSets.size() > 0) {
            boolean passed = false;
            Condition[][] conds = (Condition[][])remainingSets.get(0);
            Vector newSets = (Vector)remainingSets.clone();
            newSets.remove(0);
            int i2 = 0;
            while (i2 < conds.length) {
                passed = this.recursiveCheck(newSets, conds[i2], (Hashtable)condDict.clone(), condContextDict);
                if (passed) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        Enumeration keys = condDict.keys();
        while (keys.hasMoreElements()) {
            Class key = (Class)keys.nextElement();
            Vector conds = (Vector)condDict.get(key);
            if (conds.size() == 0) continue;
            Condition[] condArray = conds.toArray(new Condition[0]);
            Hashtable context = (Hashtable)condContextDict.get(key);
            if (context == null) {
                context = new Hashtable(2);
                condContextDict.put(key, context);
            }
            if (condArray[0].isSatisfied(condArray, context)) continue;
            return false;
        }
        return true;
    }

    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    static class CheckContext {
        int depth;
        Vector condSets;

        CheckContext() {
        }
    }

    static class CheckPermissionAction
    implements PrivilegedAction {
        Permission perm;
        Object context;
        FrameworkSecurityManager fsm;

        CheckPermissionAction(FrameworkSecurityManager fsm, Permission perm, Object context) {
            this.fsm = fsm;
            this.perm = perm;
            this.context = context;
        }

        public Object run() {
            this.fsm.internalCheckPermission(this.perm, this.context);
            return null;
        }
    }
}

