/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

class StateBuilder {
    static String[] DEFINED_MATCHING_ATTRS = new String[]{"bundle-symbolic-name", "bundle-version", "specification-version", "version"};
    static String[] DEFINED_OSGI_VALIDATE_HEADERS = new String[]{"Import-Package", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Bundle-SymbolicName", "Reexport-Package", "Require-Bundle"};

    StateBuilder() {
    }

    static BundleDescription createBundleDescription(StateImpl state, Dictionary manifest, String location) throws BundleException {
        ManifestElement[] symbolicNameElements;
        String symbolicNameHeader;
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        String manifestVersionHeader = (String)manifest.get("Bundle-ManifestVersion");
        int manifestVersion = 1;
        if (manifestVersionHeader != null) {
            manifestVersion = Integer.parseInt(manifestVersionHeader);
        }
        if (manifestVersion >= 2) {
            StateBuilder.validateHeaders(manifest);
        }
        if ((symbolicNameHeader = (String)manifest.get("Bundle-SymbolicName")) != null && (symbolicNameElements = ManifestElement.parseHeader("Bundle-SymbolicName", symbolicNameHeader)).length > 0) {
            result.setSymbolicName(symbolicNameElements[0].getValue());
            String singleton = symbolicNameElements[0].getDirective("singleton");
            if (singleton == null) {
                singleton = symbolicNameElements[0].getAttribute("singleton");
            }
            result.setStateBit(2, "true".equals(singleton));
            String fragmentAttachment = symbolicNameElements[0].getDirective("fragment-attachment");
            if (fragmentAttachment != null) {
                if (fragmentAttachment.equals("resolve-time")) {
                    result.setStateBit(64, true);
                    result.setStateBit(128, false);
                } else if (fragmentAttachment.equals("never")) {
                    result.setStateBit(64, false);
                    result.setStateBit(128, false);
                }
            }
        }
        String version = (String)manifest.get("Bundle-Version");
        try {
            result.setVersion(version != null ? Version.parseVersion(version) : Version.emptyVersion);
        }
        catch (NumberFormatException ex) {
            throw new BundleException(ex.getMessage());
        }
        result.setLocation(location);
        result.setPlatformFilter((String)manifest.get("Eclipse-PlatformFilter"));
        ManifestElement[] host = ManifestElement.parseHeader("Fragment-Host", (String)manifest.get("Fragment-Host"));
        if (host != null) {
            result.setHost(StateBuilder.createHostSpecification(host[0]));
        }
        ManifestElement[] exports = ManifestElement.parseHeader("Export-Package", (String)manifest.get("Export-Package"));
        ManifestElement[] reexports = ManifestElement.parseHeader("Reexport-Package", (String)manifest.get("Reexport-Package"));
        ManifestElement[] provides = ManifestElement.parseHeader("Provide-Package", (String)manifest.get("Provide-Package"));
        boolean strict = state != null && state.inStrictMode();
        ArrayList providedExports = new ArrayList(provides == null ? 0 : provides.length);
        result.setExportPackages(StateBuilder.createExportPackages(exports, reexports, provides, providedExports, manifestVersion, strict));
        ManifestElement[] imports = ManifestElement.parseHeader("Import-Package", (String)manifest.get("Import-Package"));
        ManifestElement[] dynamicImports = ManifestElement.parseHeader("DynamicImport-Package", (String)manifest.get("DynamicImport-Package"));
        result.setImportPackages(StateBuilder.createImportPackages(result.getExportPackages(), providedExports, imports, dynamicImports, manifestVersion));
        ManifestElement[] requires = ManifestElement.parseHeader("Require-Bundle", (String)manifest.get("Require-Bundle"));
        result.setRequiredBundles(StateBuilder.createRequiredBundles(requires));
        return result;
    }

    private static void validateHeaders(Dictionary manifest) throws BundleException {
        int i = 0;
        while (i < DEFINED_OSGI_VALIDATE_HEADERS.length) {
            String header = (String)manifest.get(DEFINED_OSGI_VALIDATE_HEADERS[i]);
            if (header != null) {
                ManifestElement[] elements = ManifestElement.parseHeader(DEFINED_OSGI_VALIDATE_HEADERS[i], header);
                StateBuilder.checkForDuplicateDirectives(elements);
                if (DEFINED_OSGI_VALIDATE_HEADERS[i] == "Reexport-Package") {
                    StateBuilder.checkForUsesDirective(elements);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[i] == "Import-Package" || DEFINED_OSGI_VALIDATE_HEADERS[i] == "DynamicImport-Package") {
                    StateBuilder.checkImportExportSyntax(elements, false);
                }
                if (DEFINED_OSGI_VALIDATE_HEADERS[i] == "Export-Package") {
                    StateBuilder.checkImportExportSyntax(elements, true);
                }
            } else if (DEFINED_OSGI_VALIDATE_HEADERS[i] == "Bundle-SymbolicName") {
                throw new BundleException(NLS.bind(StateMsg.HEADER_REQUIRED, "Bundle-SymbolicName"));
            }
            ++i;
        }
    }

    private static BundleSpecification[] createRequiredBundles(ManifestElement[] specs) {
        if (specs == null) {
            return null;
        }
        BundleSpecification[] result = new BundleSpecification[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = StateBuilder.createRequiredBundle(specs[i]);
            ++i;
        }
        return result;
    }

    private static BundleSpecification createRequiredBundle(ManifestElement spec) {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(StateBuilder.getVersionRange(spec.getAttribute("bundle-version")));
        result.setExported("reexport".equals(spec.getDirective("visibility")) || "true".equals(spec.getAttribute("reprovide")));
        result.setOptional("optional".equals(spec.getDirective("resolution")) || "true".equals(spec.getAttribute("optional")));
        return result;
    }

    private static ImportPackageSpecification[] createImportPackages(ExportPackageDescription[] exported, ArrayList providedExports, ManifestElement[] imported, ManifestElement[] dynamicImported, int manifestVersion) throws BundleException {
        int i;
        ArrayList<ImportPackageSpecificationImpl> allImports = null;
        if (manifestVersion < 2) {
            if (exported.length == 0 && imported == null && dynamicImported == null) {
                return null;
            }
            allImports = new ArrayList(exported.length + (imported == null ? 0 : imported.length));
            i = 0;
            while (i < exported.length) {
                if (!providedExports.contains(exported[i].getName())) {
                    ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
                    result.setName(exported[i].getName());
                    result.setVersionRange(StateBuilder.getVersionRange(exported[i].getVersion().toString()));
                    result.setDirective("resolution", "static");
                    allImports.add(result);
                }
                ++i;
            }
        } else {
            allImports = new ArrayList<ImportPackageSpecificationImpl>(imported == null ? 0 : imported.length);
        }
        if (dynamicImported != null) {
            i = 0;
            while (i < dynamicImported.length) {
                StateBuilder.addImportPackages(dynamicImported[i], allImports, manifestVersion, true);
                ++i;
            }
        }
        if (imported != null) {
            i = 0;
            while (i < imported.length) {
                StateBuilder.addImportPackages(imported[i], allImports, manifestVersion, false);
                ++i;
            }
        }
        return allImports.toArray(new ImportPackageSpecification[allImports.size()]);
    }

    private static void addImportPackages(ManifestElement importPackage, ArrayList allImports, int manifestVersion, boolean dynamic) throws BundleException {
        String[] importNames = importPackage.getValueComponents();
        int i = 0;
        while (i < importNames.length) {
            if (manifestVersion < 2) {
                Iterator iter = allImports.iterator();
                while (iter.hasNext()) {
                    if (!importNames[i].equals(((ImportPackageSpecification)iter.next()).getName())) continue;
                    iter.remove();
                }
            }
            ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
            result.setName(importNames[i]);
            String versionString = importPackage.getAttribute("version");
            if (versionString == null) {
                versionString = importPackage.getAttribute("specification-version");
            }
            result.setVersionRange(StateBuilder.getVersionRange(versionString));
            result.setBundleSymbolicName(importPackage.getAttribute("bundle-symbolic-name"));
            result.setBundleVersionRange(StateBuilder.getVersionRange(importPackage.getAttribute("bundle-version")));
            if (manifestVersion >= 2) {
                result.setAttributes(StateBuilder.getAttributes(importPackage, DEFINED_MATCHING_ATTRS));
            }
            if (dynamic) {
                result.setDirective("resolution", "dynamic");
            } else {
                result.setDirective("resolution", StateBuilder.getResolution(importPackage.getDirective("resolution")));
            }
            allImports.add(result);
            ++i;
        }
    }

    private static String getResolution(String resolution) {
        String result = "static";
        if ("optional".equals(resolution)) {
            result = "optional";
        }
        return result;
    }

    static ExportPackageDescription[] createExportPackages(ManifestElement[] exported, ManifestElement[] reexported, ManifestElement[] provides, ArrayList providedExports, int manifestVersion, boolean strict) throws BundleException {
        int i;
        int numExports = (exported == null ? 0 : exported.length) + (reexported == null ? 0 : reexported.length) + (provides == null ? 0 : provides.length);
        if (numExports == 0) {
            return null;
        }
        ArrayList allExports = new ArrayList(numExports);
        if (exported != null) {
            i = 0;
            while (i < exported.length) {
                StateBuilder.addExportPackages(exported[i], allExports, manifestVersion, false, strict);
                ++i;
            }
        }
        if (reexported != null) {
            i = 0;
            while (i < reexported.length) {
                StateBuilder.addExportPackages(reexported[i], allExports, manifestVersion, true, strict);
                ++i;
            }
        }
        if (provides != null) {
            StateBuilder.addProvidePackages(provides, allExports, providedExports);
        }
        return allExports.toArray(new ExportPackageDescription[allExports.size()]);
    }

    private static void addExportPackages(ManifestElement exportPackage, ArrayList allExports, int manifestVersion, boolean reexported, boolean strict) throws BundleException {
        String[] exportNames = exportPackage.getValueComponents();
        int i = 0;
        while (i < exportNames.length) {
            if (!strict || !"true".equals(exportPackage.getDirective("x-internal"))) {
                ExportPackageDescriptionImpl result = new ExportPackageDescriptionImpl();
                result.setName(exportNames[i]);
                String versionString = exportPackage.getAttribute("version");
                if (versionString == null) {
                    versionString = exportPackage.getAttribute("specification-version");
                }
                if (versionString != null) {
                    result.setVersion(Version.parseVersion(versionString));
                }
                result.setDirective("uses", ManifestElement.getArrayFromList(exportPackage.getDirective("uses")));
                result.setDirective("include", exportPackage.getDirective("include"));
                result.setDirective("exclude", exportPackage.getDirective("exclude"));
                result.setDirective("x-friends", ManifestElement.getArrayFromList(exportPackage.getDirective("x-friends")));
                result.setDirective("x-internal", Boolean.valueOf(exportPackage.getDirective("x-internal")));
                result.setDirective("mandatory", ManifestElement.getArrayFromList(exportPackage.getDirective("mandatory")));
                result.setAttributes(StateBuilder.getAttributes(exportPackage, DEFINED_MATCHING_ATTRS));
                result.setRoot(!reexported);
                allExports.add(result);
            }
            ++i;
        }
    }

    private static void addProvidePackages(ManifestElement[] provides, ArrayList allExports, ArrayList providedExports) throws BundleException {
        ExportPackageDescription[] currentExports = allExports.toArray(new ExportPackageDescription[allExports.size()]);
        int i = 0;
        while (i < provides.length) {
            boolean duplicate = false;
            int j = 0;
            while (j < currentExports.length) {
                if (provides[i].getValue().equals(currentExports[j].getName())) {
                    duplicate = true;
                    break;
                }
                ++j;
            }
            if (!duplicate) {
                ExportPackageDescriptionImpl result = new ExportPackageDescriptionImpl();
                result.setName(provides[i].getValue());
                result.setRoot(true);
                allExports.add(result);
            }
            providedExports.add(provides[i].getValue());
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Map getAttributes(ManifestElement exportPackage, String[] definedAttrs) {
        keys = exportPackage.getKeys();
        arbitraryAttrs = null;
        if (keys != null) ** GOTO lbl19
        return null;
lbl-1000:
        // 1 sources

        {
            definedAttr = false;
            key = (String)keys.nextElement();
            i = 0;
            while (i < definedAttrs.length) {
                if (definedAttrs[i].equals(key)) {
                    definedAttr = true;
                    break;
                }
                ++i;
            }
            if (definedAttr) continue;
            if (arbitraryAttrs == null) {
                arbitraryAttrs = new HashMap<String, String>();
            }
            arbitraryAttrs.put(key, exportPackage.getAttribute(key));
lbl19:
            // 3 sources

            ** while (keys.hasMoreElements())
        }
lbl20:
        // 1 sources

        return arbitraryAttrs;
    }

    private static HostSpecification createHostSpecification(ManifestElement spec) {
        if (spec == null) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(StateBuilder.getVersionRange(spec.getAttribute("bundle-version")));
        result.setIsMultiHost("true".equals(spec.getDirective("multiple-hosts")));
        return result;
    }

    private static VersionRange getVersionRange(String versionRange) {
        if (versionRange == null) {
            return null;
        }
        return new VersionRange(versionRange);
    }

    private static void checkImportExportSyntax(ManifestElement[] elements, boolean export) throws BundleException {
        if (elements == null) {
            return;
        }
        int length = elements.length;
        HashSet<String> packages = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            String specVersion;
            String[] packageNames = elements[i].getValueComponents();
            int j = 0;
            while (j < packageNames.length) {
                if (packages.contains(packageNames[j])) {
                    throw new BundleException(StateMsg.HEADER_PACKAGE_DUPLICATES);
                }
                if (packageNames[j].startsWith("java.")) {
                    throw new BundleException(StateMsg.HEADER_PACKAGE_JAVA);
                }
                packages.add(packageNames[j]);
                ++j;
            }
            String version = elements[i].getAttribute("version");
            if (version != null && (specVersion = elements[i].getAttribute("specification-version")) != null && !specVersion.equals(version)) {
                throw new BundleException(NLS.bind(StateMsg.HEADER_VERSION_ERROR, "version", "specification-version"));
            }
            if (export) {
                if (elements[i].getAttribute("bundle-symbolic-name") != null) {
                    throw new BundleException(NLS.bind(StateMsg.HEADER_EXPORT_ATTR_ERROR, "bundle-symbolic-name", "Export-Package"));
                }
                if (elements[i].getAttribute("bundle-version") != null) {
                    throw new BundleException(NLS.bind(StateMsg.HEADER_EXPORT_ATTR_ERROR, "bundle-version", "Export-Package"));
                }
            }
            ++i;
        }
    }

    private static void checkForDuplicateDirectives(ManifestElement[] elements) throws BundleException {
        int i = 0;
        while (i < elements.length) {
            Enumeration keys = elements[i].getDirectiveKeys();
            if (keys != null) {
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String[] directives = elements[i].getDirectives(key);
                    if (directives.length <= 1) continue;
                    throw new BundleException(StateMsg.HEADER_DIRECTIVE_DUPLICATES);
                }
            }
            ++i;
        }
    }

    private static void checkForUsesDirective(ManifestElement[] elements) throws BundleException {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getDirective("uses") != null) {
                throw new BundleException(NLS.bind(StateMsg.HEADER_REEXPORT_USES, "uses", "Reexport-Package"));
            }
            ++i;
        }
    }
}

