/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelResolver;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.ModelAdapter;

public class SmarterModelAdapter
extends ModelAdapter {
    static final int UNKNOWN = -1;
    static final int XYZ = 0;
    static final int MOL = 1;
    static final int JME = 2;
    static final int PDB = 3;

    public SmarterModelAdapter(ModelAdapter.Logger logger) {
        super("SmarterModelAdapter", logger);
    }

    public void finish(Object clientFile) {
        ((Model)clientFile).finish();
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        try {
            Object modelOrErrorMessage = ModelResolver.resolveModel(name, bufferedReader, this.logger);
            if (modelOrErrorMessage instanceof String) {
                return modelOrErrorMessage;
            }
            if (modelOrErrorMessage instanceof Model) {
                Model model = (Model)modelOrErrorMessage;
                if (model.errorMessage != null) {
                    return model.errorMessage;
                }
                return model;
            }
            return "unknown reader error";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "" + e;
        }
    }

    public String getFileTypeName(Object clientFile) {
        return ((Model)clientFile).modelTypeName;
    }

    public String getModelSetName(Object clientFile) {
        return ((Model)clientFile).modelName;
    }

    public String getModelFileHeader(Object clientFile) {
        return ((Model)clientFile).fileHeader;
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return ((Model)clientFile).atomCount;
    }

    public boolean coordinatesAreFractional(Object clientFile) {
        return ((Model)clientFile).coordinatesAreFractional;
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        return ((Model)clientFile).notionalUnitcell;
    }

    public float[] getPdbScaleMatrix(Object clientFile) {
        return ((Model)clientFile).pdbScaleMatrix;
    }

    public float[] getPdbScaleTranslate(Object clientFile) {
        return ((Model)clientFile).pdbScaleTranslate;
    }

    public ModelAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator((Model)clientFile);
    }

    public ModelAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator((Model)clientFile);
    }

    public ModelAdapter.StructureIterator getStructureIterator(Object clientFile) {
        Model model = (Model)clientFile;
        return model.structureCount == 0 ? null : new StructureIterator(model);
    }

    public class StructureIterator
    extends ModelAdapter.StructureIterator {
        int structureCount;
        Structure[] structures;
        Structure structure;
        int istructure;

        StructureIterator(Model model) {
            super(SmarterModelAdapter.this);
            this.structureCount = model.structureCount;
            this.structures = model.structures;
            this.istructure = 0;
        }

        public boolean hasNext() {
            if (this.istructure == this.structureCount) {
                return false;
            }
            this.structure = this.structures[this.istructure++];
            return true;
        }

        public String getStructureType() {
            return this.structure.structureType;
        }

        public char getStartChainID() {
            return ModelAdapter.canonizeChainID(this.structure.startChainID);
        }

        public int getStartSequenceNumber() {
            return this.structure.startSequenceNumber;
        }

        public char getStartInsertionCode() {
            return ModelAdapter.canonizeInsertionCode(this.structure.startInsertionCode);
        }

        public char getEndChainID() {
            return ModelAdapter.canonizeChainID(this.structure.endChainID);
        }

        public int getEndSequenceNumber() {
            return this.structure.endSequenceNumber;
        }

        public char getEndInsertionCode() {
            return this.structure.endInsertionCode;
        }
    }

    class BondIterator
    extends ModelAdapter.BondIterator {
        Model model;
        Atom[] atoms;
        Bond[] bonds;
        int ibond;
        Bond bond;

        BondIterator(Model model) {
            super(SmarterModelAdapter.this);
            this.model = model;
            this.atoms = model.atoms;
            this.bonds = model.bonds;
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.model.bondCount) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return this.atoms[this.bond.atomIndex1];
        }

        public Object getAtomUniqueID2() {
            return this.atoms[this.bond.atomIndex2];
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends ModelAdapter.AtomIterator {
        Model model;
        int iatom;
        Atom atom;

        AtomIterator(Model model) {
            super(SmarterModelAdapter.this);
            this.model = model;
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.model.atomCount) {
                return false;
            }
            this.atom = this.model.atoms[this.iatom++];
            return true;
        }

        public int getModelNumber() {
            return this.atom.modelNumber;
        }

        public Object getUniqueID() {
            return this.atom;
        }

        public String getElementSymbol() {
            if (this.atom.elementSymbol != null) {
                return this.atom.elementSymbol;
            }
            return this.atom.getElementSymbol();
        }

        public int getElementNumber() {
            return this.atom.elementNumber;
        }

        public String getAtomName() {
            return this.atom.atomName;
        }

        public int getFormalCharge() {
            return this.atom.formalCharge;
        }

        public float getPartialCharge() {
            return this.atom.partialCharge;
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }

        public float getVectorX() {
            return this.atom.vectorX;
        }

        public float getVectorY() {
            return this.atom.vectorY;
        }

        public float getVectorZ() {
            return this.atom.vectorZ;
        }

        public float getBfactor() {
            return this.atom.bfactor;
        }

        public int getOccupancy() {
            return this.atom.occupancy;
        }

        public boolean getIsHetero() {
            return this.atom.isHetero;
        }

        public int getAtomSerial() {
            return this.atom.atomSerial;
        }

        public char getChainID() {
            return ModelAdapter.canonizeChainID(this.atom.chainID);
        }

        public String getGroup3() {
            return this.atom.group3;
        }

        public int getSequenceNumber() {
            return this.atom.sequenceNumber;
        }

        public char getInsertionCode() {
            return ModelAdapter.canonizeInsertionCode(this.atom.insertionCode);
        }

        public String getPdbAtomRecord() {
            return this.atom.pdbAtomRecord;
        }
    }
}

