/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomType;

public class Atom
extends AtomType
implements Serializable,
Cloneable {
    protected Point2d point2d = null;
    protected Point3d point3d = null;
    protected Point3d fractionalPoint3d = null;
    protected int hydrogenCount;
    protected int stereoParity;
    protected double charge;

    public Atom() {
        this(null);
    }

    public Atom(String elementSymbol) {
        super(elementSymbol);
    }

    public Atom(String elementSymbol, Point3d point3d) {
        this(elementSymbol);
        this.point3d = point3d;
    }

    public Atom(String elementSymbol, Point2d point2d) {
        this(elementSymbol);
        this.point2d = point2d;
    }

    public void setCharge(double charge) {
        this.charge = charge;
    }

    public double getCharge() {
        return this.charge;
    }

    public void setHydrogenCount(int hydrogenCount) {
        this.hydrogenCount = hydrogenCount;
    }

    public int getHydrogenCount() {
        return this.hydrogenCount;
    }

    public void setPoint2d(Point2d point2d) {
        this.point2d = point2d;
    }

    public void setPoint3d(Point3d point3d) {
        this.point3d = point3d;
    }

    public void setFractionalPoint3d(Point3d point3d) {
        this.fractionalPoint3d = point3d;
    }

    public void setStereoParity(int stereoParity) {
        this.stereoParity = stereoParity;
    }

    public Point2d getPoint2d() {
        return this.point2d;
    }

    public Point3d getPoint3d() {
        return this.point3d;
    }

    public Point3d getFractionalPoint3d() {
        return this.fractionalPoint3d;
    }

    public double getX2d() {
        if (this.point2d == null) {
            return 0.0;
        }
        return this.point2d.x;
    }

    public double getY2d() {
        if (this.point2d == null) {
            return 0.0;
        }
        return this.point2d.y;
    }

    public double getX3d() {
        if (this.point3d == null) {
            return 0.0;
        }
        return this.point3d.x;
    }

    public double getY3d() {
        if (this.point3d == null) {
            return 0.0;
        }
        return this.point3d.y;
    }

    public double getZ3d() {
        if (this.point3d == null) {
            return 0.0;
        }
        return this.point3d.z;
    }

    public void setFractX3d(double x) {
        if (this.fractionalPoint3d == null) {
            this.fractionalPoint3d = new Point3d();
        }
        this.fractionalPoint3d.x = x;
    }

    public void setFractY3d(double y) {
        if (this.fractionalPoint3d == null) {
            this.fractionalPoint3d = new Point3d();
        }
        this.fractionalPoint3d.y = y;
    }

    public void setFractZ3d(double z) {
        if (this.fractionalPoint3d == null) {
            this.fractionalPoint3d = new Point3d();
        }
        this.fractionalPoint3d.z = z;
    }

    public double getFractX3d() {
        if (this.fractionalPoint3d == null) {
            return 0.0;
        }
        return this.fractionalPoint3d.x;
    }

    public double getFractY3d() {
        if (this.fractionalPoint3d == null) {
            return 0.0;
        }
        return this.fractionalPoint3d.y;
    }

    public double getFractZ3d() {
        if (this.fractionalPoint3d == null) {
            return 0.0;
        }
        return this.fractionalPoint3d.z;
    }

    public void setX2d(double x) {
        if (this.point2d == null) {
            this.point2d = new Point2d();
        }
        this.point2d.x = x;
    }

    public void setY2d(double y) {
        if (this.point2d == null) {
            this.point2d = new Point2d();
        }
        this.point2d.y = y;
    }

    public void setX3d(double x) {
        if (this.point3d == null) {
            this.point3d = new Point3d();
        }
        this.point3d.x = x;
    }

    public void setY3d(double y) {
        if (this.point3d == null) {
            this.point3d = new Point3d();
        }
        this.point3d.y = y;
    }

    public void setZ3d(double z) {
        if (this.point3d == null) {
            this.point3d = new Point3d();
        }
        this.point3d.z = z;
    }

    public int getStereoParity() {
        return this.stereoParity;
    }

    public boolean compare(Object object) {
        if (!(object instanceof Atom)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Atom atom = (Atom)object;
        return (this.point2d == atom.point2d || this.point2d != null && this.point2d.equals(atom.point2d)) && (this.point3d == atom.point3d || this.point3d != null && this.point3d.equals(atom.point3d)) && this.hydrogenCount == atom.hydrogenCount && this.stereoParity == atom.stereoParity && this.charge == atom.charge;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Atom(");
        s.append(this.hashCode() + ", ");
        s.append(this.getSymbol() + ", ");
        s.append("H:" + this.getHydrogenCount() + ", ");
        s.append("SP:" + this.getStereoParity() + ", ");
        s.append("2D:[" + this.getPoint2d() + "], ");
        s.append("3D:[" + this.getPoint3d() + "], ");
        s.append("Fract3D:[" + this.getFractionalPoint3d() + "], ");
        s.append("C:" + this.getCharge() + ", ");
        s.append("FC:" + this.getFormalCharge());
        s.append(", " + super.toString());
        s.append(")");
        return s.toString();
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return o;
    }
}

