/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;

public class ChemFile
extends ChemObject
implements Serializable,
Cloneable {
    protected ChemSequence[] chemSequences = new ChemSequence[this.growArraySize];
    protected int chemSequenceCount = 0;
    protected int growArraySize = 4;

    public void addChemSequence(ChemSequence chemSequence) {
        if (this.chemSequenceCount + 1 >= this.chemSequences.length) {
            this.growChemSequenceArray();
        }
        this.chemSequences[this.chemSequenceCount] = chemSequence;
        ++this.chemSequenceCount;
    }

    public ChemSequence[] getChemSequences() {
        ChemSequence[] returnChemSequences = new ChemSequence[this.getChemSequenceCount()];
        System.arraycopy(this.chemSequences, 0, returnChemSequences, 0, returnChemSequences.length);
        return returnChemSequences;
    }

    public ChemSequence getChemSequence(int number) {
        return this.chemSequences[number];
    }

    protected void growChemSequenceArray() {
        this.growArraySize = this.chemSequences.length;
        ChemSequence[] newchemSequences = new ChemSequence[this.chemSequences.length + this.growArraySize];
        System.arraycopy(this.chemSequences, 0, newchemSequences, 0, this.chemSequences.length);
        this.chemSequences = newchemSequences;
    }

    public int getChemSequenceCount() {
        return this.chemSequenceCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ChemFile(#S=");
        ChemSequence[] seqs = this.getChemSequences();
        buffer.append(seqs.length);
        buffer.append(", ");
        for (int i = 0; i < seqs.length; ++i) {
            ChemSequence sequence = seqs[i];
            buffer.append(sequence.toString());
        }
        buffer.append(")");
        return buffer.toString();
    }
}

