/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Element;

public class Isotope
extends Element
implements Serializable,
Cloneable {
    public double exactMass = -1.0;
    public double naturalAbundance = -1.0;
    private int massNumber = 0;

    public Isotope(String elementSymbol) {
        super(elementSymbol);
    }

    public Isotope(int atomicNumber, String elementSymbol, int massNumber, double exactMass, double nA) {
        this(atomicNumber, elementSymbol, exactMass, nA);
        this.massNumber = massNumber;
    }

    public Isotope(int atomicNumber, String elementSymbol, double exactMass, double nA) {
        super(elementSymbol, atomicNumber);
        this.exactMass = exactMass;
        this.naturalAbundance = nA;
    }

    public Isotope(String elementSymbol, int massNumber) {
        super(elementSymbol);
        this.massNumber = massNumber;
    }

    public void setNaturalAbundance(double naturalAbundance) {
        this.naturalAbundance = naturalAbundance;
    }

    public void setExactMass(double exactMass) {
        this.exactMass = exactMass;
    }

    public double getNaturalAbundance() {
        return this.naturalAbundance;
    }

    public double getExactMass() {
        return this.exactMass;
    }

    public int getMassNumber() {
        return this.massNumber;
    }

    public void setMassNumber(int massNumber) {
        this.massNumber = massNumber;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return o;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Isotope(");
        sb.append(this.massNumber);
        sb.append(", EM:");
        sb.append(this.exactMass);
        sb.append(", AB:");
        sb.append(this.naturalAbundance);
        sb.append(", ");
        sb.append(super.toString());
        sb.append(")");
        return sb.toString();
    }

    public boolean compare(Object object) {
        if (!(object instanceof Isotope)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Isotope isotope = (Isotope)object;
        return this.massNumber == isotope.massNumber && this.exactMass == isotope.exactMass && this.naturalAbundance == isotope.naturalAbundance;
    }
}

