/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Reaction;

public class SetOfReactions
extends ChemObject
implements Serializable,
Cloneable {
    protected Reaction[] reactions = new Reaction[this.growArraySize];
    protected int reactionCount = 0;
    protected int growArraySize = 5;

    public void addReaction(Reaction reaction) {
        if (this.reactionCount + 1 >= this.reactions.length) {
            this.growReactionArray();
        }
        this.reactions[this.reactionCount] = reaction;
        ++this.reactionCount;
    }

    public Reaction[] getReactions() {
        Reaction[] result = new Reaction[this.reactionCount];
        for (int i = 0; i < this.reactionCount; ++i) {
            result[i] = this.reactions[i];
        }
        return result;
    }

    protected void growReactionArray() {
        this.growArraySize = this.reactions.length;
        Reaction[] newreactions = new Reaction[this.reactions.length + this.growArraySize];
        System.arraycopy(this.reactions, 0, newreactions, 0, this.reactions.length);
        this.reactions = newreactions;
    }

    public int getReactionCount() {
        return this.reactionCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SetOfReactions(");
        buffer.append(this.hashCode() + ", ");
        buffer.append("R=" + this.getReactionCount() + ", ");
        Reaction[] reactions = this.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            buffer.append(reactions[i].toString());
        }
        buffer.append(")");
        return buffer.toString();
    }
}

