/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.tools.LoggingTool;

public class Gaussian03Reader
extends DefaultChemObjectReader {
    private IsotopeFactory isotopeFactory;
    private BufferedReader input;
    private LoggingTool logger;

    public Gaussian03Reader(Reader reader) {
        this.input = new BufferedReader(reader);
        this.logger = new LoggingTool(this);
        try {
            this.isotopeFactory = IsotopeFactory.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Gaussian03Reader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "Gaussian 2003";
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = this.input;
    }

    public boolean accepts(ChemObject object) {
        if (object instanceof ChemSequence) {
            return true;
        }
        return object instanceof ChemFile;
    }

    public boolean matches(int lineNumber, String line) {
        return line.indexOf("Gaussian(R) 03") >= 0;
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemSequence) {
            return this.readChemSequence();
        }
        if (object instanceof ChemFile) {
            return this.readChemFile();
        }
        throw new CDKException("Object " + object.getClass().getName() + " is not supported");
    }

    public void close() throws IOException {
        this.input.close();
    }

    private ChemFile readChemFile() throws CDKException {
        ChemFile chemFile = new ChemFile();
        ChemSequence sequence = this.readChemSequence();
        chemFile.addChemSequence(sequence);
        return chemFile;
    }

    private ChemSequence readChemSequence() throws CDKException {
        ChemSequence sequence = new ChemSequence();
        ChemModel model = null;
        try {
            String line = this.input.readLine();
            String levelOfTheory = null;
            while (this.input.ready() && line != null) {
                if (line.indexOf("Standard orientation:") >= 0) {
                    model = new ChemModel();
                    try {
                        this.readCoordinates(model);
                        break;
                    }
                    catch (IOException exception) {
                        throw new CDKException("Error while reading coordinates: " + exception.toString());
                    }
                }
                line = this.input.readLine();
            }
            if (model != null) {
                line = this.input.readLine();
                while (this.input.ready() && line != null) {
                    if (line.indexOf("Standard orientation:") >= 0) {
                        sequence.addChemModel(model);
                        this.fireFrameRead();
                        model = new ChemModel();
                        this.readCoordinates(model);
                    } else if (line.indexOf("SCF Done:") >= 0) {
                        model.setProperty("org.openscience.cdk.io.Gaussian03Reaer:SCF Done", line.trim());
                    } else if (line.indexOf("Harmonic frequencies") >= 0) {
                        try {
                            this.readFrequencies(model);
                        }
                        catch (IOException exception) {
                            throw new CDKException("Error while reading frequencies: " + exception.toString());
                        }
                    } else if (line.indexOf("Mulliken atomic charges") >= 0) {
                        this.readPartialCharges(model);
                    } else if (line.indexOf("Magnetic shielding") >= 0) {
                        try {
                            this.readNMRData(model, line);
                        }
                        catch (IOException exception) {
                            throw new CDKException("Error while reading NMR data: " + exception.toString());
                        }
                    } else if (line.indexOf("GINC") >= 0) {
                        levelOfTheory = this.parseLevelOfTheory(line);
                    }
                    line = this.input.readLine();
                }
                sequence.addChemModel(model);
                this.fireFrameRead();
            }
        }
        catch (IOException exception) {
            throw new CDKException("Error while reading general structure: " + exception.toString());
        }
        return sequence;
    }

    private void readCoordinates(ChemModel model) throws CDKException, IOException {
        AtomContainer container = new AtomContainer();
        String line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        while (this.input.ready() && (line = this.input.readLine()) != null && line.indexOf("-----") < 0) {
            int atomicNumber = 0;
            StringReader sr = new StringReader(line);
            StreamTokenizer token = new StreamTokenizer(sr);
            token.nextToken();
            if (token.nextToken() == -2) {
                atomicNumber = (int)token.nval;
                if (atomicNumber == 0) {
                    continue;
                }
            } else {
                throw new IOException("Error reading coordinates");
            }
            token.nextToken();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            x = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            y = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            z = token.nval;
            Atom atom = new Atom(this.isotopeFactory.getElementSymbol(atomicNumber));
            atom.setPoint3d(new Point3d(x, y, z));
            container.addAtom(atom);
        }
        SetOfMolecules moleculeSet = new SetOfMolecules();
        moleculeSet.addMolecule(new Molecule(container));
        model.setSetOfMolecules(moleculeSet);
    }

    private void readPartialCharges(ChemModel model) throws CDKException, IOException {
        this.logger.info("Reading partial atomic charges");
        SetOfMolecules moleculeSet = model.getSetOfMolecules();
        Molecule molecule = moleculeSet.getMolecule(0);
        String line = this.input.readLine();
        while (this.input.ready()) {
            line = this.input.readLine();
            this.logger.debug("Read charge block line: " + line);
            if (line == null || line.indexOf("Sum of Mulliken charges") >= 0) {
                this.logger.debug("End of charge block found");
                break;
            }
            StringReader sr = new StringReader(line);
            StreamTokenizer tokenizer = new StreamTokenizer(sr);
            if (tokenizer.nextToken() != -2) continue;
            int atomCounter = (int)tokenizer.nval;
            tokenizer.nextToken();
            double charge = 0.0;
            if (tokenizer.nextToken() != -2) {
                throw new CDKException("Error while reading charge: expected double.");
            }
            charge = tokenizer.nval;
            this.logger.debug("Found charge for atom " + atomCounter + ": " + charge);
            Atom atom = molecule.getAtomAt(atomCounter - 1);
            atom.setCharge(charge);
        }
    }

    private void readFrequencies(ChemModel model) throws IOException {
    }

    private void readNMRData(ChemModel model, String labelLine) throws IOException {
    }

    private String parseLevelOfTheory(String line) {
        StringTokenizer st1 = new StringTokenizer(line, "\\");
        if (st1.countTokens() < 6) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            st1.nextToken();
        }
        return st1.nextToken() + "/" + st1.nextToken();
    }
}

