/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.ichi.IChIHandler;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IChIReader
extends DefaultChemObjectReader {
    private XMLReader parser;
    private Reader input;
    private LoggingTool logger;

    public IChIReader(Reader input) {
        this.init();
        this.input = input;
    }

    public IChIReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "IUPAC Chemical Identifier";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input;
    }

    public boolean matches(int lineNumber, String line) {
        return line.indexOf("<identifier") != -1;
    }

    private void init() {
        this.logger = new LoggingTool(this.getClass().getName());
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                this.logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate JAXP/SAX XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                this.logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Aelfred2 XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                this.logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Xerces XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            this.logger.error("Could not instantiate any XML parser!");
        }
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile();
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile() {
        ChemFile cf = null;
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.logger.info("Deactivated validation");
        }
        catch (SAXException e) {
            this.logger.warn("Cannot deactivate validation.");
        }
        IChIHandler handler = new IChIHandler();
        this.parser.setContentHandler((ContentHandler)handler);
        try {
            this.parser.parse(new InputSource(this.input));
            cf = handler.getChemFile();
        }
        catch (IOException e) {
            this.logger.error((Object)"IOException: ", e.getMessage());
            this.logger.debug(e);
        }
        catch (SAXException saxe) {
            this.logger.error((Object)"SAXException: ", saxe.getClass().getName());
            this.logger.debug(saxe);
        }
        return cf;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

