/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class PMPReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger;
    private SetOfMolecules som;
    private ChemModel modelModel;
    private Molecule molecule;
    private ChemObject chemObject;
    private Hashtable atomids = new Hashtable();
    private Hashtable bondids = new Hashtable();
    Pattern objHeader;
    Pattern objCommand;
    Pattern atomTypePattern;

    public PMPReader(Reader input) {
        this.input = new BufferedReader(input);
        this.logger = new LoggingTool(this.getClass().getName());
        this.objHeader = Pattern.compile(".*\\((\\d+)\\s(\\w+)$");
        this.objCommand = Pattern.compile(".*\\(A\\s(C|F|D|I|O)\\s(\\w+)\\s+\"?(.*?)\"?\\)$");
        this.atomTypePattern = Pattern.compile("^(\\d+)\\s+(\\w+)$");
    }

    public PMPReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "PolyMorph Predictor (Cerius)";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return line.startsWith("%%Header Start");
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile();
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile() {
        ChemFile chemFile = new ChemFile();
        ChemSequence chemSequence = new ChemSequence();
        ChemModel chemModel = new ChemModel();
        Crystal crystal = new Crystal();
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                if (line.startsWith("%%Header Start")) {
                    while (this.input.ready() && line != null && !line.startsWith("%%Header End")) {
                        String version;
                        if (line.startsWith("%%Version Number") && !(version = this.input.readLine().trim()).equals("3.00")) {
                            this.logger.error("The PMPReader only supports PMP files with version 3.00");
                            return null;
                        }
                        line = this.input.readLine();
                    }
                } else if (line.startsWith("%%Model Start")) {
                    while (this.input.ready() && line != null && !line.startsWith("%%Model End")) {
                        Matcher objHeaderMatcher = this.objHeader.matcher(line);
                        if (objHeaderMatcher.matches()) {
                            String object = objHeaderMatcher.group(2);
                            this.constructObject(object);
                            int id = Integer.parseInt(objHeaderMatcher.group(1));
                            line = this.input.readLine();
                            while (this.input.ready() && line != null && !line.trim().equals(")")) {
                                Matcher objCommandMatcher = this.objCommand.matcher(line);
                                objHeaderMatcher = this.objHeader.matcher(line);
                                if (objHeaderMatcher.matches()) {
                                    object = objHeaderMatcher.group(2);
                                    id = Integer.parseInt(objHeaderMatcher.group(1));
                                    this.constructObject(object);
                                } else if (objCommandMatcher.matches()) {
                                    String format = objCommandMatcher.group(1);
                                    String command = objCommandMatcher.group(2);
                                    String field = objCommandMatcher.group(3);
                                    this.processModelCommand(object, command, format, field);
                                } else {
                                    this.logger.warn("Skipping line: " + line);
                                }
                                line = this.input.readLine();
                            }
                            if (this.chemObject instanceof Atom) {
                                this.atomids.put(new Integer(id), new Integer(this.molecule.getAtomCount()));
                                this.molecule.addAtom((Atom)this.chemObject);
                            } else if (this.chemObject instanceof Bond) {
                                this.bondids.put(new Integer(id), new Integer(this.molecule.getAtomCount()));
                                this.molecule.addBond((Bond)this.chemObject);
                            } else {
                                this.logger.error("chemObject is not initialized or of bad class type");
                            }
                        }
                        line = this.input.readLine();
                    }
                    this.som.addMolecule(this.molecule);
                    this.modelModel.setSetOfMolecules(this.som);
                } else if (line.startsWith("%%Traj Start")) {
                    chemSequence = new ChemSequence();
                    while (this.input.ready() && line != null && !line.startsWith("%%Traj End")) {
                        if (line.startsWith("%%Start Frame")) {
                            chemModel = new ChemModel();
                            crystal = new Crystal();
                            AtomContainer atomC = ChemModelManipulator.getAllInOneContainer(this.modelModel);
                            while (this.input.ready() && line != null && !line.startsWith("%%End Frame")) {
                                if (line.startsWith("%%Atom Coords")) {
                                    crystal.add((AtomContainer)atomC.clone());
                                    int expatoms = atomC.getAtomCount();
                                    for (int i = 0; i < expatoms; ++i) {
                                        line = this.input.readLine();
                                        Atom a = crystal.getAtomAt(i);
                                        StringTokenizer st = new StringTokenizer(line, " ");
                                        a.setX3d(Double.parseDouble(st.nextToken()));
                                        a.setY3d(Double.parseDouble(st.nextToken()));
                                        a.setZ3d(Double.parseDouble(st.nextToken()));
                                    }
                                } else if (line.startsWith("%%Lat Vects")) {
                                    line = this.input.readLine();
                                    StringTokenizer st = new StringTokenizer(line, " ");
                                    crystal.setA(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                                    line = this.input.readLine();
                                    st = new StringTokenizer(line, " ");
                                    crystal.setB(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                                    line = this.input.readLine();
                                    st = new StringTokenizer(line, " ");
                                    crystal.setC(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                                } else if (line.startsWith("%%Space Group")) {
                                    line = this.input.readLine().trim();
                                    if ("P 21 21 21 (1)".equals(line)) {
                                        crystal.setSpaceGroup("P 2_1 2_1 2_1");
                                    } else {
                                        crystal.setSpaceGroup("P1");
                                    }
                                }
                                line = this.input.readLine();
                            }
                            chemModel.setCrystal(crystal);
                            chemSequence.addChemModel(chemModel);
                        }
                        line = this.input.readLine();
                    }
                    chemFile.addChemSequence(chemSequence);
                }
                line = this.input.readLine();
            }
        }
        catch (IOException e) {
            chemFile = null;
        }
        return chemFile;
    }

    private void processModelCommand(String object, String command, String format, String field) {
        this.logger.debug(object + "->" + command + " (" + format + "): " + field);
        if ("Model".equals(object)) {
            this.logger.warn("Unkown PMP Model command: " + command);
        } else if ("Atom".equals(object)) {
            if ("ACL".equals(command)) {
                Matcher atomTypeMatcher = this.atomTypePattern.matcher(field);
                if (atomTypeMatcher.matches()) {
                    int atomicnum = Integer.parseInt(atomTypeMatcher.group(1));
                    String type = atomTypeMatcher.group(2);
                    ((Atom)this.chemObject).setAtomicNumber(atomicnum);
                    ((Atom)this.chemObject).setSymbol(type);
                } else {
                    this.logger.error("Incorrectly formated field value: " + field + ".");
                }
            } else if ("Charge".equals(command)) {
                try {
                    double charge = Double.parseDouble(field);
                    ((Atom)this.chemObject).setCharge(charge);
                }
                catch (NumberFormatException e) {
                    this.logger.error("Incorrectly formated float field: " + field + ".");
                }
            } else if (!("CMAPPINGS".equals(command) || "FFType".equals(command) || "Id".equals(command) || "Mass".equals(command) || "XYZ".equals(command) || "ZOrder".equals(command))) {
                this.logger.warn("Unkown PMP Atom command: " + command);
            }
        } else if ("Bond".equals(object)) {
            if ("Atom1".equals(command)) {
                int atomid = Integer.parseInt(field);
                int realatomid = (Integer)this.atomids.get(new Integer(atomid));
                Atom a = this.molecule.getAtomAt(realatomid);
                ((Bond)this.chemObject).setAtomAt(a, 0);
            } else if ("Atom2".equals(command)) {
                int atomid = Integer.parseInt(field);
                int realatomid = (Integer)this.atomids.get(new Integer(atomid));
                Atom a = this.molecule.getAtomAt(realatomid);
                ((Bond)this.chemObject).setAtomAt(a, 1);
            } else if ("Order".equals(command)) {
                double order = Double.parseDouble(field);
                ((Bond)this.chemObject).setOrder(order);
            } else if (!("Id".equals(command) || "Label".equals(command) || "3DGridOrigin".equals(command) || "3DGridMatrix".equals(command) || "3DGridDivision".equals(command))) {
                this.logger.warn("Unkown PMP Bond command: " + command);
            }
        } else {
            this.logger.warn("Unkown PMP object: " + object);
        }
    }

    private void constructObject(String object) {
        if ("Atom".equals(object)) {
            this.chemObject = new Atom("C");
        } else if ("Bond".equals(object)) {
            this.chemObject = new Bond();
        } else if ("Model".equals(object)) {
            this.modelModel = new ChemModel();
            this.som = new SetOfMolecules();
            this.molecule = new Molecule();
        } else {
            this.logger.error("Cannot construct PMP object type: " + object);
        }
    }

    public void close() throws IOException {
        this.input.close();
    }
}

