/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;

public class XYZReader
extends DefaultChemObjectReader {
    private BufferedReader input;

    public XYZReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public XYZReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "XYZ";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return false;
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile();
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile() {
        ChemFile file = new ChemFile();
        ChemSequence chemSequence = new ChemSequence();
        int number_of_atoms = 0;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t ,;");
                String token = tokenizer.nextToken();
                number_of_atoms = Integer.parseInt(token);
                String info = this.input.readLine();
                ChemModel chemModel = new ChemModel();
                SetOfMolecules setOfMolecules = new SetOfMolecules();
                Molecule m = new Molecule();
                m.setProperty("Title", info);
                for (int i = 0; i < number_of_atoms && (line = this.input.readLine()) != null; ++i) {
                    if (line.startsWith("#")) continue;
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    double charge = 0.0;
                    tokenizer = new StringTokenizer(line, "\t ,;");
                    int fields = tokenizer.countTokens();
                    if (fields < 4) continue;
                    String atomtype = tokenizer.nextToken();
                    x = new Double(tokenizer.nextToken());
                    y = new Double(tokenizer.nextToken());
                    z = new Double(tokenizer.nextToken());
                    if (fields == 8) {
                        charge = new Double(tokenizer.nextToken());
                    }
                    Atom atom = new Atom(atomtype, new Point3d(x, y, z));
                    atom.setCharge(charge);
                    m.addAtom(atom);
                }
                setOfMolecules.addMolecule(m);
                chemModel.setSetOfMolecules(setOfMolecules);
                chemSequence.addChemModel(chemModel);
                line = this.input.readLine();
            }
            file.addChemSequence(chemSequence);
        }
        catch (IOException e) {
            file = null;
        }
        return file;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

