/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.StringTokenizer;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ModuleInterface;
import org.openscience.cdk.io.cml.cdopi.CDOInterface;
import org.xml.sax.Attributes;

public class CDKConvention
extends CMLCoreModule {
    private boolean isBond;

    public CDKConvention(CDOInterface cdo) {
        super(cdo);
    }

    public CDKConvention(ModuleInterface conv) {
        super(conv);
    }

    public CDOInterface returnCDO() {
        return this.cdo;
    }

    public void startDocument() {
        super.startDocument();
        this.isBond = false;
    }

    public void endDocument() {
        super.endDocument();
    }

    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        String name = raw;
        this.isBond = false;
        if (xpath.toString().endsWith("string/")) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("buildin") || !atts.getValue(i).equals("order")) continue;
                this.isBond = true;
            }
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        super.endElement(xpath, uri, local, raw);
    }

    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        String s = new String(ch, start, length).trim();
        if (this.isBond) {
            this.logger.debug("CharData (bond): " + s);
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreElements()) {
                String border = (String)st.nextElement();
                this.logger.debug("new bond order: " + border);
                this.cdo.setObjectProperty("Bond", "order", border);
            }
        } else {
            super.characterData(xpath, ch, start, length);
        }
    }
}

