/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.setting;

import java.util.Vector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.setting.IOSetting;

public class OptionIOSetting
extends IOSetting {
    private Vector settings;

    public OptionIOSetting(String name, int level, String question, Vector settings, String defaultSetting) {
        super(name, level, question, defaultSetting);
        this.settings = settings;
        if (!this.settings.contains(defaultSetting)) {
            this.settings.add(defaultSetting);
        }
    }

    public void setSetting(String setting) throws CDKException {
        if (!this.settings.contains(setting)) {
            throw new CDKException("Setting " + setting + " is not allowed.");
        }
        this.setting = setting;
    }

    public void setSetting(int setting) throws CDKException {
        if (setting >= this.settings.size() + 1 || setting <= 0) {
            throw new CDKException("Setting " + setting + " does not exist.");
        }
        this.setting = (String)this.settings.elementAt(setting - 1);
    }

    public Vector getOptions() {
        return this.settings;
    }
}

