/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.Serializable;
import org.openscience.cdk.Atom;
import org.openscience.cdk.math.Primes;

public class InvPair
implements Serializable {
    public static String INVARIANCE_PAIR = "InvariancePair";
    private long last = 0L;
    private long curr = 0L;
    private Atom atom;
    private int prime;

    public InvPair() {
    }

    public InvPair(long c, Atom a) {
        this.curr = c;
        this.atom = a;
        a.setProperty(INVARIANCE_PAIR, this);
    }

    public long getLast() {
        return this.last;
    }

    public void setCurr(long newCurr) {
        this.curr = newCurr;
    }

    public long getCurr() {
        return this.curr;
    }

    public boolean equals(Object e) {
        if (e instanceof InvPair) {
            InvPair o = (InvPair)e;
            return this.last == o.getLast() && this.curr == o.getCurr();
        }
        return false;
    }

    public void setLast(long newLast) {
        this.last = newLast;
    }

    public void setAtom(Atom newAtom) {
        this.atom = newAtom;
    }

    public Atom getAtom() {
        return this.atom;
    }

    public void comit() {
        this.atom.setProperty("CanonicalLable", new Long(this.curr));
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.curr);
        buff.append("\t");
        return buff.toString();
    }

    public int getPrime() {
        return this.prime;
    }

    public void setPrime() {
        this.prime = Primes.getPrimeAt((int)((int)this.curr - 1));
    }
}

