/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.atomtypes;

import java.util.Vector;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AtomTypeHandler
extends DefaultHandler {
    private final int SCALAR_UNSET = 0;
    private final int SCALAR_MAXBONDORDER = 1;
    private final int SCALAR_BONDORDERSUM = 2;
    private LoggingTool logger = new LoggingTool(this);
    private String currentChars;
    private Vector atomTypes;
    private int scalarType;
    private AtomType atomType;

    public Vector getAtomTypes() {
        return this.atomTypes;
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        this.logger.info("DocType root element: " + name);
        this.logger.info("DocType root PUBLIC: " + publicId);
        this.logger.info("DocType root SYSTEM: " + systemId);
    }

    public void startDocument() {
        this.atomTypes = new Vector();
        this.scalarType = 0;
        this.atomType = null;
    }

    public void endDocument() {
    }

    public void endElement(String uri, String local, String raw) {
        this.logger.debug((Object)"END Element: ", raw);
        this.logger.debug((Object)"  uri: ", uri);
        this.logger.debug((Object)"  local: ", local);
        this.logger.debug((Object)"  raw: ", raw);
        this.logger.debug((Object)"  chars: ", this.currentChars.trim());
        if ("atomType".equals(local)) {
            this.atomTypes.addElement(this.atomType);
        } else if ("scalar".equals(local)) {
            try {
                double value = Double.parseDouble(this.currentChars.trim());
                if (this.scalarType == 2) {
                    this.atomType.setBondOrderSum(value);
                } else if (this.scalarType == 1) {
                    this.atomType.setMaxBondOrder(value);
                }
            }
            catch (NumberFormatException exception) {
                this.logger.error((Object)"Value is not the expected double: ", this.currentChars);
                this.logger.debug(exception);
            }
            this.scalarType = 0;
        }
        this.currentChars = "";
    }

    public void startElement(String uri, String local, String raw, Attributes atts) {
        block8: {
            block9: {
                block7: {
                    this.currentChars = "";
                    this.logger.debug((Object)"START Element: ", raw);
                    this.logger.debug((Object)"  uri: ", uri);
                    this.logger.debug((Object)"  local: ", local);
                    this.logger.debug((Object)"  raw: ", raw);
                    if (!"atomType".equals(local)) break block7;
                    this.atomType = new AtomType("R");
                    for (int i = 0; i < atts.getLength(); ++i) {
                        if (!"id".equals(atts.getQName(i))) continue;
                        this.atomType.setAtomTypeName(atts.getValue(i));
                    }
                    break block8;
                }
                if (!"atom".equals(local)) break block9;
                for (int i = 0; i < atts.getLength(); ++i) {
                    if ("elementType".equals(atts.getQName(i))) {
                        this.atomType.setSymbol(atts.getValue(i));
                        continue;
                    }
                    if (!"formalCharge".equals(atts.getQName(i))) continue;
                    try {
                        this.atomType.setFormalCharge(Integer.parseInt(atts.getValue(i)));
                        continue;
                    }
                    catch (NumberFormatException exception) {
                        this.logger.error("Value of <atom> @", atts.getQName(i), " is not an integer: ", atts.getValue(i));
                        this.logger.debug(exception);
                    }
                }
                break block8;
            }
            if (!"scalar".equals(local)) break block8;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!"dictRef".equals(atts.getQName(i))) continue;
                if ("cdk:maxBondOrder".equals(atts.getValue(i))) {
                    this.scalarType = 1;
                    continue;
                }
                if (!"cdk:bondOrderSum".equals(atts.getValue(i))) continue;
                this.scalarType = 2;
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.logger.debug("character data");
        this.currentChars = this.currentChars + new String(ch, start, length);
    }
}

