/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.io.IOException;
import java.io.Reader;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.applications.plugin.CDKEditBus;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.tools.AtomTypeFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.jmol.viewer.JmolViewer;

public class JmolEditBus
implements CDKEditBus {
    private static final String APIVersion = "1.8";
    private JmolViewer viewer = null;

    public JmolEditBus(JmolViewer viewer) {
        this.viewer = viewer;
    }

    public String getAPIVersion() {
        return APIVersion;
    }

    public void showChemFile(Reader file) {
        this.viewer.openReader("", "", file);
    }

    public void showChemFile(ChemFile file) {
        AtomContainer atomContainer = ChemFileManipulator.getAllInOneContainer(file);
        Atom[] atoms = atomContainer.getAtoms();
        if (atoms.length == 0) {
            System.err.println("ChemFile does not contain atoms.");
            return;
        }
        if (!GeometryTools.has3DCoordinates(atomContainer) && !CrystalGeometryTools.hasCrystalCoordinates(atomContainer)) {
            System.err.println("Cannot display chemistry without 3D coordinates");
            return;
        }
        try {
            AtomTypeFactory factory = AtomTypeFactory.getInstance("jmol_atomtypes.txt");
            for (int i = 0; i < atoms.length; ++i) {
                try {
                    factory.configure(atoms[i]);
                    continue;
                }
                catch (CDKException exception) {
                    System.out.println("Could not configure atom: " + atoms[i]);
                }
            }
        }
        catch (ClassNotFoundException exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        catch (IOException exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        this.viewer.openClientFile("", "", file);
    }

    public void showChemModel(ChemModel model) {
        ChemFile file = new ChemFile();
        ChemSequence sequence = new ChemSequence();
        sequence.addChemModel(model);
        file.addChemSequence(sequence);
        this.showChemFile(file);
    }

    public ChemModel getChemModel() {
        throw new NoSuchMethodError();
    }

    public ChemFile getChemFile() {
        throw new NoSuchMethodError();
    }
}

