/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.openscience.jmol.ui.JmolPopupAwt;
import org.openscience.jmol.ui.JmolPopupSwing;
import org.openscience.jmol.ui.PopupResourceBundle;
import org.openscience.jmol.viewer.JmolConstants;
import org.openscience.jmol.viewer.JmolViewer;

public abstract class JmolPopup {
    private static final boolean forceAwt = false;
    JmolViewer viewer;
    Component jmolComponent;
    MenuItemListener mil;
    Object elementsComputedMenu;
    Object aaresiduesComputedMenu;
    Hashtable htCheckbox = new Hashtable();

    JmolPopup(JmolViewer viewer) {
        this.viewer = viewer;
        this.jmolComponent = viewer.getAwtComponent();
        this.mil = new MenuItemListener();
    }

    public static JmolPopup newJmolPopup(JmolViewer viewer) {
        if (!viewer.jvm12orGreater) {
            return new JmolPopupAwt(viewer);
        }
        return new JmolPopupSwing(viewer);
    }

    void build(Object popupMenu) {
        this.addMenuItems("popupMenu", popupMenu, new PopupResourceBundle());
        this.addVersionAndDate();
    }

    public void updateComputedMenus() {
        if (this.elementsComputedMenu != null) {
            BitSet elementsPresentBitSet = this.viewer.getElementsPresentBitSet();
            this.updateElementsComputedMenu(elementsPresentBitSet);
        }
        BitSet groupsPresentBitSet = this.viewer.getGroupsPresentBitSet();
        if (this.aaresiduesComputedMenu != null) {
            this.updateAaresiduesComputedMenu(groupsPresentBitSet);
        }
    }

    void updateElementsComputedMenu(BitSet elementsPresentBitSet) {
        this.removeAll(this.elementsComputedMenu);
        for (int i = 0; i < JmolConstants.elementNames.length; ++i) {
            if (!elementsPresentBitSet.get(i)) continue;
            String elementName = JmolConstants.elementNames[i];
            String elementSymbol = JmolConstants.elementSymbols[i];
            String entryName = elementSymbol + " - " + elementName;
            String script = "select " + elementName;
            this.addMenuItem(this.elementsComputedMenu, entryName, script);
        }
    }

    void updateAaresiduesComputedMenu(BitSet groupsPresentBitSet) {
        this.removeAll(this.aaresiduesComputedMenu);
        for (int i = 1; i < 23; ++i) {
            if (!groupsPresentBitSet.get(i)) continue;
            String aaresidueName = JmolConstants.predefinedGroup3Names[i];
            String script = "select " + aaresidueName;
            this.addMenuItem(this.aaresiduesComputedMenu, aaresidueName, script);
        }
    }

    private void addVersionAndDate() {
        this.addMenuSeparator();
        this.addMenuItem("Jmol 10pre15");
        this.addMenuItem(JmolConstants.date);
    }

    private void addMenuItems(String key, Object menu, PopupResourceBundle popupResourceBundle) {
        String value = popupResourceBundle.getStructure(key);
        if (value == null) {
            this.addMenuItem(menu, "#" + key, null);
            return;
        }
        StringTokenizer st = new StringTokenizer(value);
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            String word = popupResourceBundle.getWord(item);
            if (item.endsWith("Menu")) {
                Object subMenu = this.newMenu(word);
                if ("elementsComputedMenu".equals(item)) {
                    this.elementsComputedMenu = subMenu;
                } else if ("aaresiduesComputedMenu".equals(item)) {
                    this.aaresiduesComputedMenu = subMenu;
                } else {
                    this.addMenuItems(item, subMenu, popupResourceBundle);
                }
                this.addMenuSubMenu(menu, subMenu);
                continue;
            }
            if ("-".equals(item)) {
                this.addMenuSeparator(menu);
                continue;
            }
            if (item.endsWith("Checkbox")) {
                String basename = item.substring(0, item.length() - 8);
                this.addCheckboxMenuItem(menu, word, basename);
                continue;
            }
            this.addMenuItem(menu, word, popupResourceBundle.getStructure(item));
        }
    }

    void rememberCheckbox(String key, Object checkboxMenuItem) {
        this.htCheckbox.put(key, checkboxMenuItem);
    }

    public abstract void show(int var1, int var2);

    abstract void addMenuSeparator();

    abstract void addMenuSeparator(Object var1);

    abstract void addMenuItem(String var1);

    abstract void addMenuItem(Object var1, String var2, String var3);

    abstract void addCheckboxMenuItem(Object var1, String var2, String var3);

    abstract void addMenuSubMenu(Object var1, Object var2);

    abstract Object newMenu(String var1);

    abstract void removeAll(Object var1);

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String script = e.getActionCommand();
            if (script != null) {
                JmolPopup.this.viewer.evalString(script);
            }
        }
    }
}

